/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.javaee.model.common.persistence.mapping.NamedQuery;
import com.intellij.jpa.JpaMessages;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistenceQuery;
import com.intellij.persistence.roles.PersistenceRoleHolder;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JpaQueryReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jpa/JpaQueryReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/jpa/JpaQueryReferenceProvider", "getReferencesByElement"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module != null) {
            String queryName = String.valueOf(JamCommonUtil.computeMemberValue((PsiElement)element));
            List facets = PersistenceCommonUtil.getAllPersistenceFacetsWithDependencies((Module)module);
            PsiReference[] psiReferenceArray = new PsiReference[]{new QueryReference(element, queryName, facets)};
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/JpaQueryReferenceProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/JpaQueryReferenceProvider", "getReferencesByElement"));
        }
        return PsiReference.EMPTY_ARRAY;
    }

    public boolean acceptsTarget(@NotNull PsiElement target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/jpa/JpaQueryReferenceProvider", "acceptsTarget"));
        }
        return JamCommonUtil.getModelObject((PsiElement)target) instanceof NamedQuery;
    }

    public static class QueryReference
    extends QueryRelatedReference {
        private final String myQueryName;
        private final List<PersistenceFacet> myFacets;
        private String myLocalName;

        public QueryReference(PsiElement element, String queryName, List<PersistenceFacet> facets) {
            super(element);
            this.myQueryName = queryName;
            this.myFacets = facets;
        }

        @Nullable
        public PersistenceQuery resolveQuery() {
            PersistenceQuery query;
            if (StringUtil.isEmpty((String)this.myQueryName)) {
                return null;
            }
            this.myLocalName = null;
            CommonProcessors.FindFirstProcessor<PersistenceQuery> processor = new CommonProcessors.FindFirstProcessor<PersistenceQuery>(){

                public boolean process(PersistenceQuery persistenceQuery) {
                    return !Comparing.equal((String)myQueryName, (String)((String)persistenceQuery.getName().getValue()), (boolean)true) || super.process((Object)persistenceQuery);
                }
            };
            PersistenceRoleHolder roleHolder = PersistenceRoleHolder.getInstance((Project)this.myElement.getProject());
            for (PersistenceFacet facet : this.myFacets) {
                if (!roleHolder.processMergedQueries(facet, (Processor)processor)) break;
            }
            PersistenceQuery persistenceQuery = query = processor.isFound() ? (PersistenceQuery)processor.getFoundValue() : null;
            if (query != null) {
                this.myLocalName = query.getName().getStringValue();
            }
            return query;
        }

        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            String text = this.getRangeInElement().substring(this.myElement.getText());
            String realNewName = text.endsWith(this.myLocalName) && text.length() > this.myLocalName.length() ? text.substring(0, text.length() - this.myLocalName.length()) + newElementName : newElementName;
            return super.handleElementRename(realNewName);
        }

        public PsiElement resolve() {
            PersistenceQuery persistenceQuery = this.resolveQuery();
            return persistenceQuery == null ? null : persistenceQuery.getIdentifyingPsiElement();
        }

        @NotNull
        public Object[] getVariants() {
            final ArrayList result = new ArrayList();
            Processor<PersistenceQuery> processor = new Processor<PersistenceQuery>(){

                public boolean process(PersistenceQuery persistenceQuery) {
                    String name = (String)persistenceQuery.getName().getValue();
                    if (StringUtil.isNotEmpty((String)name)) {
                        String query = (String)persistenceQuery.getQuery().getValue();
                        LookupElementBuilder lookupItem = LookupElementBuilder.create((String)name);
                        if (StringUtil.isNotEmpty((String)query)) {
                            int maxDisplayChars = 30;
                            String text = query.length() < maxDisplayChars ? query : query.substring(0, maxDisplayChars) + "...";
                            lookupItem = lookupItem.withTypeText(text);
                        }
                        result.add(lookupItem);
                    }
                    return true;
                }
            };
            PersistenceRoleHolder holder = PersistenceRoleHolder.getInstance((Project)this.myElement.getProject());
            for (PersistenceFacet facet : this.myFacets) {
                if (!holder.processMergedQueries(facet, (Processor)processor)) break;
            }
            Object[] objectArray = result.toArray();
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/JpaQueryReferenceProvider$QueryReference", "getVariants"));
            }
            return objectArray;
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            String string = JpaMessages.message((String)"cannot.resolve.query.0", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/JpaQueryReferenceProvider$QueryReference", "getUnresolvedMessagePattern"));
            }
            return string;
        }
    }

    public static abstract class QueryRelatedReference
    extends PsiReferenceBase<PsiElement>
    implements EmptyResolveMessageProvider,
    LocalQuickFixProvider {
        public QueryRelatedReference(PsiElement element) {
            super(element, false);
        }

        public LocalQuickFix[] getQuickFixes() {
            return LocalQuickFix.EMPTY_ARRAY;
        }
    }
}

