/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.engine;

import com.intellij.database.DataBus;
import com.intellij.database.SimpleRequestBroker;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.jpa.engine.JpaConnectionManager;
import com.intellij.jpa.engine.JpaConsoleBase;
import com.intellij.jpa.engine.JpaEngine;
import com.intellij.jpa.ql.JpqlLanguage;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.persistence.model.PersistencePackagePointer;
import icons.J2EEIcons;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JpaConsole
extends JpaConsoleBase {
    public static final String CONSOLE_TOOLWINDOW_ID = "JPA Console";

    @NotNull
    public static JpaConsoleBase.Builder<JpaConsole> newConsole(@NotNull PersistencePackagePointer unitFile) {
        if (unitFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unitFile", "com/intellij/jpa/engine/JpaConsole", "newConsole"));
        }
        JpaConsoleBase.Builder<JpaConsole> builder = new JpaConsoleBase.Builder<JpaConsole>(unitFile){

            @Override
            public JpaConsole build() {
                SimpleRequestBroker broker = SimpleRequestBroker.newInstance((Project)this.getProject(), (String)this.myUnitFile.getElementName());
                JpaConsole console = new JpaConsole(this.myUnitFile, this.myConfiguration, (DataBus.Consuming)broker, this.myQuery);
                JpaEngine engine = new JpaEngine((DataBus.Producing)broker, this.myUnitFile, this.myConfiguration);
                Disposer.register((Disposable)console, (Disposable)engine);
                return console;
            }
        };
        if (builder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/engine/JpaConsole", "newConsole"));
        }
        return builder;
    }

    private JpaConsole(@NotNull PersistencePackagePointer unitFile, @NotNull ConsoleRunConfiguration configuration, @NotNull DataBus.Consuming messageBus, @Nullable String query) {
        if (unitFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unitFile", "com/intellij/jpa/engine/JpaConsole", "<init>"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/jpa/engine/JpaConsole", "<init>"));
        }
        if (messageBus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageBus", "com/intellij/jpa/engine/JpaConsole", "<init>"));
        }
        super(unitFile, configuration, messageBus, "jpaql", JpaConsole.getInitialLanguage(unitFile), query);
        this.getLanguageConsole().setPrompt("jpa-ql> ");
    }

    public static List<JpaConsole> getActiveConsoles(Project project) {
        return JpaConsole.getActiveConsoles((Project)project, (String)CONSOLE_TOOLWINDOW_ID);
    }

    private static Language getInitialLanguage(PersistencePackagePointer file) {
        boolean isHibernate = JpaUtil.isHibernateProvider(file.getPersistenceFacet(), file.findElement());
        boolean isEql = JpaUtil.isEclipseLinkProvider(file.getPersistenceFacet(), file.findElement());
        return isHibernate ? JpqlLanguage.HQL : (isEql ? JpqlLanguage.EQL : JpqlLanguage.JPQL);
    }

    public String getToolWindowId() {
        return CONSOLE_TOOLWINDOW_ID;
    }

    public Icon getToolWindowIcon() {
        return J2EEIcons.JpaConsoleToolWindow;
    }

    @Override
    protected String getHelpID() {
        return "tool.window.reference.jpa.console";
    }

    @Override
    public boolean isStarted() {
        return JpaConnectionManager.getInstance(this.getProject()).getActiveConfigurations((PersistencePackagePointer)this.getTarget()).contains(this.getConfiguration());
    }

    @Override
    public void terminate() {
        JpaConnectionManager.getInstance(this.getProject()).releaseConnection((PersistencePackagePointer)this.getTarget(), this.getConfiguration());
    }
}

