/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.engine;

import com.intellij.database.DataBus;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridDataHookUpManager;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.run.AbstractQueryLanguageConsole;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.execution.console.ConsoleHistoryController;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.facet.Facet;
import com.intellij.facet.impl.FacetUtil;
import com.intellij.icons.AllIcons;
import com.intellij.jpa.AbstractQlModel;
import com.intellij.jpa.engine.JpaConsole;
import com.intellij.jpa.engine.QlScriptModel;
import com.intellij.jpa.ql.JpqlLanguage;
import com.intellij.jpa.ql.QlFile;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistencePackagePointer;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.persistence.util.PersistenceModelBrowser;
import com.intellij.psi.PsiElement;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.content.Content;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import icons.DatabaseIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JpaConsoleBase
extends AbstractQueryLanguageConsole<PersistencePackagePointer> {
    private final PersistencePackagePointer myUnitFile;
    private final ConsoleRunConfiguration myConfiguration;
    private SyntaxHighlighter myHighlighter;
    private final QlScriptModel myScriptModel;

    protected JpaConsoleBase(@NotNull PersistencePackagePointer unitFile, @NotNull ConsoleRunConfiguration configuration, @NotNull DataBus.Consuming messageBus, @NotNull String historyId, @NotNull Language language, @Nullable String query) {
        if (unitFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unitFile", "com/intellij/jpa/engine/JpaConsoleBase", "<init>"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/jpa/engine/JpaConsoleBase", "<init>"));
        }
        if (messageBus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageBus", "com/intellij/jpa/engine/JpaConsoleBase", "<init>"));
        }
        if (historyId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "historyId", "com/intellij/jpa/engine/JpaConsoleBase", "<init>"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/jpa/engine/JpaConsoleBase", "<init>"));
        }
        super(unitFile.getFacetPointer().getProject(), messageBus, (Object)unitFile, unitFile.getElementName(), language);
        this.myUnitFile = unitFile;
        this.myConfiguration = configuration;
        ConsoleHistoryController controller = new ConsoleHistoryController(historyId, ((VirtualFile)unitFile).getPresentableUrl(), this.getLanguageConsole());
        this.getLanguageConsole().setInputText(StringUtil.notNullize((String)query));
        this.myScriptModel = new QlScriptModel((QlFile)this.getLanguageConsole().getFile());
        Disposer.register((Disposable)this, (Disposable)this.myScriptModel);
        controller.install();
    }

    @NotNull
    public QlScriptModel getScriptModel() {
        QlScriptModel qlScriptModel = this.myScriptModel;
        if (qlScriptModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/engine/JpaConsoleBase", "getScriptModel"));
        }
        return qlScriptModel;
    }

    protected abstract String getHelpID();

    public abstract boolean isStarted();

    public abstract void terminate();

    @NotNull
    public ConsoleRunConfiguration getConfiguration() {
        ConsoleRunConfiguration consoleRunConfiguration = this.myConfiguration;
        if (consoleRunConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/engine/JpaConsoleBase", "getConfiguration"));
        }
        return consoleRunConfiguration;
    }

    protected DataAuditor.ConsoleLogger createHistoryLogger() {
        return new DataAuditor.ConsoleLogger((ConsoleView)this.getLanguageConsole()){

            public void print(@NotNull DataRequest.Context context, @Nullable String message) {
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/jpa/engine/JpaConsoleBase$1", "print"));
                }
                if (context.request instanceof GenerateSql) {
                    JpaConsoleBase.this.printSql(message);
                } else {
                    super.print(context, message);
                }
            }
        };
    }

    protected void buildConsoleUi(boolean focused) {
        boolean isHibernate = this.getLanguageConsole().getFile().getLanguage() == JpqlLanguage.HQL;
        this.getLanguageConsole().getFile().putUserData(QlFile.PERSISTENCE_MODEL_KEY, (Object)new MyAbstractQlModel(this.getProject(), this.myUnitFile, isHibernate));
        AnAction toggleAction = this.initParameterView();
        this.myDataConsumer.resetOutputTabCounter();
        this.getUi().getDefaults().initTabDefaults(0, null, null);
        this.getUi().getOptions().setMoveToGridActionEnabled(false).setMinimizeActionEnabled(false);
        JBLoadingPanel loadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this);
        loadingPanel.setLoadingText("");
        loadingPanel.add((Component)this.getLanguageConsole().getComponent(), (Object)"Center");
        Content output = this.getUi().createContent("Input", (JComponent)loadingPanel, this.getTitle(), AllIcons.Debugger.Console, this.getLanguageConsole().getPreferredFocusableComponent());
        output.setActions((ActionGroup)this.createActionGroup(toggleAction), "unknown", this.getLanguageConsole().getConsoleEditor().getComponent());
        output.setCloseable(false);
        this.getUi().addContent(output, 0, PlaceInGrid.center, false);
    }

    private String collectQueryTextAndParams(ScriptModel.StatementIt<?> it, final Map<Object, String> params) {
        final boolean isHibernate = !(this instanceof JpaConsole);
        String text = it.text(this.myPStorage, new Condition<ScriptModel.ParamIt<?>>(){

            public boolean value(ScriptModel.ParamIt<?> o) {
                String s = o.name();
                String value = String.valueOf(JpaConsoleBase.this.myPStorage.getValue((Object)s));
                if (s.startsWith("?")) {
                    String key;
                    String name = s.substring(1);
                    try {
                        key = name.isEmpty() ? Integer.valueOf(params.size() + (isHibernate ? 0 : 1)) : (isHibernate ? name : Integer.valueOf(Integer.parseInt(name)));
                    }
                    catch (NumberFormatException e) {
                        key = name;
                    }
                    params.put(key, value);
                    return true;
                }
                if (s.startsWith(":")) {
                    String name = s.substring(1);
                    if (StringUtil.isJavaIdentifier((String)name)) {
                        params.put(name, value);
                        return true;
                    }
                } else {
                    int num = StringUtil.parseInt((String)s, (int)0);
                    if (num > 0) {
                        params.put(isHibernate ? num - 1 : num, value);
                        return true;
                    }
                }
                return false;
            }
        });
        return text;
    }

    public GridDataHookUp<DataConsumer.Row, DataConsumer.Column> createGridDataHookUp(@NotNull Disposable parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/jpa/engine/JpaConsoleBase", "createGridDataHookUp"));
        }
        return GridDataHookUpManager.getInstance((Project)this.getProject()).createJpaHookUp(this.getMessageBus(), parent);
    }

    public void executeQueries(@NotNull Editor sourceEditor, @NotNull ScriptModel<?> model) {
        if (sourceEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceEditor", "com/intellij/jpa/engine/JpaConsoleBase", "executeQueries"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/jpa/engine/JpaConsoleBase", "executeQueries"));
        }
        ScriptModel.StatementIt it = model.statements();
        while (it.hasNext()) {
            it.next();
            this.executeQueryInner(it);
        }
    }

    private void executeQueryInner(ScriptModel.StatementIt<?> it) {
        HashMap params = ContainerUtil.newHashMap();
        String query = this.collectQueryTextAndParams(it, params);
        if (StringUtil.isEmpty((String)query)) {
            return;
        }
        ConsoleHistoryController.addToHistory((LanguageConsoleView)this.getLanguageConsole(), (String)query);
        List columnNames = (List)it.resultType(null);
        LoadRequest request = new LoadRequest((DataRequest.Owner)this, query, params, columnNames);
        this.getMessageBus().getDataProducer().processRequest((DataRequest)request);
    }

    public void generateSQL() {
        this.myParamPanel.commit();
        ScriptModel.StatementIt<PsiElement> it = this.myScriptModel.statements();
        if (!it.hasNext()) {
            return;
        }
        it.next();
        String query = this.collectQueryTextAndParams(it, new HashMap<Object, String>());
        this.getLanguageConsole().print("> " + query + "\n", ConsoleViewContentType.USER_INPUT);
        if (query.isEmpty()) {
            return;
        }
        this.getMessageBus().getDataProducer().processRequest((DataRequest)new GenerateSql((DataRequest.OwnerEx)this, query, Command.QUERY));
    }

    public void generateDDL() {
        this.getMessageBus().getDataProducer().processRequest((DataRequest)new GenerateSql((DataRequest.OwnerEx)this, "", Command.DDL));
    }

    private DefaultActionGroup createActionGroup(AnAction toggleAction) {
        DefaultActionGroup group = new DefaultActionGroup();
        RunAction runAction = new RunAction();
        DumbAwareAction sqlAction = new DumbAwareAction(null, null, DatabaseIcons.ExportSQL){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/jpa/engine/JpaConsoleBase$3", "actionPerformed"));
                }
                JpaConsoleBase.this.generateSQL();
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/jpa/engine/JpaConsoleBase$3", "update"));
                }
                e.getPresentation().setEnabled(JpaConsoleBase.this.getLanguageConsole().getEditorDocument().getText().trim().length() > 0);
            }
        };
        DumbAwareAction ddlAction = new DumbAwareAction(null, null, DatabaseIcons.ExportDDL){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/jpa/engine/JpaConsoleBase$4", "actionPerformed"));
                }
                JpaConsoleBase.this.generateDDL();
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/jpa/engine/JpaConsoleBase$4", "update"));
                }
                e.getPresentation().setEnabled(true);
            }
        };
        DumbAwareAction closeAction = new DumbAwareAction(null, null, AllIcons.Actions.Cancel){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/jpa/engine/JpaConsoleBase$5", "actionPerformed"));
                }
                JpaConsoleBase.this.getContent().getManager().removeContent(JpaConsoleBase.this.getContent(), true);
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/jpa/engine/JpaConsoleBase$5", "update"));
                }
                e.getPresentation().setEnabled(true);
            }
        };
        DumbAwareAction terminateAction = new DumbAwareAction(null, null, AllIcons.Actions.Suspend){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/jpa/engine/JpaConsoleBase$6", "actionPerformed"));
                }
                JpaConsoleBase.this.terminate();
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/jpa/engine/JpaConsoleBase$6", "update"));
                }
                e.getPresentation().setEnabled(JpaConsoleBase.this.isStarted());
            }
        };
        group.add((AnAction)runAction);
        group.add((AnAction)sqlAction);
        group.add((AnAction)ddlAction);
        group.addSeparator();
        group.add(ConsoleHistoryController.getController((LanguageConsoleView)this.getLanguageConsole()).getBrowseHistory());
        group.add(ActionManager.getInstance().getAction("Database.Settings"));
        group.addSeparator();
        group.add(toggleAction);
        group.add(this.getUi().getOptions().getLayoutActions());
        group.addSeparator();
        group.add((AnAction)terminateAction);
        group.add((AnAction)closeAction);
        EmptyAction.setupAction((AnAction)runAction, (String)"Console.Jpa.Execute", null);
        EmptyAction.setupAction((AnAction)closeAction, (String)"Console.Jpa.Close", null);
        EmptyAction.setupAction((AnAction)terminateAction, (String)"Console.Jpa.Terminate", null);
        EmptyAction.setupAction((AnAction)sqlAction, (String)"Console.Jpa.GenerateSql", null);
        EmptyAction.setupAction((AnAction)ddlAction, (String)"Console.Jpa.GenerateDDL", null);
        for (AnAction action : group.getChildActionsOrStubs()) {
            action.registerCustomShortcutSet(action.getShortcutSet(), this.getUi().getComponent());
        }
        return group;
    }

    public void printSql(@Nullable String sql) {
        if (this.myHighlighter == null) {
            this.getHistoryLogger().print(sql);
        } else if (!StringUtil.isEmptyOrSpaces((String)sql)) {
            ConsoleViewUtil.printWithHighlighting((ConsoleView)this.getLanguageConsole(), (String)sql.trim(), (SyntaxHighlighter)this.myHighlighter);
            this.getHistoryLogger().newLine();
        }
        this.getHistoryLogger().newLine();
    }

    public void initHighlighter(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/jpa/engine/JpaConsoleBase", "initHighlighter"));
        }
        DatabaseDialectEx databaseDialect = DbImplUtil.guessDatabaseDialect((RawConnectionConfig)dataSource);
        SqlLanguageDialect dialect = DbSqlUtil.getSqlDialect((DatabaseDialect)((DatabaseDialect)ObjectUtils.notNull((Object)databaseDialect, (Object)GenericDialect.INSTANCE)));
        this.myHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)dialect, null, null);
    }

    public static class LoadRequest
    extends DataRequest.QueryRequest {
        public final List<String> expectedColumns;

        public LoadRequest(DataRequest.Owner owner, String query, Map<Object, String> params, List<String> names) {
            super(owner, NONE, query, LoadRequest.newConstraints((int)0, (int)DatabaseSettings.getSettings().getPageSize(), (int)-1), params);
            this.expectedColumns = names;
        }
    }

    public static class GenerateSql
    extends DataRequest {
        public final Command command;
        public final String query;

        GenerateSql(DataRequest.OwnerEx owner, String query, Command command) {
            super((DataRequest.Owner)owner, owner.getCurrentTx());
            this.command = command;
            this.query = query;
        }
    }

    public static enum Command {
        QUERY,
        DDL;

    }

    private class RunAction
    extends DumbAwareAction
    implements Toggleable {
        public RunAction() {
            super(null, null, AllIcons.Actions.Execute);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            boolean ranged;
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/jpa/engine/JpaConsoleBase$RunAction", "actionPerformed"));
            }
            QlScriptModel scriptModel = JpaConsoleBase.this.getScriptModel();
            TextRange selectionRange = EditorUtil.getSelectionInAnyMode((Editor)JpaConsoleBase.this.getLanguageConsole().getCurrentEditor());
            boolean bl = ranged = selectionRange.getLength() > 0;
            if (ranged) {
                scriptModel = scriptModel.subModel(selectionRange, false);
            }
            if (JpaConsoleBase.this.beforeExecuteQueries(scriptModel)) {
                JpaConsoleBase.this.executeQueries((Editor)JpaConsoleBase.this.getLanguageConsole().getCurrentEditor(), scriptModel);
                if (!ranged) {
                    JpaConsoleBase.this.getLanguageConsole().setInputText("");
                }
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/jpa/engine/JpaConsoleBase$RunAction", "update"));
            }
            boolean enabled = !StringUtil.isEmptyOrSpaces((String)JpaConsoleBase.this.getLanguageConsole().getEditorDocument().getText());
            e.getPresentation().setEnabled(enabled);
            e.getPresentation().putClientProperty("selected", (Object)(!JpaConsoleBase.this.isIdle() ? 1 : 0));
        }
    }

    public static class MyAbstractQlModel
    extends AbstractQlModel {
        private final PersistenceFacet myFacet;
        private final PersistencePackagePointer myUnitFile;
        private final boolean myHibernate;

        public MyAbstractQlModel(Project project, PersistencePackagePointer unitFile, boolean isHibernate) {
            super(project);
            this.myHibernate = isHibernate;
            this.myFacet = unitFile.getPersistenceFacet();
            this.myUnitFile = unitFile;
        }

        @Override
        protected void processPersistenceMappings(PairProcessor<PersistenceMappings, PersistenceModelBrowser> processor) {
            PersistencePackage unit;
            if (FacetUtil.isRegistered((Facet)((Facet)this.myFacet)) && (unit = this.myUnitFile.findElement()) != null && unit.isValid()) {
                PersistenceMappings entityMappings = this.myFacet.getEntityMappings(unit);
                PersistenceModelBrowser browser = PersistenceCommonUtil.createFacetAndUnitModelBrowser((PersistenceFacet)this.myFacet, (PersistencePackage)unit, null);
                processor.process((Object)entityMappings, (Object)browser);
            }
        }

        @Override
        protected boolean isHibernate() {
            return this.myHibernate;
        }

        @Override
        @NotNull
        protected List<? extends PersistenceFacet> getPersistenceFacets() {
            List<PersistenceFacet> list = Collections.singletonList(this.myFacet);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/engine/JpaConsoleBase$MyAbstractQlModel", "getPersistenceFacets"));
            }
            return list;
        }
    }

    public static abstract class Builder<T> {
        protected final PersistencePackagePointer myUnitFile;
        protected ConsoleRunConfiguration myConfiguration;
        protected String myQuery;

        protected Builder(@NotNull PersistencePackagePointer unitFile) {
            if (unitFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unitFile", "com/intellij/jpa/engine/JpaConsoleBase$Builder", "<init>"));
            }
            this.myUnitFile = unitFile;
        }

        public Builder<T> withQuery(@Nullable CharSequence query) {
            this.myQuery = query == null ? null : query.toString();
            return this;
        }

        public Builder<T> withRunConfiguration(@Nullable ConsoleRunConfiguration configuration) {
            this.myConfiguration = configuration;
            return this;
        }

        @NotNull
        protected Project getProject() {
            Project project = this.myUnitFile.getFacetPointer().getProject();
            if (project == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/engine/JpaConsoleBase$Builder", "getProject"));
            }
            return project;
        }

        public abstract T build();
    }
}

