/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.facet;

import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.ui.FacetBasedFrameworkSupportProvider;
import com.intellij.facet.ui.libraries.LibraryInfo;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.PackageUtil;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportConfigurableBase;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportProviderBase;
import com.intellij.ide.util.frameworkSupport.FrameworkVersion;
import com.intellij.javaee.JavaeePersistenceDescriptorsConstants;
import com.intellij.javaee.JavaeeUtil;
import com.intellij.javaee.model.xml.persistence.Persistence;
import com.intellij.javaee.model.xml.persistence.PersistenceUnit;
import com.intellij.jpa.JpaImplementationProvider;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.JpaVersion;
import com.intellij.jpa.actions.GenerateJpaMappingAction;
import com.intellij.jpa.facet.JpaFacet;
import com.intellij.jpa.facet.JpaFacetConfiguration;
import com.intellij.jpa.facet.JpaFacetType;
import com.intellij.jpa.generation.DatabaseSchemaImporter;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.persistence.PersistenceDataKeys;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ColoredListCellRendererWrapper;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ArrayUtil;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.descriptors.ConfigFileFactory;
import com.intellij.util.descriptors.ConfigFileMetaData;
import com.intellij.util.descriptors.ConfigFileUtil;
import com.intellij.util.descriptors.ConfigFileVersion;
import com.intellij.util.xml.NamedEnumUtil;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JpaFrameworkSupportProvider
extends FacetBasedFrameworkSupportProvider<JpaFacet> {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.jpa.facet.JpaFrameworkSupportProvider");

    protected JpaFrameworkSupportProvider() {
        super((FacetType)JpaFacetType.getInstance());
    }

    public String getGroupId() {
        return JavaeeUtil.JAVAEE_FRAMEWORK_GROUP;
    }

    @NotNull
    public List<FrameworkVersion> getVersions() {
        ConfigFileMetaData metaData = JavaeePersistenceDescriptorsConstants.PERSISTENCE_XML_META_DATA;
        ArrayList<FrameworkVersion> result = new ArrayList<FrameworkVersion>();
        for (ConfigFileVersion version : metaData.getVersions()) {
            String versionName = version.getName();
            JpaVersion jpaVersion = JpaFrameworkSupportProvider.getJpaVersion(versionName);
            LibraryInfo[] libraries = JpaUtil.getJpaLibraryInfos(jpaVersion);
            result.add(new FrameworkVersion(versionName, jpaVersion.getVersionTitle(), libraries, version.equals(metaData.getDefaultVersion())));
        }
        ArrayList<FrameworkVersion> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/facet/JpaFrameworkSupportProvider", "getVersions"));
        }
        return arrayList;
    }

    public String getTitle() {
        return JpaMessages.message((String)"framework.title.jpa", (Object[])new Object[0]);
    }

    protected void setupConfiguration(JpaFacet facet, ModifiableRootModel rootModel, FrameworkVersion version) {
        VirtualFile contentDir = rootModel.getSourceRoots().length > 0 ? rootModel.getSourceRoots()[0] : rootModel.getContentRoots()[0];
        String contentRootUrl = contentDir.getUrl();
        String descriptorUrl = contentRootUrl + "/" + JavaeePersistenceDescriptorsConstants.PERSISTENCE_XML_META_DATA.getDirectoryPath() + "/" + JavaeePersistenceDescriptorsConstants.PERSISTENCE_XML_META_DATA.getFileName();
        ConfigFileFactory.getInstance().createFile(null, descriptorUrl, ConfigFileUtil.getVersionByName((ConfigFileMetaData)JavaeePersistenceDescriptorsConstants.PERSISTENCE_XML_META_DATA, (String)version.getVersionName()), true);
        facet.getDescriptorsContainer().getConfiguration().replaceConfigFile(JavaeePersistenceDescriptorsConstants.PERSISTENCE_XML_META_DATA, descriptorUrl);
    }

    @NotNull
    public FrameworkSupportConfigurableBase createConfigurable(@NotNull FrameworkSupportModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/jpa/facet/JpaFrameworkSupportProvider", "createConfigurable"));
        }
        JpaConfigurable jpaConfigurable = new JpaConfigurable(model, this.getVersions());
        if (jpaConfigurable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/facet/JpaFrameworkSupportProvider", "createConfigurable"));
        }
        return jpaConfigurable;
    }

    public static void setupJpaProvidersCombobox(JComboBox comboBox) {
        Object[] providers = (JpaImplementationProvider[])Extensions.getExtensions((ExtensionPointName)JpaImplementationProvider.EP_NAME);
        Arrays.sort(providers, new Comparator<JpaImplementationProvider>(){

            @Override
            public int compare(JpaImplementationProvider o1, JpaImplementationProvider o2) {
                return Comparing.compare((Comparable)((Object)StringUtil.toLowerCase((String)o1.getProviderName())), (Comparable)((Object)StringUtil.toLowerCase((String)o2.getProviderName())));
            }
        });
        JpaImplementationProvider[] items = (JpaImplementationProvider[])ArrayUtil.mergeArrays((Object[])new JpaImplementationProvider[]{null}, (Object[])providers);
        comboBox.setModel(new DefaultComboBoxModel<JpaImplementationProvider>(items));
        comboBox.setRenderer(new ColoredListCellRendererWrapper<JpaImplementationProvider>(){

            protected void doCustomize(JList list, JpaImplementationProvider value, int index, boolean selected, boolean hasFocus) {
                this.setIcon(value != null ? value.getProviderIcon() : null);
                String name = value == null ? "<no provider>" : value.getProviderName();
                this.append(StringUtil.notNullize((String)name), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
        });
        comboBox.setEditable(false);
        DefaultComboBoxModel<JpaImplementationProvider> model = new DefaultComboBoxModel<JpaImplementationProvider>(items);
        comboBox.setModel(model);
    }

    @Nullable
    public static JpaImplementationProvider findProviderByName(String name) {
        if (StringUtil.isEmpty((String)name)) {
            return null;
        }
        for (JpaImplementationProvider provider : (JpaImplementationProvider[])Extensions.getExtensions((ExtensionPointName)JpaImplementationProvider.EP_NAME)) {
            if (!Comparing.equal((String)provider.getProviderName(), (String)name)) continue;
            return provider;
        }
        return null;
    }

    public static void scheduleRunnable(final Module module, final Runnable runnable) {
        DumbService.getInstance((Project)module.getProject()).smartInvokeLater(new Runnable(){

            @Override
            public void run() {
                if (module.isDisposed()) {
                    return;
                }
                runnable.run();
            }
        }, ModalityState.NON_MODAL);
    }

    public static void scheduleDbImport(final Module module, final PersistenceFacet facet) {
        JpaFrameworkSupportProvider.scheduleRunnable(module, new Runnable(){

            @Override
            public void run() {
                GenerateJpaMappingAction.runGenerateAction(new DatabaseSchemaImporter(), new DataContext(){

                    @Nullable
                    public Object getData(@NonNls String dataId) {
                        if (CommonDataKeys.PROJECT.is(dataId)) {
                            return module.getProject();
                        }
                        if (PersistenceDataKeys.PERSISTENCE_FACET.is(dataId)) {
                            return facet;
                        }
                        if (PersistenceDataKeys.PERSISTENCE_FACET_CONTEXT.is(dataId) && facet.getPersistenceUnits().isEmpty()) {
                            return facet;
                        }
                        if (PersistenceDataKeys.PERSISTENCE_UNIT_CONTEXT.is(dataId) && !facet.getPersistenceUnits().isEmpty()) {
                            return facet.getPersistenceUnits().get(0);
                        }
                        return DataManager.getInstance().getDataContext().getData(dataId);
                    }
                });
            }
        });
    }

    @NotNull
    private static JpaVersion getJpaVersion(String version) {
        JpaVersion jpaVersion = (JpaVersion)NamedEnumUtil.getEnumElementByValue(JpaVersion.class, (String)version);
        if (jpaVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/facet/JpaFrameworkSupportProvider", "getJpaVersion"));
        }
        return jpaVersion;
    }

    private class JpaConfigurable
    extends FrameworkSupportConfigurableBase {
        private JPanel myPanel;
        private JComboBox myProviderComboBox;
        private JCheckBox myDbImport;

        public JpaConfigurable(FrameworkSupportModel model, List<FrameworkVersion> versions) {
            super((FrameworkSupportProviderBase)JpaFrameworkSupportProvider.this, model, versions, "persistence.xml version:");
        }

        public JComponent getComponent() {
            if (this.myPanel == null) {
                this.myPanel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, true));
                JComponent superC = super.getComponent();
                if (superC != null) {
                    this.myPanel.add(superC);
                }
                this.myProviderComboBox = new JComboBox();
                JpaFrameworkSupportProvider.setupJpaProvidersCombobox(this.myProviderComboBox);
                this.myDbImport = new JCheckBox(JpaMessages.message((String)"framework.configurable.import.database", (Object[])new Object[0]));
                this.myPanel.add(this.myProviderComboBox);
                this.myPanel.add(this.myDbImport);
            }
            return this.myPanel;
        }

        public void addSupport(final @NotNull Module module, @NotNull ModifiableRootModel rootModel, @Nullable Library library) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/jpa/facet/JpaFrameworkSupportProvider$JpaConfigurable", "addSupport"));
            }
            if (rootModel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/jpa/facet/JpaFrameworkSupportProvider$JpaConfigurable", "addSupport"));
            }
            super.addSupport(module, rootModel, library);
            final JpaFacet facet = (JpaFacet)FacetManager.getInstance((Module)module).getFacetByType(JpaFacet.ID);
            assert (facet != null);
            final JpaImplementationProvider provider = (JpaImplementationProvider)this.myProviderComboBox.getSelectedItem();
            ((JpaFacetConfiguration)facet.getConfiguration()).setDefaultJPAProviderName(provider == null ? null : provider.getProviderName());
            final boolean isDbImport = this.myDbImport.isSelected();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        ConfigFile deploymentDescriptor = facet.getMainDeploymentDescriptor();
                        assert (deploymentDescriptor != null);
                        assert (deploymentDescriptor.getXmlFile() != null);
                        new WriteCommandAction(module.getProject(), new PsiFile[]{deploymentDescriptor.getXmlFile()}){

                            protected void run(@NotNull Result result) throws Throwable {
                                if (result == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/jpa/facet/JpaFrameworkSupportProvider$JpaConfigurable$1$1", "run"));
                                }
                                PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
                                Persistence root = facet.getPersistenceRoot();
                                assert (root != null);
                                PersistenceUnit unit = root.addPersistenceUnit();
                                unit.getName().setStringValue("NewPersistenceUnit");
                                if (provider != null) {
                                    provider.setDefaultProperties(unit);
                                }
                            }
                        }.execute();
                        if (isDbImport) {
                            if (!PackageUtil.checkSourceRootsConfigured((Module)module)) {
                                return;
                            }
                            JpaFrameworkSupportProvider.scheduleDbImport(module, (PersistenceFacet)facet);
                        }
                    }
                    catch (Exception e) {
                        LOG.error((Throwable)e);
                    }
                }
            };
            JpaFrameworkSupportProvider.scheduleRunnable(module, runnable);
        }
    }
}

