/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.view.finder;

import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.javaee.JavaeeUtil;
import com.intellij.jpa.view.finder.JpaEntityAttributesFinderRecursivePanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.ui.FinderRecursivePanel;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.GenericValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JpaEntitiesFinderRecursivePanel
extends FinderRecursivePanel<PersistentObject> {
    private final Module myModule;

    public JpaEntitiesFinderRecursivePanel(@NotNull FinderRecursivePanel parent, @Nullable Module module, DefaultActionGroup actions, @NotNull String groupId) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/jpa/view/finder/JpaEntitiesFinderRecursivePanel", "<init>"));
        }
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "com/intellij/jpa/view/finder/JpaEntitiesFinderRecursivePanel", "<init>"));
        }
        super(parent.getProject(), parent, groupId);
        this.myModule = module;
    }

    @Nullable
    protected JComponent createRightComponent(PersistentObject persistentObject) {
        if (this.hasChildren(persistentObject)) {
            return new JpaEntityAttributesFinderRecursivePanel(this);
        }
        PsiElement element = JpaEntitiesFinderRecursivePanel.getPsiElement(persistentObject);
        if (element != null) {
            DocumentationManager manager = DocumentationManager.getInstance((Project)this.getProject());
            DocumentationComponent component = new DocumentationComponent(manager);
            manager.fetchDocInfo(element, component);
            Disposer.register((Disposable)this, (Disposable)component);
            return component;
        }
        return null;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        PersistentObject jamElement = (PersistentObject)this.getSelectedValue();
        PsiElement element = JpaEntitiesFinderRecursivePanel.getPsiElement(jamElement);
        if (CommonDataKeys.NAVIGATABLE.is(dataId) && element != null) {
            return element;
        }
        return super.getData(dataId);
    }

    @Nullable
    private static PsiElement getPsiElement(@Nullable PersistentObject persistentObject) {
        return persistentObject == null ? null : persistentObject.getIdentifyingPsiElement();
    }

    @Nullable
    private static String getPersistentObjectName(@NotNull PersistentObject persistentObject) {
        if (persistentObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "persistentObject", "com/intellij/jpa/view/finder/JpaEntitiesFinderRecursivePanel", "getPersistentObjectName"));
        }
        if (!persistentObject.isValid()) {
            return null;
        }
        return ElementPresentationManager.getElementName((Object)persistentObject);
    }

    @Nullable
    private static String getPersistentObjectClassName(@NotNull PersistentObject persistentObject) {
        if (persistentObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "persistentObject", "com/intellij/jpa/view/finder/JpaEntitiesFinderRecursivePanel", "getPersistentObjectClassName"));
        }
        if (!persistentObject.isValid()) {
            return null;
        }
        return JavaeeUtil.getClassPresentableText((GenericValue<PsiClass>)persistentObject.getClazz(), true, false);
    }

    @NotNull
    protected String getItemText(PersistentObject persistentObject) {
        String className;
        StringBuilder sb = new StringBuilder();
        String name = JpaEntitiesFinderRecursivePanel.getPersistentObjectName(persistentObject);
        if (name != null) {
            sb.append(name);
            sb.append(" ");
        }
        if ((className = JpaEntitiesFinderRecursivePanel.getPersistentObjectClassName(persistentObject)) != null) {
            sb.append(className);
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/view/finder/JpaEntitiesFinderRecursivePanel", "getItemText"));
        }
        return string;
    }

    @Nullable
    protected JComponent createDefaultRightComponent() {
        return super.createDefaultRightComponent();
    }

    protected void doCustomizeCellRenderer(SimpleColoredComponent comp, JList list, PersistentObject persistentObject, int index, boolean selected, boolean hasFocus) {
        comp.clear();
        comp.setIcon(this.getItemIcon(persistentObject));
        String objectName = JpaEntitiesFinderRecursivePanel.getPersistentObjectName(persistentObject);
        String className = JpaEntitiesFinderRecursivePanel.getPersistentObjectClassName(persistentObject);
        if (!StringUtil.isEmptyOrSpaces((String)objectName)) {
            comp.append("\"" + objectName + "\"");
            if (!StringUtil.isEmptyOrSpaces((String)className)) {
                comp.append(" (" + className + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
        } else if (!StringUtil.isEmptyOrSpaces((String)className)) {
            comp.append(className);
        }
    }

    @Nullable
    protected Icon getItemIcon(PersistentObject persistentObject) {
        return ElementPresentationManager.getIcon((Object)persistentObject);
    }

    @NotNull
    protected List<PersistentObject> getListItems() {
        HashSet set = new HashSet();
        Processor<PersistentObject> processor = new Processor<PersistentObject>((Set)set){
            final /* synthetic */ Set val$set;
            {
                this.val$set = set;
            }

            public boolean process(PersistentObject object) {
                return this.val$set.add(object);
            }
        };
        CommonProcessors.CollectProcessor collectProcessor = new CommonProcessors.CollectProcessor();
        List facets = this.myModule != null ? PersistenceCommonUtil.getAllPersistenceFacets((Module)this.myModule) : PersistenceCommonUtil.getAllPersistenceFacets((Project)this.getProject());
        for (PersistenceFacet persistenceFacet : facets) {
            PersistenceMappings entityMappings = persistenceFacet.getAnnotationEntityMappings();
            if (entityMappings == null) continue;
            PersistenceCommonUtil.queryPersistentObjects((PersistenceMappings)entityMappings).forEach((Processor)processor);
        }
        ArrayList<PersistentObject> persistentObjects = new ArrayList<PersistentObject>((Collection<PersistentObject>)set);
        Collections.sort(persistentObjects, new Comparator<PersistentObject>(){

            @Override
            public int compare(PersistentObject o1, PersistentObject o2) {
                String value1 = JpaEntitiesFinderRecursivePanel.getPersistentObjectName(o1);
                String value2 = JpaEntitiesFinderRecursivePanel.getPersistentObjectName(o2);
                if (value1 == null || value2 == null) {
                    return 0;
                }
                return value1.compareTo(value2);
            }
        });
        ArrayList<PersistentObject> arrayList = persistentObjects;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/view/finder/JpaEntitiesFinderRecursivePanel", "getListItems"));
        }
        return arrayList;
    }

    protected boolean hasChildren(PersistentObject persistentObject) {
        return persistentObject.isValid() && persistentObject.getObjectModelHelper().getAttributes().size() > 0;
    }

    public Module getModule() {
        return this.myModule;
    }
}

