/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.SizedIcon;
import icons.GroovyMvcIcons;
import java.io.IOException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.pluginSupport.webflow.WebFlowUtils;
import org.jetbrains.plugins.grails.util.GrailsArtifact;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.actions.GroovyTemplatesFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;

public class GrailsGenerateViewAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(GrailsGenerateViewAction.class);

    public void actionPerformed(AnActionEvent e) {
        AccessToken token = WriteAction.start();
        try {
            GrailsGenerateViewAction.createAction(GrailsGenerateViewAction.getActionControllerToGenerate(e.getDataContext()));
        }
        finally {
            token.finish();
        }
    }

    public static void createAction(@Nullable Pair<PsiClass, String> pair) {
        if (pair == null) {
            return;
        }
        VirtualFile grailsApp = GrailsArtifact.CONTROLLER.getGrailsApp((PsiClass)pair.first);
        if (grailsApp == null) {
            return;
        }
        try {
            PsiDirectory psiDirectory;
            String controllerName;
            VirtualFile controllerGspFolder;
            VirtualFile viewDirectory = grailsApp.findChild("views");
            if (viewDirectory == null) {
                viewDirectory = grailsApp.createChildDirectory(null, "views");
            }
            if ((controllerGspFolder = viewDirectory.findChild(controllerName = GrailsArtifact.CONTROLLER.getArtifactName((PsiClass)pair.first))) == null) {
                controllerGspFolder = viewDirectory.createChildDirectory(null, controllerName);
            }
            if ((psiDirectory = ((PsiClass)pair.first).getManager().findDirectory(controllerGspFolder)) == null) {
                return;
            }
            PsiFile psiFile = GroovyTemplatesFactory.createFromTemplate((PsiDirectory)psiDirectory, (String)((String)pair.second + ".gsp"), (String)((String)pair.second + ".gsp"), (String)"GroovyServerPage.gsp", (boolean)true, (String[])new String[0]);
            if (psiFile == null) {
                return;
            }
            psiFile.navigate(true);
        }
        catch (IOException e1) {
            LOG.warn((Throwable)e1);
        }
    }

    @Nullable
    private static Pair<PsiClass, String> getActionControllerToGenerate(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "org/jetbrains/plugins/grails/actions/GrailsGenerateViewAction", "getActionControllerToGenerate"));
        }
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (psiFile == null) {
            return null;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            return null;
        }
        PsiElement element = psiFile.findElementAt(editor.getCaretModel().getOffset());
        PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{GrField.class, PsiMethod.class});
        if (member == null) {
            return null;
        }
        if (!GrailsArtifact.CONTROLLER.isInstance(member.getContainingClass())) {
            return null;
        }
        return GrailsGenerateViewAction.getActionControllerToGenerate(member);
    }

    @Nullable
    public static Pair<PsiClass, String> getActionControllerToGenerate(@NotNull PsiMember member) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "org/jetbrains/plugins/grails/actions/GrailsGenerateViewAction", "getActionControllerToGenerate"));
        }
        String actionName = GrailsUtils.getActionName((PsiElement)member);
        if (actionName == null) {
            return null;
        }
        if (member instanceof GrField && WebFlowUtils.isFlowActionField((GrField)member)) {
            return null;
        }
        return Pair.create((Object)member.getContainingClass(), (Object)actionName);
    }

    public static boolean isEnabled(@Nullable Pair<PsiClass, String> pair) {
        return pair != null && GrailsUtils.getViewByAction((PsiClass)pair.first, (String)pair.second) == null;
    }

    public void update(AnActionEvent e) {
        boolean enabled = GrailsGenerateViewAction.isEnabled(GrailsGenerateViewAction.getActionControllerToGenerate(e.getDataContext()));
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(enabled);
        presentation.setVisible(enabled);
        if (enabled) {
            presentation.setIcon((Icon)new SizedIcon(GroovyMvcIcons.Gsp_logo, 18, 18));
        }
    }
}

