/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.config;

import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.tree.IElementType;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyConfigReader {
    private final Map<String, Map<String, PsiElement>> myEnvMap = new HashMap<String, Map<String, PsiElement>>();
    private final Map<String, PsiElement> myDefaultEnv = new HashMap<String, PsiElement>();
    private Map<String, PsiElement> myCurrentEnv = this.myDefaultEnv;
    private StringBuilder myCurrentPrefixes = new StringBuilder();

    private GroovyConfigReader() {
    }

    private void processStatements(@NotNull PsiElement root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/plugins/grails/config/GroovyConfigReader", "processStatements"));
        }
        for (PsiElement e = root.getFirstChild(); e != null; e = e.getNextSibling()) {
            if (e instanceof GrAssignmentExpression) {
                this.process((GrAssignmentExpression)e);
                continue;
            }
            if (!(e instanceof GrMethodCall)) continue;
            this.process((GrMethodCall)e);
        }
    }

    private void process(@NotNull GrAssignmentExpression assign) {
        if (assign == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assign", "org/jetbrains/plugins/grails/config/GroovyConfigReader", "process"));
        }
        if (assign.getOperationTokenType() != GroovyTokenTypes.mASSIGN) {
            return;
        }
        GrExpression value = assign.getLValue();
        if (!(value instanceof GrReferenceExpression)) {
            return;
        }
        int prefixSize = this.myCurrentPrefixes.length();
        if (GroovyConfigReader.appendPropertyName(this.myCurrentPrefixes, (GrReferenceExpression)value)) {
            this.myCurrentEnv.put(this.myCurrentPrefixes.toString(), (PsiElement)assign.getRValue());
        }
        this.myCurrentPrefixes.setLength(prefixSize);
    }

    private void process(@NotNull GrMethodCall call) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/plugins/grails/config/GroovyConfigReader", "process"));
        }
        String methodName = PsiUtil.getUnqualifiedMethodName((GrMethodCall)call);
        if (methodName == null) {
            return;
        }
        GrClosableBlock closure = GrailsUtils.getClosureArgument(call);
        if (closure == null) {
            return;
        }
        if (this.myCurrentEnv == this.myDefaultEnv && "environments".equals(methodName)) {
            for (PsiElement envClosureChild = closure.getFirstChild(); envClosureChild != null; envClosureChild = envClosureChild.getNextSibling()) {
                GrClosableBlock c;
                GrMethodCall mc;
                String envName;
                if (!(envClosureChild instanceof GrMethodCall) || (envName = PsiUtil.getUnqualifiedMethodName((GrMethodCall)(mc = (GrMethodCall)envClosureChild))) == null || (c = GrailsUtils.getClosureArgument(mc)) == null) continue;
                this.myCurrentEnv = this.myEnvMap.get(envName);
                if (this.myCurrentEnv == null) {
                    this.myCurrentEnv = new HashMap<String, PsiElement>();
                    this.myEnvMap.put(envName, this.myCurrentEnv);
                }
                this.processStatements((PsiElement)c);
                this.myCurrentEnv = this.myDefaultEnv;
            }
            return;
        }
        int prefixSize = this.myCurrentPrefixes.length();
        if (this.myCurrentPrefixes.length() > 0) {
            this.myCurrentPrefixes.append('.');
        }
        this.myCurrentPrefixes.append(methodName);
        this.processStatements((PsiElement)closure);
        this.myCurrentPrefixes.setLength(prefixSize);
    }

    private static boolean appendPropertyName(StringBuilder buf, GrReferenceExpression ref) {
        String refName;
        PsiElement nameElement;
        GrExpression qualifier = ref.getQualifierExpression();
        if (qualifier != null) {
            if (!(qualifier instanceof GrReferenceExpression)) {
                return false;
            }
            if (!GroovyConfigReader.appendPropertyName(buf, (GrReferenceExpression)qualifier)) {
                return false;
            }
        }
        if ((nameElement = ref.getReferenceNameElement()) instanceof GrLiteralImpl) {
            Object value = ((GrLiteralImpl)nameElement).getValue();
            if (!(value instanceof String)) {
                return false;
            }
            refName = (String)value;
        } else if (PsiImplUtil.isLeafElementOfType((PsiElement)nameElement, (IElementType)GroovyTokenTypes.mIDENT)) {
            refName = nameElement.getText();
        } else {
            return false;
        }
        if (buf.length() > 0) {
            buf.append('.');
        }
        buf.append(refName);
        return true;
    }

    public static GroovyConfigReader read(@NotNull GroovyFile groovyFile) {
        if (groovyFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groovyFile", "org/jetbrains/plugins/grails/config/GroovyConfigReader", "read"));
        }
        GroovyConfigReader res = new GroovyConfigReader();
        res.processStatements((PsiElement)groovyFile);
        return res;
    }

    public Set<String> getEnvironments() {
        return this.myEnvMap.keySet();
    }

    @Nullable
    public PsiElement getValue(@Nullable String environment, @NotNull String property) {
        PsiElement res;
        Map<String, PsiElement> map;
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/plugins/grails/config/GroovyConfigReader", "getValue"));
        }
        if (environment != null && (map = this.myEnvMap.get(environment)) != null && (res = map.get(property)) != null) {
            return res;
        }
        return this.myDefaultEnv.get(property);
    }

    @Nullable
    public String getStringValue(@Nullable String environment, @NotNull String property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/plugins/grails/config/GroovyConfigReader", "getStringValue"));
        }
        PsiElement element = this.getValue(environment, property);
        if (element == null) {
            return null;
        }
        if (element instanceof GrLiteralImpl) {
            Object value = ((GrLiteralImpl)element).getValue();
            if (value instanceof String) {
                return (String)value;
            }
            return null;
        }
        return null;
    }
}

