/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.editor;

import com.intellij.ide.DataManager;
import com.intellij.ide.presentation.VirtualFilePresentation;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.ui.ClickListener;
import com.intellij.ui.JBColor;
import com.intellij.util.containers.ContainerUtil;
import icons.GroovyMvcIcons;
import icons.JetgroovyIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.config.GrailsConfigUtils;
import org.jetbrains.plugins.grails.editor.GenerateArtifactAction;
import org.jetbrains.plugins.grails.editor.GenerateTestsAction;
import org.jetbrains.plugins.grails.editor.GenerateViewsAction;
import org.jetbrains.plugins.grails.fileType.GspFileType;
import org.jetbrains.plugins.grails.tests.GrailsTestUtils;
import org.jetbrains.plugins.grails.util.GrailsArtifact;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.util.GroovyUtils;

public class EditorDecorator
implements ProjectComponent,
FileEditorManagerListener {
    private static final Key<JPanel> DECORATOR_KEY = Key.create((String)"EditorDecorator.DECORATOR_KEY");
    private final Project myProject;
    private static boolean myIsVirtualFileListenerAdded;

    public EditorDecorator(Project project) {
        this.myProject = project;
        project.getMessageBus().connect().subscribe(FILE_EDITOR_MANAGER, (Object)this);
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    @NotNull
    public String getComponentName() {
        if ("GrailsEditorDecorator" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/editor/EditorDecorator", "getComponentName"));
        }
        return "GrailsEditorDecorator";
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "org/jetbrains/plugins/grails/editor/EditorDecorator", "fileOpened"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/grails/editor/EditorDecorator", "fileOpened"));
        }
        this.decorateFile(file);
    }

    private void decorateFile(VirtualFile file) {
        FileType fileType = file.getFileType();
        if (fileType != GroovyFileType.GROOVY_FILE_TYPE && fileType != GspFileType.GSP_FILE_TYPE && !"jsp".equals(file.getExtension())) {
            return;
        }
        if (Registry.is((String)"grails.advanced.mode")) {
            return;
        }
        Module module = ModuleUtil.findModuleForFile((VirtualFile)file, (Project)this.myProject);
        if (module == null) {
            return;
        }
        VirtualFile appRoot = GrailsUtils.findGrailsAppRoot(module);
        if (appRoot == null) {
            return;
        }
        if (GrailsConfigUtils.isAtLeastGrails(module, "3.0")) {
            return;
        }
        if (fileType == GroovyFileType.GROOVY_FILE_TYPE) {
            this.decorateGroovyFile(file, appRoot);
        } else {
            this.decorateGspFile(file, appRoot);
        }
    }

    private void decorateGroovyFile(final VirtualFile file, final VirtualFile appRoot) {
        final GrTypeDefinition classDefinition = GroovyUtils.getPublicClass((VirtualFile)file, (PsiManager)PsiManager.getInstance((Project)this.myProject));
        if (classDefinition == null) {
            return;
        }
        if (GrailsUtils.isInGrailsTests(file, this.myProject)) {
            DumbService.getInstance((Project)this.myProject).runWhenSmart(new Runnable(){

                @Override
                public void run() {
                    if (!classDefinition.isValid()) {
                        return;
                    }
                    PsiClass testedClass = GrailsTestUtils.getTestedClass((PsiClass)classDefinition);
                    if (testedClass != null) {
                        EditorDecorator.this.decorateClass(testedClass, file, appRoot);
                    }
                }
            });
            return;
        }
        this.decorateClass((PsiClass)classDefinition, file, appRoot);
    }

    private void decorateClass(PsiClass aClass, VirtualFile file, VirtualFile appRoot) {
        GrailsArtifact artifact = GrailsArtifact.getType(aClass);
        if (artifact == GrailsArtifact.CONTROLLER || artifact == GrailsArtifact.DOMAIN) {
            this.decorate(artifact.getArtifactName(aClass), appRoot, file, null);
        }
    }

    private void decorateGspFile(VirtualFile file, VirtualFile appRoot) {
        String controllerName = GrailsUtils.getControllerNameByGsp(file);
        if (controllerName == null || controllerName.equals("layouts") || !StringUtil.isJavaIdentifier((String)controllerName)) {
            return;
        }
        String actionName = file.getNameWithoutExtension();
        if (actionName.startsWith("_")) {
            actionName = null;
        }
        this.decorate(controllerName, appRoot, file, actionName);
    }

    private void decorate(String artifactName, VirtualFile appRoot, VirtualFile file, @Nullable String actionName) {
        FileEditor[] editors;
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)this.myProject);
        for (FileEditor editor : editors = editorManager.getEditors(file)) {
            JPanel panel = (JPanel)editor.getUserData(DECORATOR_KEY);
            if (panel == null) {
                panel = new JPanel();
                panel.setOpaque(false);
                panel.setLayout(new FlowLayout(0, 5, 2));
                editor.putUserData(DECORATOR_KEY, (Object)panel);
                editorManager.addTopComponent(editor, (JComponent)panel);
            } else {
                panel.removeAll();
            }
            panel.add(new OpenDomainClassAction(artifactName, appRoot));
            panel.add(new OpenControllerAction(artifactName, appRoot, actionName));
            panel.add(new OpenViewsAction(artifactName, appRoot));
            panel.add(new OpenTestsAction(artifactName, appRoot));
        }
        if (!myIsVirtualFileListenerAdded) {
            myIsVirtualFileListenerAdded = true;
            VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new MyVirtualFileListener());
        }
    }

    public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "org/jetbrains/plugins/grails/editor/EditorDecorator", "fileClosed"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/grails/editor/EditorDecorator", "fileClosed"));
        }
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/grails/editor/EditorDecorator", "selectionChanged"));
        }
    }

    private static List<VirtualFile> classesToFiles(Collection<GrClassDefinition> classes) {
        ArrayList<VirtualFile> res = new ArrayList<VirtualFile>(classes.size());
        for (PsiClass psiClass : classes) {
            ContainerUtil.addIfNotNull(res, (Object)psiClass.getContainingFile().getOriginalFile().getVirtualFile());
        }
        return res;
    }

    private static class EditorDecoratorReloader
    implements Runnable {
        public static boolean isInQueue;

        private EditorDecoratorReloader() {
        }

        public static void reload() {
            ApplicationManager.getApplication().assertIsDispatchThread();
            if (isInQueue) {
                return;
            }
            isInQueue = true;
            ApplicationManager.getApplication().invokeLater((Runnable)new EditorDecoratorReloader());
        }

        @Override
        public void run() {
            assert (isInQueue);
            isInQueue = false;
            for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                EditorDecorator editorDecorator = (EditorDecorator)project.getComponent(EditorDecorator.class);
                FileEditorManager manager = FileEditorManager.getInstance((Project)project);
                for (VirtualFile file : manager.getOpenFiles()) {
                    editorDecorator.decorateFile(file);
                }
            }
        }
    }

    private static class MyVirtualFileListener
    extends VirtualFileAdapter {
        private MyVirtualFileListener() {
        }

        public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/grails/editor/EditorDecorator$MyVirtualFileListener", "propertyChanged"));
            }
            if ("name".equals(event.getPropertyName())) {
                MyVirtualFileListener.filePathChanged(event.getFile());
            }
        }

        public void fileMoved(@NotNull VirtualFileMoveEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/grails/editor/EditorDecorator$MyVirtualFileListener", "fileMoved"));
            }
            MyVirtualFileListener.filePathChanged(event.getFile());
        }

        private static void filePathChanged(VirtualFile file) {
            FileType fileType = file.getFileType();
            if (fileType != GroovyFileType.GROOVY_FILE_TYPE && fileType != GspFileType.GSP_FILE_TYPE && !"jsp".equals(file.getExtension())) {
                return;
            }
            EditorDecoratorReloader.reload();
        }
    }

    private abstract class ChooseFileAction
    extends JLabel {
        protected final VirtualFile appRoot;
        private final boolean myOpenSingleFile;
        protected final String myArtifactName;
        protected final Module myModule;

        public ChooseFileAction(String title, String artifactName, VirtualFile appRoot, Icon icon, boolean openSingleFile) {
            super(title);
            this.appRoot = appRoot;
            this.myOpenSingleFile = openSingleFile;
            this.myArtifactName = artifactName;
            this.myModule = ModuleUtil.findModuleForFile((VirtualFile)appRoot, (Project)EditorDecorator.this.myProject);
            this.setForeground(JBColor.foreground());
            this.setBorder(BorderFactory.createEmptyBorder(1, 5, 1, 5));
            this.setIcon(icon);
            this.addMouseListener(new MouseAdapter(){
                private Color selectBackground;

                @Override
                public void mouseEntered(MouseEvent e) {
                    if (this.selectBackground == null) {
                        this.selectBackground = ChooseFileAction.this.getBackground().darker();
                    }
                    ChooseFileAction.this.setBackground(this.selectBackground);
                    ChooseFileAction.this.setOpaque(true);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    ChooseFileAction.this.setBackground(Color.WHITE);
                    ChooseFileAction.this.setOpaque(false);
                }
            });
            new ClickListener(){

                public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/grails/editor/EditorDecorator$ChooseFileAction$2", "onClick"));
                    }
                    ChooseFileAction.this.actionPerformed();
                    return true;
                }
            }.installOn((Component)this);
            this.setCursor(Cursor.getPredefinedCursor(12));
        }

        protected abstract void addGenerateAction(DefaultActionGroup var1);

        private void actionPerformed() {
            Collection<VirtualFile> files;
            if (this.myModule.isDisposed()) {
                return;
            }
            this.setBackground(this.getParent().getBackground());
            try {
                files = this.getFilesToNavigate();
            }
            catch (IndexNotReadyException e) {
                files = Collections.emptyList();
            }
            if (files.size() == 1 && this.myOpenSingleFile) {
                this.navigate(files.iterator().next());
                return;
            }
            DefaultActionGroup actionGroup = new DefaultActionGroup();
            for (final VirtualFile file : files) {
                AnAction action = new AnAction(){

                    public void actionPerformed(AnActionEvent e) {
                        ApplicationManager.getApplication().invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (file.isValid() && !EditorDecorator.this.myProject.isDisposed()) {
                                    ChooseFileAction.this.navigate(file);
                                }
                            }
                        });
                    }
                };
                Presentation presentation = action.getTemplatePresentation();
                presentation.setText(this.getPresentableText(file));
                presentation.setIcon(VirtualFilePresentation.getIcon((VirtualFile)file));
                actionGroup.add(action);
            }
            if (!files.isEmpty()) {
                actionGroup.addSeparator();
            }
            this.addGenerateAction(actionGroup);
            JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)actionGroup, DataManager.getInstance().getDataContext((Component)this), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false).showUnderneathOf((Component)this);
        }

        protected void navigate(VirtualFile file) {
            new OpenFileDescriptor(EditorDecorator.this.myProject, file).navigate(true);
        }

        protected String getPresentableText(VirtualFile file) {
            String actionText;
            PsiFile psiFile = PsiManager.getInstance((Project)EditorDecorator.this.myProject).findFile(file);
            if (psiFile instanceof GroovyFile) {
                String name = ((GroovyFile)psiFile).getPackageName();
                actionText = (name.length() > 0 ? name + "." : "") + file.getNameWithoutExtension();
            } else {
                actionText = file.getName();
            }
            return actionText;
        }

        protected abstract Collection<VirtualFile> getFilesToNavigate();

        protected void addGenerateAction(DefaultActionGroup group, String text, AnAction anAction) {
            anAction.getTemplatePresentation().setText(text);
            anAction.getTemplatePresentation().setIcon(this.getIcon());
            group.add(anAction);
        }
    }

    class OpenDomainClassAction
    extends ChooseFileAction {
        public OpenDomainClassAction(String name, VirtualFile appRoot) {
            super(StringUtil.capitalize((String)name), name, appRoot, JetgroovyIcons.Mvc.Domain_class, true);
        }

        protected List<VirtualFile> getFilesToNavigate() {
            return EditorDecorator.classesToFiles(GrailsArtifact.DOMAIN.getInstances(this.myModule, this.myArtifactName));
        }

        @Override
        protected void addGenerateAction(DefaultActionGroup group) {
            this.addGenerateAction(group, "Generate domain class", new GenerateArtifactAction(GrailsArtifact.DOMAIN, this.myArtifactName, "create-domain-class"));
        }
    }

    private class OpenViewsAction
    extends ChooseFileAction {
        public OpenViewsAction(String name, VirtualFile appRoot) {
            super(StringUtil.capitalize((String)name) + " Views", name, appRoot, GroovyMvcIcons.Gsp_logo, false);
        }

        @Override
        protected Collection<VirtualFile> getFilesToNavigate() {
            VirtualFile viewsDir = VfsUtil.findRelativeFile((VirtualFile)this.appRoot, (String[])new String[]{"grails-app", "views", this.myArtifactName});
            if (viewsDir == null) {
                return Collections.emptyList();
            }
            ArrayList<VirtualFile> res = new ArrayList<VirtualFile>();
            for (VirtualFile file : viewsDir.getChildren()) {
                if (!file.getName().endsWith(".gsp") && !file.getName().endsWith(".jsp")) continue;
                res.add(file);
            }
            return res;
        }

        @Override
        protected void addGenerateAction(DefaultActionGroup group) {
            this.addGenerateAction(group, "Generate views", new GenerateViewsAction(this.myArtifactName));
        }
    }

    private class OpenTestsAction
    extends ChooseFileAction {
        public OpenTestsAction(String name, VirtualFile appRoot) {
            super("Tests", name, appRoot, GroovyMvcIcons.Grails_test, false);
        }

        protected List<VirtualFile> getFilesToNavigate() {
            VirtualFile testApp = this.appRoot.findChild("test");
            if (testApp == null) {
                return Collections.emptyList();
            }
            ArrayList<VirtualFile> res = new ArrayList<VirtualFile>();
            for (PsiClass psiClass : GrailsArtifact.CONTROLLER.getInstances(this.myModule, this.myArtifactName)) {
                for (PsiClass testClass : GrailsTestUtils.getTestsForArtifact(psiClass, true)) {
                    ContainerUtil.addIfNotNull(res, (Object)testClass.getContainingFile().getVirtualFile());
                }
            }
            for (PsiClass psiClass : GrailsArtifact.DOMAIN.getInstances(this.myModule, this.myArtifactName)) {
                for (PsiClass testClass : GrailsTestUtils.getTestsForArtifact(psiClass, true)) {
                    ContainerUtil.addIfNotNull(res, (Object)testClass.getContainingFile().getVirtualFile());
                }
            }
            return res;
        }

        @Override
        protected void addGenerateAction(DefaultActionGroup group) {
            String capitalizedArtifactName = StringUtil.capitalize((String)this.myArtifactName);
            this.addGenerateAction(group, "Generate " + capitalizedArtifactName + "Tests... (unit)", new GenerateTestsAction(false, this.myArtifactName, GrailsArtifact.DOMAIN));
            this.addGenerateAction(group, "Generate " + capitalizedArtifactName + "Tests... (integration)", new GenerateTestsAction(true, this.myArtifactName, GrailsArtifact.DOMAIN));
            this.addGenerateAction(group, "Generate " + capitalizedArtifactName + "ControllerTests... (unit)", new GenerateTestsAction(false, this.myArtifactName, GrailsArtifact.CONTROLLER));
            this.addGenerateAction(group, "Generate " + capitalizedArtifactName + "ControllerTests... (integration)", new GenerateTestsAction(true, this.myArtifactName, GrailsArtifact.CONTROLLER));
        }
    }

    private class OpenControllerAction
    extends ChooseFileAction {
        private String myActionName;

        public OpenControllerAction(String name, @Nullable VirtualFile moduleFileDir, String actionName) {
            super(StringUtil.capitalize((String)name) + "Controller" + (actionName == null ? "" : ":" + actionName), name, moduleFileDir, JetgroovyIcons.Mvc.Controller, true);
            this.myActionName = actionName;
        }

        protected List<VirtualFile> getFilesToNavigate() {
            return EditorDecorator.classesToFiles(GrailsArtifact.CONTROLLER.getInstances(this.myModule, this.myArtifactName));
        }

        @Override
        protected void navigate(VirtualFile file) {
            PsiFile psiFile = PsiManager.getInstance((Project)EditorDecorator.this.myProject).findFile(file);
            if (psiFile instanceof GroovyFile && this.myArtifactName != null) {
                try {
                    PsiMethod method = GrailsUtils.getControllerActions(this.myArtifactName, this.myModule).get(this.myActionName);
                    if (method != null) {
                        method.navigate(true);
                        return;
                    }
                }
                catch (IndexNotReadyException indexNotReadyException) {
                    // empty catch block
                }
            }
            super.navigate(file);
        }

        @Override
        protected void addGenerateAction(DefaultActionGroup group) {
            this.addGenerateAction(group, "Generate controller", new GenerateArtifactAction(GrailsArtifact.CONTROLLER, this.myArtifactName, "generate-controller"));
        }
    }
}

