/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.gradle;

import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.task.TaskCallback;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.mvc.MvcCommand;

public class GrailsGradleInvoker {
    private static final Map<String, String> ourCommandTasks = GrailsUtils.createMap("run-app", "grails-run-app", "test-app", "cleanGrails-test-app grails-test-app", "war", "grails-war");
    @NotNull
    private final GrailsApplication myApplication;

    public GrailsGradleInvoker(@NotNull GrailsApplication application) {
        if (application == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "application", "org/jetbrains/plugins/grails/gradle/GrailsGradleInvoker", "<init>"));
        }
        this.myApplication = application;
    }

    public void invoke(@Nullable String executionName, @NotNull MvcCommand command) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/plugins/grails/gradle/GrailsGradleInvoker", "invoke"));
        }
        this.invoke(DefaultRunExecutor.EXECUTOR_ID, executionName, command, null);
    }

    public void invoke(@Nullable String executionName, @NotNull MvcCommand command, @Nullable TaskCallback taskCallback) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/plugins/grails/gradle/GrailsGradleInvoker", "invoke"));
        }
        this.invoke(DefaultRunExecutor.EXECUTOR_ID, executionName, command, taskCallback);
    }

    public void invoke(@NotNull String executorId, @Nullable String executionName, @NotNull MvcCommand command, @Nullable TaskCallback taskCallback) {
        if (executorId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorId", "org/jetbrains/plugins/grails/gradle/GrailsGradleInvoker", "invoke"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/plugins/grails/gradle/GrailsGradleInvoker", "invoke"));
        }
        if (command.getCommand() != null) {
            String task = ourCommandTasks.get(command.getCommand());
            ExternalSystemTaskExecutionSettings executionSettings = new ExternalSystemTaskExecutionSettings();
            ContainerUtil.addAllNotNull((Collection)executionSettings.getTaskNames(), (Object[])StringUtil.notNullize((String)task, (String)("grails-" + command.getCommand())).split(" "));
            StringBuilder scriptParameters = new StringBuilder();
            if (!command.getArgs().isEmpty()) {
                String args = StringUtil.join((Collection)command.getArgs(), (String)" ");
                scriptParameters.append("-PgrailsArgs=\"").append(args).append("\"");
                if ("test-app".equals(command.getCommand())) {
                    executionSettings.setVmOptions("-Dtest.single=\"" + args + "\"");
                }
            }
            if (!StringUtil.isEmpty((String)command.getEnv())) {
                scriptParameters.append(" -PgrailsEnv=").append(command.getEnv());
            }
            executionSettings.setScriptParameters(scriptParameters.toString());
            executionSettings.setExternalProjectPath(this.myApplication.getRoot().getPath());
            executionSettings.setExternalSystemIdString(GradleConstants.SYSTEM_ID.getId());
            executionSettings.setExecutionName(executionName);
            ExternalSystemUtil.runTask((ExternalSystemTaskExecutionSettings)executionSettings, (String)executorId, (Project)this.myApplication.getProject(), (ProjectSystemId)GradleConstants.SYSTEM_ID, (TaskCallback)taskCallback, (ProgressExecutionMode)ProgressExecutionMode.IN_BACKGROUND_ASYNC);
        }
    }
}

