/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.gradle;

import com.intellij.facet.FacetManager;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.config.GrailsSettings;
import org.jetbrains.plugins.grails.config.GrailsSettingsService;
import org.jetbrains.plugins.grails.gradle.GrailsModuleData;
import org.jetbrains.plugins.grails.structure.GrailsApplicationManager;
import org.jetbrains.plugins.grails.util.GrailsFacetProvider;
import org.jetbrains.plugins.grails.util.GrailsUtils;

@Order(value=1000)
public class GrailsModuleGradleDataService
extends AbstractProjectDataService<GrailsModuleData, Module> {
    @NotNull
    public Key<GrailsModuleData> getTargetDataKey() {
        Key<GrailsModuleData> key = GrailsModuleData.KEY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/gradle/GrailsModuleGradleDataService", "getTargetDataKey"));
        }
        return key;
    }

    public void importData(@NotNull Collection<DataNode<GrailsModuleData>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "org/jetbrains/plugins/grails/gradle/GrailsModuleGradleDataService", "importData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/gradle/GrailsModuleGradleDataService", "importData"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "org/jetbrains/plugins/grails/gradle/GrailsModuleGradleDataService", "importData"));
        }
        if (toImport.isEmpty() || !project.isInitialized()) {
            return;
        }
        for (DataNode<GrailsModuleData> node : toImport) {
            Object parentNodeData;
            DataNode parentNode;
            GrailsModuleData grailsModuleData = (GrailsModuleData)((Object)node.getData());
            if (GradleConstants.SYSTEM_ID.equals((Object)grailsModuleData.getOwner()) && (parentNode = node.getParent()) != null && !((parentNodeData = parentNode.getData()) instanceof ModuleData)) continue;
        }
    }

    private static void configureGrailModule(GrailsModuleData grailsModuleData, IdeModifiableModelsProvider modelsProvider, String moduleName, ModuleData moduleData) {
        Module module = modelsProvider.findIdeModule(moduleName);
        if (module != null) {
            module.setOption("grails.gradle.pluginId", grailsModuleData.getGrailsPluginId());
            ArrayList actions = ContainerUtil.newArrayList();
            for (GrailsFacetProvider provider : (GrailsFacetProvider[])GrailsFacetProvider.EP_NAME.getExtensions()) {
                VirtualFile virtualFile = ExternalSystemUtil.findLocalFileByPath((String)moduleData.getLinkedExternalProjectPath());
                provider.addFacets(actions, module, Collections.singletonList(virtualFile));
            }
            ModifiableFacetModel model = FacetManager.getInstance((Module)module).createModifiableModel();
            for (Consumer action : actions) {
                action.consume((Object)model);
            }
            model.commit();
            if (VersionComparatorUtil.compare((String)grailsModuleData.getGrailsVersion(), (String)"3.0") < 0) {
                GrailsSettings settings = GrailsSettingsService.getGrailsSettings(module);
                int pluginsCrc = GrailsUtils.getPluginsCrc(module);
                if (settings.pluginsCrc != pluginsCrc) {
                    settings.pluginsCrc = pluginsCrc;
                    GrailsFramework.forceSynchronizationSetting(module);
                }
            }
        }
    }

    public void onSuccessImport(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/gradle/GrailsModuleGradleDataService", "onSuccessImport"));
        }
        GrailsApplicationManager.getInstance(project).queueUpdate();
    }
}

