/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.maven;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.plugins.grails.maven.GrailsMavenApplication;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.structure.GrailsApplicationProvider;

public class GrailsMavenApplicationProvider
extends GrailsApplicationProvider {
    @Override
    @Nullable
    public GrailsApplication createApplication(@NotNull Project project, @NotNull VirtualFile root) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/maven/GrailsMavenApplicationProvider", "createApplication"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/plugins/grails/maven/GrailsMavenApplicationProvider", "createApplication"));
        }
        Module module = ProjectRootManager.getInstance((Project)project).getFileIndex().getModuleForFile(root);
        if (module == null) {
            return null;
        }
        MavenProject mavenProject = MavenProjectsManager.getInstance((Project)project).findProject(module);
        if (mavenProject == null || mavenProject.findPlugin("org.grails", "grails-maven-plugin") == null) {
            return null;
        }
        return new GrailsMavenApplication(module, root, mavenProject.getDisplayName());
    }
}

