/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.pluginSupport.webflow;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.config.GrailsStructure;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightVariable;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.util.LightCacheKey;

public class WebFlowUtils {
    public static final String FLOW_SUFFIX = "Flow";
    public static final String WEBFLOW = "webflow";
    private static final LightCacheKey<Map<String, PsiVariable>> CACHED_STATES_KEY = LightCacheKey.create();

    private WebFlowUtils() {
    }

    public static boolean isWebFlowEnabled(@Nullable GrailsStructure structure) {
        if (structure == null) {
            return false;
        }
        if (structure.isAtLeastGrails("1.2")) {
            return structure.isPluginInstalled(WEBFLOW);
        }
        return true;
    }

    public static boolean isFlowActionField(GrField field) {
        String name = field.getName();
        if (name == null || !name.endsWith(FLOW_SUFFIX)) {
            return false;
        }
        if (GrailsUtils.getActionName((PsiElement)field) == null) {
            return false;
        }
        return WebFlowUtils.isWebFlowEnabled(GrailsStructure.getInstance((PsiElement)field));
    }

    @NotNull
    public static GrField getActionByStateDeclaration(GrMethodCall stateDeclaration) {
        PsiElement actionClosure = stateDeclaration.getParent();
        assert (actionClosure instanceof GrClosableBlock);
        GrField res = (GrField)actionClosure.getParent();
        assert (res.getName().endsWith(FLOW_SUFFIX));
        GrField grField = res;
        if (grField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/pluginSupport/webflow/WebFlowUtils", "getActionByStateDeclaration"));
        }
        return grField;
    }

    @NotNull
    public static String getStateNameByStateDeclaration(@NotNull GrMethodCall stateDeclaration) {
        if (stateDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateDeclaration", "org/jetbrains/plugins/grails/pluginSupport/webflow/WebFlowUtils", "getStateNameByStateDeclaration"));
        }
        String string = ((GrReferenceExpression)stateDeclaration.getInvokedExpression()).getReferenceName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/pluginSupport/webflow/WebFlowUtils", "getStateNameByStateDeclaration"));
        }
        return string;
    }

    public static boolean isStateDeclaration(GrMethodCall methodCall, boolean checkParentField) {
        GrExpression[] allArguments;
        if (checkParentField) {
            PsiElement initClosure = methodCall.getParent();
            if (!(initClosure instanceof GrClosableBlock)) {
                return false;
            }
            PsiElement field = initClosure.getParent();
            if (!(field instanceof GrField)) {
                return false;
            }
            if (!WebFlowUtils.isFlowActionField((GrField)field)) {
                return false;
            }
        }
        if ((allArguments = PsiUtil.getAllArguments((GrCall)methodCall)).length > 1 || allArguments.length == 1 && !(allArguments[0] instanceof GrClosableBlock)) {
            return false;
        }
        GrExpression ie = methodCall.getInvokedExpression();
        if (!(ie instanceof GrReferenceExpression)) {
            return false;
        }
        return !((GrReferenceExpression)ie).isQualified();
    }

    @NotNull
    public static Map<String, PsiVariable> getWebFlowStates(@NotNull GrField field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/plugins/grails/pluginSupport/webflow/WebFlowUtils", "getWebFlowStates"));
        }
        Map cachedValue = (Map)CACHED_STATES_KEY.getCachedValue((PsiElement)field);
        if (cachedValue == null) {
            GrExpression initializer = field.getInitializerGroovy();
            if (initializer instanceof GrClosableBlock) {
                cachedValue = new HashMap();
                for (PsiElement e = initializer.getFirstChild(); e != null; e = e.getNextSibling()) {
                    GrReferenceExpression ie;
                    String stateName;
                    GrMethodCall methodCall;
                    if (!(e instanceof GrMethodCall) || !WebFlowUtils.isStateDeclaration(methodCall = (GrMethodCall)e, false) || (stateName = (ie = (GrReferenceExpression)methodCall.getInvokedExpression()).getReferenceName()) == null) continue;
                    GrLightVariable var = new GrLightVariable(field.getManager(), stateName, (PsiType)PsiType.INT, (PsiElement)ie);
                    cachedValue.put(stateName, var);
                }
            } else {
                cachedValue = Collections.emptyMap();
            }
            cachedValue = (Map)CACHED_STATES_KEY.putCachedValue((PsiElement)field, cachedValue);
        }
        Map map = cachedValue;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/pluginSupport/webflow/WebFlowUtils", "getWebFlowStates"));
        }
        return map;
    }

    public static boolean isFlowInfoCapturerMethod(@Nullable PsiElement element) {
        PsiClass containingClass;
        if (element instanceof PsiMethod && (containingClass = ((PsiMethod)element).getContainingClass()) != null) {
            return "org.codehaus.groovy.grails.webflow.engine.builder.FlowInfoCapturer".equals(containingClass.getQualifiedName());
        }
        return false;
    }
}

