/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.projectView.v2.nodes.leafs;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import icons.JetgroovyIcons;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.projectView.v2.nodes.leafs.ActionNode;
import org.jetbrains.plugins.grails.util.GrailsArtifact;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.mvc.projectView.ClassNode;

public class ControllerClassNode
extends ClassNode {
    public ControllerClassNode(@NotNull Module module, @NotNull GrTypeDefinition controllerClass, @Nullable ViewSettings viewSettings) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/projectView/v2/nodes/leafs/ControllerClassNode", "<init>"));
        }
        if (controllerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "controllerClass", "org/jetbrains/plugins/grails/projectView/v2/nodes/leafs/ControllerClassNode", "<init>"));
        }
        super(module, controllerClass, viewSettings);
    }

    protected void buildChildren(Module module, GrTypeDefinition grClass, List<AbstractTreeNode> children) {
        for (Map.Entry<String, PsiMethod> entry : GrailsUtils.getControllerActions(GrailsArtifact.CONTROLLER.getArtifactName((PsiClass)grClass), module).entrySet()) {
            children.add((AbstractTreeNode)new ActionNode(module, (PsiElement)GrailsUtils.toField(entry.getValue()), this.getSettings()));
        }
    }

    protected String getTestPresentationImpl(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "org/jetbrains/plugins/grails/projectView/v2/nodes/leafs/ControllerClassNode", "getTestPresentationImpl"));
        }
        return "Controller: " + ((GrTypeDefinition)psiElement).getName();
    }

    protected boolean containsImpl(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/grails/projectView/v2/nodes/leafs/ControllerClassNode", "containsImpl"));
        }
        VirtualFile virtualFile = this.getVirtualFile();
        assert (virtualFile != null);
        return ControllerClassNode.isFileBelongsToController(file, (PsiClass)this.extractPsiFromValue());
    }

    public static boolean isFileBelongsToController(@NotNull VirtualFile file, @Nullable PsiClass controller) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/grails/projectView/v2/nodes/leafs/ControllerClassNode", "isFileBelongsToController"));
        }
        if (!GrailsArtifact.CONTROLLER.isInstance(controller)) {
            return false;
        }
        assert (controller != null);
        if (file.equals(controller.getContainingFile().getOriginalFile())) {
            return true;
        }
        VirtualFile viewsFolder = GrailsUtils.getControllerGspDir(controller);
        return viewsFolder != null && VfsUtil.isAncestor((VirtualFile)viewsFolder, (VirtualFile)file, (boolean)false);
    }

    protected void updateImpl(PresentationData data) {
        super.updateImpl(data);
        data.setIcon(JetgroovyIcons.Mvc.Controller);
    }

    public boolean validate() {
        if (!super.validate()) {
            return false;
        }
        GrTypeDefinition grTypeDefinition = this.extractPsiFromValue();
        assert (grTypeDefinition != null);
        if (!GrailsArtifact.CONTROLLER.isInstance((PsiClass)grTypeDefinition)) {
            this.setValue(null);
        }
        return this.getValue() != null;
    }
}

