/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.lang.gsp.resolve.taglib.TagLibNamespaceDescriptor;
import org.jetbrains.plugins.grails.references.util.CodecUtil;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.resolve.NonCodeMembersContributor;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class CodecNonCodeMemberContributor
extends NonCodeMembersContributor {
    private static final String ENCODE_AS = "encodeAs";
    private static final String DECODE = "decode";

    public void processDynamicElements(@NotNull PsiType qualifierType, PsiClass aClass, @NotNull PsiScopeProcessor processor, @NotNull PsiElement place, @NotNull ResolveState state) {
        GrExpression qualifier;
        if (qualifierType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierType", "org/jetbrains/plugins/grails/references/CodecNonCodeMemberContributor", "processDynamicElements"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/grails/references/CodecNonCodeMemberContributor", "processDynamicElements"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/grails/references/CodecNonCodeMemberContributor", "processDynamicElements"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/grails/references/CodecNonCodeMemberContributor", "processDynamicElements"));
        }
        if (!(qualifierType instanceof PsiClassType) && !(qualifierType instanceof PsiArrayType)) {
            return;
        }
        if (!ResolveUtil.shouldProcessMethods((ElementClassHint)((ElementClassHint)processor.getHint(ElementClassHint.KEY)))) {
            return;
        }
        if (aClass instanceof TagLibNamespaceDescriptor.DummyClass) {
            return;
        }
        if (!(place instanceof GrReferenceExpression)) {
            return;
        }
        String name = ResolveUtil.getNameHint((PsiScopeProcessor)processor);
        String codecName = null;
        boolean isEncode = false;
        if (name != null) {
            if (name.startsWith(ENCODE_AS)) {
                codecName = name.substring(ENCODE_AS.length());
                isEncode = true;
            } else {
                if (!name.startsWith(DECODE)) {
                    return;
                }
                codecName = name.substring(DECODE.length());
            }
            if (codecName.isEmpty()) {
                return;
            }
        }
        if ((qualifier = (GrExpression)((GrReferenceExpression)place).getQualifier()) instanceof GrReferenceExpression && ((GrReferenceExpression)qualifier).resolve() instanceof PsiClass) {
            return;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)place);
        if (module == null) {
            return;
        }
        Map<String, Couple<PsiMethod>> codecsMap = CodecUtil.getCodecMap(module);
        if (codecsMap.isEmpty()) {
            return;
        }
        if (GrailsFramework.getInstance().findAppDirectory(place) == null) {
            return;
        }
        CodecNonCodeMemberContributor.processMap(codecsMap, codecName, processor, state, isEncode);
    }

    private static boolean processMap(Map<String, Couple<PsiMethod>> map, String codecName, PsiScopeProcessor processor, ResolveState state, boolean isEncode) {
        if (codecName == null) {
            for (Couple<PsiMethod> methodPair : map.values()) {
                if (methodPair.first != null && !processor.execute((PsiElement)methodPair.first, state)) {
                    return true;
                }
                if (methodPair.second == null || processor.execute((PsiElement)methodPair.second, state)) continue;
                return true;
            }
        } else {
            Couple<PsiMethod> pair = map.get(codecName);
            if (pair != null) {
                PsiMethod method;
                PsiMethod psiMethod = method = isEncode ? (PsiMethod)pair.first : (PsiMethod)pair.second;
                if (method != null) {
                    processor.execute((PsiElement)method, state);
                }
                return true;
            }
        }
        return false;
    }
}

