/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import java.util.EnumMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.pluginSupport.buildTestData.GrailsBuildTestDataMemberProvider;
import org.jetbrains.plugins.grails.pluginSupport.seachable.GrailsSearchableMemberProvider;
import org.jetbrains.plugins.grails.references.MemberProvider;
import org.jetbrains.plugins.grails.references.bootstrap.GrailsBootStrapMemberProvider;
import org.jetbrains.plugins.grails.references.controller.ControllerMembersProvider;
import org.jetbrains.plugins.grails.references.domain.DomainMembersProvider;
import org.jetbrains.plugins.grails.references.filter.FilterMemberProvider;
import org.jetbrains.plugins.grails.references.jobs.JobsMemberProvider;
import org.jetbrains.plugins.grails.references.taglib.TaglibMembersProvider;
import org.jetbrains.plugins.grails.references.urlMappings.UrlMappingMemberProvider;
import org.jetbrains.plugins.grails.util.GrailsArtifact;
import org.jetbrains.plugins.grails.util.GrailsPsiUtil;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.lang.resolve.NonCodeMembersContributor;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class GrailsArtifactNonCodeMemberProcessor
extends NonCodeMembersContributor {
    private static volatile Map<GrailsArtifact, MemberProvider[]> MAP;

    public static Map<GrailsArtifact, MemberProvider[]> getMemberProviderMap() {
        Map<GrailsArtifact, MemberProvider[]> res = MAP;
        if (res == null) {
            res = new EnumMap<GrailsArtifact, MemberProvider[]>(GrailsArtifact.class);
            res.put(GrailsArtifact.CONTROLLER, new MemberProvider[]{new ControllerMembersProvider()});
            res.put(GrailsArtifact.DOMAIN, new MemberProvider[]{new DomainMembersProvider(), new GrailsSearchableMemberProvider(), new GrailsBuildTestDataMemberProvider()});
            res.put(GrailsArtifact.TAGLIB, new MemberProvider[]{new TaglibMembersProvider()});
            res.put(GrailsArtifact.JOB, new MemberProvider[]{new JobsMemberProvider()});
            res.put(GrailsArtifact.FILTER, new MemberProvider[]{new FilterMemberProvider()});
            res.put(GrailsArtifact.URLMAPPINGS, new MemberProvider[]{new UrlMappingMemberProvider()});
            res.put(GrailsArtifact.BOOTSTRAP, new MemberProvider[]{new GrailsBootStrapMemberProvider()});
            MAP = res;
        }
        return res;
    }

    private static boolean isTagLibByPackage(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/plugins/grails/references/GrailsArtifactNonCodeMemberProcessor", "isTagLibByPackage"));
        }
        String qualifiedName = aClass.getQualifiedName();
        return qualifiedName != null && qualifiedName.endsWith("TagLib") && qualifiedName.startsWith("org.codehaus.groovy.grails.plugins.web.taglib.");
    }

    public void processDynamicElements(@NotNull PsiType qualifierType, PsiClass psiClass, @NotNull PsiScopeProcessor processor, @NotNull PsiElement place, @NotNull ResolveState state) {
        if (qualifierType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierType", "org/jetbrains/plugins/grails/references/GrailsArtifactNonCodeMemberProcessor", "processDynamicElements"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/grails/references/GrailsArtifactNonCodeMemberProcessor", "processDynamicElements"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/grails/references/GrailsArtifactNonCodeMemberProcessor", "processDynamicElements"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/grails/references/GrailsArtifactNonCodeMemberProcessor", "processDynamicElements"));
        }
        if (psiClass == null) {
            return;
        }
        GrailsArtifact artifact = GrailsUtils.calculateArtifactType(psiClass);
        if (artifact == null) {
            if (GrailsArtifactNonCodeMemberProcessor.isTagLibByPackage(psiClass)) {
                artifact = GrailsArtifact.TAGLIB;
            } else {
                return;
            }
        }
        if (!GrailsPsiUtil.processLogVariable(processor, psiClass, ResolveUtil.getNameHint((PsiScopeProcessor)processor))) {
            return;
        }
        MemberProvider[] providers = GrailsArtifactNonCodeMemberProcessor.getMemberProviderMap().get((Object)artifact);
        if (providers != null) {
            for (MemberProvider provider : providers) {
                provider.processMembers(processor, psiClass, place);
            }
        }
    }
}

