/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.domain;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.references.domain.DomainDescriptor;
import org.jetbrains.plugins.grails.references.domain.GormUtils;
import org.jetbrains.plugins.grails.util.GrailsArtifactTransformerUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightField;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.resolve.CollectClassMembersUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ast.AstTransformContributor;
import org.jetbrains.plugins.groovy.util.LightCacheKey;

public class GormAstTransformationContributor
extends AstTransformContributor {
    private static LightCacheKey<List<PsiMethod>> CACHED_METHODS = LightCacheKey.createByJavaModificationCount();
    private static Collection<String> EXCLUDED_FROM_VALIDATION_API = Arrays.asList("setErrors", "getErrors", "getBeforeValidateHelper", "setBeforeValidateHelper", "getValidator", "setValidator");

    public void collectMethods(@NotNull GrTypeDefinition aClass, @NotNull Collection<PsiMethod> collector) {
        GormUtils.GormVersion version;
        PsiClassType myMapType;
        boolean hasMapConstructor;
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/plugins/grails/references/domain/GormAstTransformationContributor", "collectMethods"));
        }
        if (collector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collector", "org/jetbrains/plugins/grails/references/domain/GormAstTransformationContributor", "collectMethods"));
        }
        if (!GormUtils.isGormBean((PsiClass)aClass) || !GormAstTransformationContributor.shouldInject((PsiClass)aClass)) {
            return;
        }
        Object[] codeConstructors = aClass.getCodeConstructors();
        boolean hasDefaultConstructor = ContainerUtil.or((Object[])codeConstructors, (Condition)new Condition<GrMethod>(){

            public boolean value(GrMethod method) {
                return method.getParameters().length == 0;
            }
        });
        if (!hasDefaultConstructor) {
            collector.add((PsiMethod)new GrLightMethodBuilder(aClass));
        }
        if (!(hasMapConstructor = ContainerUtil.or((Object[])codeConstructors, (Condition)new Condition<GrMethod>((PsiType)(myMapType = TypesUtil.createTypeByFQClassName((String)"java.util.Map", (PsiElement)aClass))){
            final /* synthetic */ PsiType val$myMapType;
            {
                this.val$myMapType = psiType;
            }

            public boolean value(GrMethod method) {
                return method.getParameters().length == 1 && this.val$myMapType.equals(method.getParameters()[0].getType());
            }
        }))) {
            collector.add((PsiMethod)new GrLightMethodBuilder(aClass).addParameter("namedArgs", (PsiType)myMapType, false));
        }
        if ((version = GormUtils.getGormVersion((PsiElement)aClass)) != GormUtils.GormVersion.BELOW_4) {
            return;
        }
        List<Object> methods = (ArrayList<PsiMethod>)CACHED_METHODS.getCachedValue((PsiElement)aClass);
        if (methods == null) {
            PsiClass validationApi;
            PsiClass staticApi;
            GlobalSearchScope resolveScope;
            methods = new ArrayList<PsiMethod>();
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)aClass.getProject());
            PsiClass instanceApi = facade.findClass("org.grails.datastore.gorm.GormInstanceApi", resolveScope = aClass.getResolveScope());
            if (instanceApi != null) {
                GrailsArtifactTransformerUtils.enhanceAst(instanceApi, aClass, methods, false, new GormAstTransformationMethodFilter(){

                    @Override
                    public boolean value(PsiMethod method) {
                        if (!super.value(method)) {
                            return false;
                        }
                        String name = method.getName();
                        if (GroovyPropertyUtils.isGetterName((String)name)) {
                            return method.getParameterList().getParametersCount() != 1;
                        }
                        if (GroovyPropertyUtils.isSetterName((String)name)) {
                            return method.getParameterList().getParametersCount() != 2;
                        }
                        return true;
                    }
                });
            }
            if ((staticApi = facade.findClass("org.grails.datastore.gorm.GormStaticApi", resolveScope)) != null) {
                GrailsArtifactTransformerUtils.enhanceAst(staticApi, aClass, methods, true, new GormAstTransformationMethodFilter(){

                    @Override
                    public boolean value(PsiMethod method) {
                        if (!super.value(method)) {
                            return false;
                        }
                        String name = method.getName();
                        if (GroovyPropertyUtils.isGetterName((String)name)) {
                            return method.getParameterList().getParametersCount() != 1;
                        }
                        if (GroovyPropertyUtils.isSetterName((String)name)) {
                            return method.getParameterList().getParametersCount() != 2;
                        }
                        return true;
                    }
                });
            }
            if ((validationApi = facade.findClass("org.grails.datastore.gorm.GormValidationApi", resolveScope)) != null) {
                GrailsArtifactTransformerUtils.enhanceAst(validationApi, aClass, methods, false, new GormAstTransformationMethodFilter(){

                    @Override
                    public boolean value(PsiMethod method) {
                        if (!super.value(method)) {
                            return false;
                        }
                        return !EXCLUDED_FROM_VALIDATION_API.contains(method.getName());
                    }
                });
            }
            for (PsiMethod method : methods) {
                ((GrLightMethodBuilder)method).setMethodKind(DomainDescriptor.DOMAIN_DYNAMIC_METHOD);
            }
            methods = (List)CACHED_METHODS.putCachedValue((PsiElement)aClass, methods);
        }
        collector.addAll((Collection<PsiMethod>)methods);
    }

    public void collectFields(@NotNull GrTypeDefinition aClass, @NotNull Collection<GrField> collector) {
        GrLightField field;
        String fieldName;
        GrLightField id;
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/plugins/grails/references/domain/GormAstTransformationContributor", "collectFields"));
        }
        if (collector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collector", "org/jetbrains/plugins/grails/references/domain/GormAstTransformationContributor", "collectFields"));
        }
        if (!GormUtils.isGormBean((PsiClass)aClass) || !GormAstTransformationContributor.shouldInject((PsiClass)aClass)) {
            return;
        }
        Map allFields = CollectClassMembersUtil.getAllFields((PsiClass)aClass, (boolean)false);
        if (!allFields.containsKey("id")) {
            id = new GrLightField((PsiClass)aClass, "id", "java.lang.Long");
            collector.add((GrField)id);
        }
        if (!allFields.containsKey("version")) {
            id = new GrLightField((PsiClass)aClass, "version", "java.lang.Long");
            collector.add((GrField)id);
        }
        DomainDescriptor descriptor = DomainDescriptor.getDescriptor((PsiClass)aClass);
        Set existingFieldNames = allFields.keySet();
        for (Map.Entry<String, Pair<PsiType, PsiElement>> entry : descriptor.getHasMany().entrySet()) {
            fieldName = entry.getKey();
            if (existingFieldNames.contains(fieldName)) continue;
            PsiType type = TypesUtil.createSetType((PsiElement)aClass, (PsiType)((PsiType)entry.getValue().first));
            GrLightField field2 = new GrLightField((PsiClass)aClass, fieldName, type, (PsiElement)entry.getValue().second);
            collector.add((GrField)field2);
        }
        existingFieldNames = ContainerUtil.union(existingFieldNames, descriptor.getHasMany().keySet());
        for (Map.Entry<String, Pair<PsiType, PsiElement>> entry : descriptor.getHasOne().entrySet()) {
            fieldName = entry.getKey();
            if (existingFieldNames.contains(fieldName)) continue;
            field = new GrLightField((PsiClass)aClass, fieldName, (PsiType)entry.getValue().first, (PsiElement)entry.getValue().second);
            collector.add((GrField)field);
        }
        existingFieldNames = ContainerUtil.union((Set)existingFieldNames, descriptor.getHasOne().keySet());
        for (Map.Entry<String, Pair<PsiType, PsiElement>> entry : descriptor.getBelongsTo().entrySet()) {
            fieldName = entry.getKey();
            if (existingFieldNames.contains(fieldName)) continue;
            field = new GrLightField((PsiClass)aClass, fieldName, (PsiType)entry.getValue().first, (PsiElement)entry.getValue().second);
            collector.add((GrField)field);
        }
    }

    private static boolean shouldInject(PsiClass aClass) {
        if (aClass.isEnum()) {
            return false;
        }
        VirtualFile virtualFile = aClass.getContainingFile().getOriginalFile().getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile folder = virtualFile.getParent();
        return folder == null || folder.findChild(aClass.getName() + ".hbm.xml") == null;
    }

    private static class GormAstTransformationMethodFilter
    extends GrailsArtifactTransformerUtils.DefaultFilter {
        public static final GormAstTransformationMethodFilter INSTANCE = new GormAstTransformationMethodFilter();
        private static Set<String> EXCLUDED_METHODS = ContainerUtil.newHashSet((Object[])new String[]{"setProperty", "getProperty", "getMetaClass", "setMetaClass", "invokeMethod", "getMethods", "getExtendedMethods", "wait", "equals", "toString", "hashCode", "getClass", "notify", "notifyAll", "setTransactionManager"});

        private GormAstTransformationMethodFilter() {
        }

        @Override
        public boolean value(PsiMethod method) {
            return super.value(method) && !EXCLUDED_METHODS.contains(method.getName());
        }
    }
}

