/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.domain;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.references.domain.namedQuery.NamedQueryDescriptor;
import org.jetbrains.plugins.grails.util.GrailsArtifact;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightVariable;

public class GormUtils {
    public static final String NAMED_CRITERIA_PROXY_CLASS_NAME = "org.codehaus.groovy.grails.orm.hibernate.cfg.NamedCriteriaProxy";
    public static final String OLD_ENTITY_ANNO = "grails.persistence.Entity";
    public static final String ENTITY_TRAIT = "org.grails.datastore.gorm.GormEntity";

    private GormUtils() {
    }

    public static boolean isGormBean(@Nullable PsiClass aClass) {
        if (GrailsArtifact.DOMAIN.isInstance(aClass)) {
            return true;
        }
        return GormUtils.isStandaloneGormBean(aClass);
    }

    public static boolean isStandaloneGormBean(@Nullable PsiClass aClass) {
        return aClass != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)aClass, (String)OLD_ENTITY_ANNO, (boolean)false);
    }

    public static boolean isNamedQueryDeclaration(PsiElement element) {
        if (!(element instanceof GrReferenceExpression) || ((GrReferenceExpression)element).isQualified()) {
            return false;
        }
        PsiElement eCall = element.getParent();
        if (!(eCall instanceof GrMethodCall)) {
            return false;
        }
        GrMethodCall call = (GrMethodCall)eCall;
        PsiElement eClosure = call.getParent();
        if (!(eClosure instanceof GrClosableBlock)) {
            return false;
        }
        PsiElement eField = eClosure.getParent();
        if (!(eField instanceof GrField)) {
            return false;
        }
        GrField field = (GrField)eField;
        if (!"namedQueries".equals(field.getName()) || !field.hasModifierProperty("static")) {
            return false;
        }
        if (GrailsUtils.getClosureArgument(call) == null) {
            return false;
        }
        PsiClass domainClass = field.getContainingClass();
        return GrailsArtifact.DOMAIN.isInstance(domainClass);
    }

    @Nullable
    public static NamedQueryDescriptor getQueryDescriptorByProxyMethod(@NotNull GrMethodCall callExpression) {
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "org/jetbrains/plugins/grails/references/domain/GormUtils", "getQueryDescriptorByProxyMethod"));
        }
        GrExpression eInvokedExpression = callExpression.getInvokedExpression();
        if (!(eInvokedExpression instanceof GrReferenceExpression)) {
            return null;
        }
        return GormUtils.getQueryDescriptorByProxyMethod((GrReferenceExpression)eInvokedExpression);
    }

    @Nullable
    public static NamedQueryDescriptor getQueryDescriptorByProxyMethod(@NotNull GrReferenceExpression invokedExpression) {
        if (invokedExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "invokedExpression", "org/jetbrains/plugins/grails/references/domain/GormUtils", "getQueryDescriptorByProxyMethod"));
        }
        GrExpression eQualifierExpression = invokedExpression.getQualifierExpression();
        if (eQualifierExpression instanceof GrMethodCall) {
            eQualifierExpression = ((GrMethodCall)eQualifierExpression).getInvokedExpression();
        }
        if (!(eQualifierExpression instanceof GrReferenceExpression)) {
            return null;
        }
        PsiElement resolve = ((GrReferenceExpression)eQualifierExpression).resolve();
        Object key = null;
        if (resolve instanceof GrLightVariable) {
            key = ((GrLightVariable)resolve).getCreatorKey();
        } else if (GrLightMethodBuilder.checkKind((PsiElement)resolve, (Object)NamedQueryDescriptor.NAMED_QUERY_METHOD_MARKER)) {
            key = ((GrLightMethodBuilder)resolve).getData();
        }
        if (!(key instanceof NamedQueryDescriptor)) {
            return null;
        }
        return (NamedQueryDescriptor)key;
    }

    @Nullable
    public static GormVersion getGormVersion(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        return GormUtils.getGormVersion(ModuleUtilCore.findModuleForPsiElement((PsiElement)element));
    }

    @Nullable
    public static GormVersion getGormVersion(@Nullable Module module) {
        if (module == null) {
            return null;
        }
        Project project = module.getProject();
        return (GormVersion)((Object)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)module, () -> CachedValueProvider.Result.create((Object)((Object)GormUtils.doGetGormVersion(module)), (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT})));
    }

    @Nullable
    private static GormVersion doGetGormVersion(@NotNull Module module) {
        GlobalSearchScope scope;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/references/domain/GormUtils", "doGetGormVersion"));
        }
        Project project = module.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        PsiClass gormEntityTrait = facade.findClass(ENTITY_TRAIT, scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
        if (gormEntityTrait != null) {
            return GormVersion.IS_4;
        }
        PsiClass gormApi = facade.findClass("org.grails.datastore.gorm.GormInstanceApi", scope);
        if (gormApi != null) {
            return GormVersion.BELOW_4;
        }
        return null;
    }

    public static enum GormVersion {
        BELOW_4,
        IS_4;

    }
}

