/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.urlMappings;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.xml.XmlElementDescriptor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.impl.gtag.GspLinkElementDescriptor;
import org.jetbrains.plugins.grails.util.GrailsArtifact;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrStringContentImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrStringImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class UrlMappingUtil {
    private static final Key<Pair<Long, Map<String, NamedUrlMapping>>> FILE_KEY = Key.create((String)"Url Mapping file key");
    public static final String GROUP = "group";

    private UrlMappingUtil() {
    }

    public static Map<String, NamedUrlMapping> getNamedUrlMappings(final @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/references/urlMappings/UrlMappingUtil", "getNamedUrlMappings"));
        }
        Project project = module.getProject();
        return (Map)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)module, (CachedValueProvider)new CachedValueProvider<Map<String, NamedUrlMapping>>(){

            public CachedValueProvider.Result<Map<String, NamedUrlMapping>> compute() {
                return CachedValueProvider.Result.create((Object)UrlMappingUtil.calculateNamedUrlMappings(module), (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
            }
        });
    }

    private static Map<String, NamedUrlMapping> calculateNamedUrlMappings(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/references/urlMappings/UrlMappingUtil", "calculateNamedUrlMappings"));
        }
        HashMap<String, NamedUrlMapping> res = new HashMap<String, NamedUrlMapping>();
        for (GrClassDefinition classDefinition : GrailsArtifact.URLMAPPINGS.getInstances(module).values()) {
            UrlMappingUtil.addMapping(res, (PsiClass)classDefinition);
        }
        return res;
    }

    private static void addMapping(Map<String, NamedUrlMapping> res, PsiClass aClass) {
        PsiFile file = aClass.getContainingFile().getOriginalFile();
        Pair pair = (Pair)file.getUserData(FILE_KEY);
        if (pair == null || ((Long)pair.first).longValue() != file.getModificationStamp()) {
            Map<String, NamedUrlMapping> map = UrlMappingUtil.loadMapping(aClass);
            pair = new Pair((Object)file.getModificationStamp(), map);
            file.putUserData(FILE_KEY, (Object)pair);
        }
        res.putAll((Map)pair.second);
    }

    private static Map<String, NamedUrlMapping> loadMapping(PsiClass aClass) {
        HashMap<String, NamedUrlMapping> res = new HashMap<String, NamedUrlMapping>();
        PsiField field = aClass.findFieldByName("mappings", false);
        if (!(field instanceof GrField) || !field.hasModifierProperty("static")) {
            return Collections.emptyMap();
        }
        GrExpression initializer = ((GrField)field).getInitializerGroovy();
        if (!(initializer instanceof GrClosableBlock)) {
            return Collections.emptyMap();
        }
        for (PsiElement e = initializer.getFirstChild(); e != null; e = e.getNextSibling()) {
            GrExpression expr;
            GrNamedArgument na;
            GrArgumentLabel label;
            GrNamedArgument[] namedArguments;
            GrArgumentList arguments;
            GrMethodCall method;
            if (!(e instanceof GrMethodCall) || !PsiUtil.isReferenceWithoutQualifier((PsiElement)(method = (GrMethodCall)e).getInvokedExpression(), (String)"name") || (arguments = method.getArgumentList()) == null || (namedArguments = arguments.getNamedArguments()).length != 1 || (label = (na = namedArguments[0]).getLabel()) == null || !((expr = na.getExpression()) instanceof GrMethodCall)) continue;
            GrMethodCall innerMethod = (GrMethodCall)expr;
            String name = label.getName();
            Map<String, Pair<PsiElement, Boolean>> params = UrlMappingUtil.getParamsByInvokedExpression(innerMethod.getInvokedExpression());
            if (params == null) continue;
            res.put(name, new NamedUrlMapping(name, (PsiElement)label, params));
        }
        return res;
    }

    @Nullable
    public static Map<String, Pair<PsiElement, Boolean>> getParamsByInvokedExpression(@Nullable GrExpression invokedExpression) {
        if (invokedExpression instanceof GrReferenceExpression) {
            if (((GrReferenceExpression)invokedExpression).isQualified()) {
                return null;
            }
            PsiElement referenceNameElement = ((GrReferenceExpression)invokedExpression).getReferenceNameElement();
            if (referenceNameElement == null) {
                return null;
            }
            IElementType elementType = referenceNameElement.getNode().getElementType();
            if (!TokenSets.STRING_LITERAL_SET.contains(elementType)) {
                return null;
            }
            return Collections.emptyMap();
        }
        if (invokedExpression instanceof GrString) {
            HashMap<String, Pair<PsiElement, Boolean>> params = new HashMap<String, Pair<PsiElement, Boolean>>();
            for (PsiElement injection = invokedExpression.getFirstChild(); injection != null; injection = injection.getNextSibling()) {
                String param;
                if (!(injection instanceof GrStringInjection) || (param = UrlMappingUtil.extractName((GrStringInjection)injection)) == null) continue;
                PsiElement next = injection.getNextSibling();
                boolean optional = next instanceof GrStringContentImpl && next.getText().startsWith("?");
                params.put(param, (Pair<PsiElement, Boolean>)Pair.create((Object)injection, (Object)optional));
            }
            return params;
        }
        return null;
    }

    @Nullable
    private static String extractName(GrStringInjection injection) {
        PsiElement dollar = injection.getFirstChild();
        if (dollar == null) {
            return null;
        }
        PsiElement next = dollar.getNextSibling();
        if (next == null || next.getNextSibling() != null) {
            return null;
        }
        if (next instanceof GrReferenceExpression) {
            if (((GrReferenceExpression)next).getQualifierExpression() != null) {
                return null;
            }
            return ((GrReferenceExpression)next).getReferenceName();
        }
        if (!(next instanceof GrClosableBlock)) {
            return null;
        }
        PsiElement closureStart = next.getFirstChild();
        if (closureStart == null) {
            return null;
        }
        PsiElement ref = closureStart.getNextSibling();
        if (ref instanceof GrParameterList) {
            ref = ref.getNextSibling();
        }
        if (!(ref instanceof GrReferenceExpression)) {
            return null;
        }
        PsiElement closureEnd = ref.getNextSibling();
        if (closureEnd == null || closureEnd.getNextSibling() != null) {
            return null;
        }
        if (((GrReferenceExpression)ref).getQualifierExpression() != null) {
            return null;
        }
        return ((GrReferenceExpression)ref).getReferenceName();
    }

    public static boolean isMappingDefinition(@NotNull GrMethodCall methodCall) {
        PsiElement parent;
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "org/jetbrains/plugins/grails/references/urlMappings/UrlMappingUtil", "isMappingDefinition"));
        }
        GrExpression invokedExpression = methodCall.getInvokedExpression();
        if (invokedExpression instanceof GrReferenceExpression) {
            if (((GrReferenceExpression)invokedExpression).isQualified()) {
                return false;
            }
            PsiElement referenceNameElement = ((GrReferenceExpression)invokedExpression).getReferenceNameElement();
            if (referenceNameElement == null) {
                return false;
            }
            IElementType type = referenceNameElement.getNode().getElementType();
            if (!TokenSets.STRING_LITERAL_SET.contains(type)) {
                return false;
            }
        } else if (!(invokedExpression instanceof GrStringImpl)) {
            return false;
        }
        if (!((parent = methodCall.getParent()) instanceof GrClosableBlock)) {
            if (!(parent instanceof GrNamedArgument)) {
                return false;
            }
            GrMethodCall mc = PsiUtil.getMethodCallByNamedParameter((GrNamedArgument)((GrNamedArgument)parent));
            if (mc == null) {
                return false;
            }
            if (!PsiUtil.isReferenceWithoutQualifier((PsiElement)mc.getInvokedExpression(), (String)"name")) {
                return false;
            }
            parent = mc.getParent();
            if (!(parent instanceof GrClosableBlock)) {
                return false;
            }
        }
        parent = UrlMappingUtil.unwrapCloseableBlock((GrClosableBlock)parent);
        return UrlMappingUtil.isMappingField((GrClosableBlock)parent);
    }

    @NotNull
    private static GrClosableBlock unwrapCloseableBlock(@NotNull GrClosableBlock block) {
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "org/jetbrains/plugins/grails/references/urlMappings/UrlMappingUtil", "unwrapCloseableBlock"));
        }
        PsiElement parent = block.getParent();
        if (parent instanceof GrArgumentList) {
            parent = parent.getParent();
        }
        if (!(parent instanceof GrMethodCall)) {
            GrClosableBlock grClosableBlock = block;
            if (grClosableBlock == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/urlMappings/UrlMappingUtil", "unwrapCloseableBlock"));
            }
            return grClosableBlock;
        }
        String methodName = PsiUtil.getUnqualifiedMethodName((GrMethodCall)((GrMethodCall)parent));
        if (!GROUP.equals(methodName)) {
            GrClosableBlock grClosableBlock = block;
            if (grClosableBlock == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/urlMappings/UrlMappingUtil", "unwrapCloseableBlock"));
            }
            return grClosableBlock;
        }
        PsiElement groupParent = parent.getParent();
        if (groupParent instanceof GrClosableBlock) {
            GrClosableBlock grClosableBlock = (GrClosableBlock)groupParent;
            if (grClosableBlock == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/urlMappings/UrlMappingUtil", "unwrapCloseableBlock"));
            }
            return grClosableBlock;
        }
        GrClosableBlock grClosableBlock = block;
        if (grClosableBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/urlMappings/UrlMappingUtil", "unwrapCloseableBlock"));
        }
        return grClosableBlock;
    }

    public static boolean isMappingField(@NotNull GrClosableBlock closure) {
        if (closure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "closure", "org/jetbrains/plugins/grails/references/urlMappings/UrlMappingUtil", "isMappingField"));
        }
        PsiElement field = closure.getParent();
        if (!(field instanceof GrField)) {
            return false;
        }
        if (!"mappings".equals(((GrField)field).getName())) {
            return false;
        }
        PsiClass aClass = ((GrField)field).getContainingClass();
        return GrailsArtifact.URLMAPPINGS.isInstance(aClass);
    }

    public static class NamedUrlMapping {
        private final String name;
        private PsiElement element;
        private Map<String, Pair<PsiElement, Boolean>> params;
        private volatile XmlElementDescriptor elementDescriptor;

        public NamedUrlMapping(String name, PsiElement element, Map<String, Pair<PsiElement, Boolean>> params) {
            this.name = name;
            this.element = element;
            this.params = params;
        }

        public String getName() {
            return this.name;
        }

        public PsiElement getElement() {
            return this.element;
        }

        public XmlElementDescriptor getElementDescriptor() {
            XmlElementDescriptor res = this.elementDescriptor;
            if (res == null) {
                this.elementDescriptor = res = new GspLinkElementDescriptor(this.name, this.element, this.params);
                this.params = null;
            }
            return res;
        }
    }
}

