/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.runner;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.GenericProgramRunner;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.grails.runner.GrailsRunConfiguration;
import org.jetbrains.plugins.grails.runner.impl.GrailsCommandLineState;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.structure.impl.Grails3Application;
import org.jetbrains.plugins.groovy.mvc.MvcCommand;

public class Grails3DebuggerRunner
extends GenericProgramRunner<RunnerSettings> {
    @NotNull
    public String getRunnerId() {
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/runner/Grails3DebuggerRunner", "getRunnerId"));
        }
        return string;
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorId", "org/jetbrains/plugins/grails/runner/Grails3DebuggerRunner", "canRun"));
        }
        if (profile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "org/jetbrains/plugins/grails/runner/Grails3DebuggerRunner", "canRun"));
        }
        if (!Boolean.getBoolean("grails3.debug.gradle")) {
            return false;
        }
        if (!executorId.equals(DefaultDebugExecutor.EXECUTOR_ID)) {
            return false;
        }
        if (!(profile instanceof GrailsRunConfiguration)) {
            return false;
        }
        GrailsRunConfiguration grailsConfiguration = (GrailsRunConfiguration)profile;
        GrailsApplication application = grailsConfiguration.getGrailsApplicationNullable();
        if (!(application instanceof Grails3Application)) {
            return false;
        }
        MvcCommand command = grailsConfiguration.getGrailsCommandNullable();
        if (command == null) {
            return false;
        }
        return "run-app".equals(command.getCommand());
    }

    protected void execute(@NotNull ExecutionEnvironment environment, @Nullable ProgramRunner.Callback callback, @NotNull RunProfileState state) throws ExecutionException {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "org/jetbrains/plugins/grails/runner/Grails3DebuggerRunner", "execute"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/grails/runner/Grails3DebuggerRunner", "execute"));
        }
        if (state instanceof GrailsCommandLineState) {
            GrailsRunConfiguration configuration = ((GrailsCommandLineState)state).getConfiguration();
            MvcCommand command = configuration.getGrailsCommand();
            ExternalSystemTaskExecutionSettings settings = new ExternalSystemTaskExecutionSettings();
            settings.setExecutionName("Grails: " + command.getCommand());
            settings.setExternalProjectPath(configuration.getGrailsApplication().getRoot().getPath());
            settings.setExternalSystemIdString(GradleConstants.SYSTEM_ID.getId());
            settings.setTaskNames(Collections.singletonList("bootRun"));
            settings.setVmOptions(configuration.getVMParameters());
            ExternalSystemUtil.runTask((ExternalSystemTaskExecutionSettings)settings, (String)environment.getExecutor().getId(), (Project)environment.getProject(), (ProjectSystemId)GradleConstants.SYSTEM_ID);
        }
    }
}

