/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.runner;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.runner.GrailsCommandExecutor;
import org.jetbrains.plugins.grails.runner.GrailsCommandLineExecutor;
import org.jetbrains.plugins.grails.runner.GrailsConsole;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.groovy.mvc.ConsoleProcessDescriptor;
import org.jetbrains.plugins.groovy.mvc.MvcCommand;

public final class GrailsCommandExecutorUtil {
    @Nullable
    public static ConsoleProcessDescriptor execute(@NotNull GrailsApplication application, @NotNull MvcCommand command, @Nullable Runnable onDone, boolean close, String ... input) {
        if (application == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "application", "org/jetbrains/plugins/grails/runner/GrailsCommandExecutorUtil", "execute"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/plugins/grails/runner/GrailsCommandExecutorUtil", "execute"));
        }
        try {
            GrailsCommandExecutor executor = GrailsCommandExecutor.getGrailsExecutor(application);
            if (executor == null) {
                return null;
            }
            return executor.execute(application, command, onDone, close, input);
        }
        catch (ExecutionException e) {
            GrailsConsole.getInstance(application.getProject());
            GrailsConsole.NOTIFICATION_GROUP.createNotification(e.getMessage(), NotificationType.ERROR);
            return null;
        }
    }

    public static void executeInModal(@NotNull GrailsApplication application, @NotNull MvcCommand command, final @NotNull String title, final @Nullable Runnable onDone, boolean close) {
        if (application == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "application", "org/jetbrains/plugins/grails/runner/GrailsCommandExecutorUtil", "executeInModal"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/plugins/grails/runner/GrailsCommandExecutorUtil", "executeInModal"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "org/jetbrains/plugins/grails/runner/GrailsCommandExecutorUtil", "executeInModal"));
        }
        assert (!GrailsConsole.getInstance(application.getProject()).isExecuting());
        final Ref processIndicatorRef = new Ref();
        Runnable run = onDone == null ? null : new Runnable(){

            @Override
            public void run() {
                ProgressIndicator indicator = (ProgressIndicator)processIndicatorRef.get();
                if (indicator != null && indicator.isCanceled()) {
                    return;
                }
                ApplicationManager.getApplication().invokeLater(onDone);
            }
        };
        try {
            GeneralCommandLine commandLine = GrailsCommandExecutorUtil.createCommandLine(application, command);
            final ConsoleProcessDescriptor descriptor = GrailsConsole.executeProcess(application.getProject(), commandLine, run, close, new String[0]);
            ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

                @Override
                public void run() {
                    final ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                    processIndicatorRef.set((Object)progressIndicator);
                    progressIndicator.setText(title);
                    descriptor.addProcessListener((ProcessListener)new ProcessAdapter(){

                        public void onTextAvailable(ProcessEvent event, Key outputType) {
                            progressIndicator.setText2(event.getText());
                        }
                    }).waitWith(progressIndicator);
                }
            }, title, true, application.getProject());
        }
        catch (ExecutionException e) {
            GrailsConsole.getInstance(application.getProject());
            GrailsConsole.NOTIFICATION_GROUP.createNotification(e.getMessage(), NotificationType.ERROR);
        }
    }

    @NotNull
    public static GeneralCommandLine createCommandLine(@NotNull GrailsApplication application, @NotNull MvcCommand command) throws ExecutionException {
        if (application == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "application", "org/jetbrains/plugins/grails/runner/GrailsCommandExecutorUtil", "createCommandLine"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/plugins/grails/runner/GrailsCommandExecutorUtil", "createCommandLine"));
        }
        GrailsCommandExecutor executor = GrailsCommandExecutor.getGrailsExecutor(application);
        if (executor instanceof GrailsCommandLineExecutor) {
            GeneralCommandLine generalCommandLine = ((GrailsCommandLineExecutor)executor).createCommandLine(application, command);
            if (generalCommandLine == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/runner/GrailsCommandExecutorUtil", "createCommandLine"));
            }
            return generalCommandLine;
        }
        throw new ExecutionException("Cannot create command line for '" + command + "' in " + application.getRoot());
    }
}

