/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.runner;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.actions.JavaRerunFailedTestsAction;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.actions.AbstractRerunFailedTestsAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.util.text.StringUtil;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.runner.GrailsRunConfiguration;

public class GrailsRerunFailedTestsAction
extends JavaRerunFailedTestsAction {
    public GrailsRerunFailedTestsAction(@NotNull ComponentContainer componentContainer, @NotNull TestConsoleProperties consoleProperties) {
        if (componentContainer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentContainer", "org/jetbrains/plugins/grails/runner/GrailsRerunFailedTestsAction", "<init>"));
        }
        if (consoleProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleProperties", "org/jetbrains/plugins/grails/runner/GrailsRerunFailedTestsAction", "<init>"));
        }
        super(componentContainer, consoleProperties);
    }

    protected AbstractRerunFailedTestsAction.MyRunProfile getRunProfile(final @NotNull ExecutionEnvironment environment) {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "org/jetbrains/plugins/grails/runner/GrailsRerunFailedTestsAction", "getRunProfile"));
        }
        final GrailsRunConfiguration configuration = (GrailsRunConfiguration)this.myConsoleProperties.getConfiguration();
        return new AbstractRerunFailedTestsAction.MyRunProfile((RunConfigurationBase)configuration){

            @NotNull
            public Module[] getModules() {
                if (Module.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/runner/GrailsRerunFailedTestsAction$1", "getModules"));
                }
                return Module.EMPTY_ARRAY;
            }

            public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
                AbstractTestProxy testProxy;
                AbstractTestProxy parent;
                if (executor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "org/jetbrains/plugins/grails/runner/GrailsRerunFailedTestsAction$1", "getState"));
                }
                if (env == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "org/jetbrains/plugins/grails/runner/GrailsRerunFailedTestsAction$1", "getState"));
                }
                GrailsRunConfiguration clone = (GrailsRunConfiguration)configuration.clone();
                String s = clone.getProgramParameters();
                if (s == null) {
                    s = "";
                }
                s = s.replaceAll("((^| )(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*[*\\p{javaJavaIdentifierStart}][*\\p{javaJavaIdentifierPart}]*)+( |$)", " ");
                List failedTests = GrailsRerunFailedTestsAction.this.getFailedTests(configuration.getProject());
                String cmdLine = null;
                if (failedTests.size() == 1 && (parent = (testProxy = (AbstractTestProxy)failedTests.get(0)).getParent()) != null) {
                    cmdLine = s + ' ' + parent.getName() + '.' + testProxy.getName();
                }
                if (cmdLine == null) {
                    HashSet<String> failedTestsNames = new HashSet<String>();
                    for (AbstractTestProxy failedTest : failedTests) {
                        AbstractTestProxy parent2 = failedTest.getParent();
                        if (parent2 == null) continue;
                        failedTestsNames.add(parent2.getName());
                    }
                    cmdLine = s + ' ' + StringUtil.join(failedTestsNames, (String)" ");
                }
                clone.setProgramParameters(cmdLine);
                return clone.getState(executor, environment);
            }
        };
    }
}

