/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.structure;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import java.util.Comparator;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.util.version.Version;

public interface GrailsApplication
extends UserDataHolderEx,
Disposable {
    public static final Comparator<GrailsApplication> COMPARATOR = (app1, app2) -> {
        if (app1 == null && app2 == null) {
            return 0;
        }
        if (app1 == null) {
            return -1;
        }
        if (app2 == null) {
            return 1;
        }
        return app1.getName().compareToIgnoreCase(app2.getName());
    };

    @NotNull
    public String getName();

    @NotNull
    public Icon getIcon();

    @NotNull
    public Project getProject();

    @NotNull
    public VirtualFile getRoot();

    @NotNull
    public VirtualFile getAppRoot();

    @NotNull
    public Version getVersion();

    public boolean isDisposed();

    default public Condition getDisposed() {
        return a -> this.isDisposed();
    }

    @NotNull
    default public GlobalSearchScope getSourcesScope() {
        GlobalSearchScope globalSearchScope = GlobalSearchScopesCore.directoryScope((Project)this.getProject(), (VirtualFile)this.getRoot(), (boolean)true);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/structure/GrailsApplication", "getSourcesScope"));
        }
        return globalSearchScope;
    }
}

