/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.structure;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.service.GrailsBackgroundService;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.structure.GrailsApplicationProvider;
import org.jetbrains.plugins.grails.structure.GrailsStructureListener;
import org.jetbrains.plugins.grails.structure.OldGrailsApplication;

public final class GrailsApplicationManager {
    private static final Logger LOG = Logger.getInstance(GrailsApplicationManager.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProjectFileIndex myFileIndex;
    private final AtomicReference<Map<VirtualFile, GrailsApplication>> myApplicationsRef;

    public GrailsApplicationManager(@NotNull Project project, @NotNull ProjectFileIndex index) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/structure/GrailsApplicationManager", "<init>"));
        }
        if (index == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "org/jetbrains/plugins/grails/structure/GrailsApplicationManager", "<init>"));
        }
        this.myApplicationsRef = new AtomicReference(Collections.emptyMap());
        this.myProject = project;
        this.myFileIndex = index;
    }

    public boolean hasApplications() {
        return !this.getApplicationMap().isEmpty();
    }

    @NotNull
    public Collection<GrailsApplication> getApplications() {
        Collection<GrailsApplication> collection = this.getApplicationMap().values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/structure/GrailsApplicationManager", "getApplications"));
        }
        return collection;
    }

    @NotNull
    public Map<VirtualFile, GrailsApplication> getApplicationMap() {
        Map<VirtualFile, GrailsApplication> map = this.myApplicationsRef.get();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/structure/GrailsApplicationManager", "getApplicationMap"));
        }
        return map;
    }

    @Nullable
    @Contract(value="null -> null")
    public GrailsApplication findApplication(@Nullable VirtualFile file) {
        if (file == null || !this.hasApplications()) {
            return null;
        }
        for (VirtualFile currentFile = this.myFileIndex.getContentRootForFile(file); currentFile != null; currentFile = currentFile.getParent()) {
            GrailsApplication application = this.getApplicationByRoot(currentFile);
            if (application != null) {
                return application;
            }
            if (currentFile.equals(this.myProject.getBaseDir())) break;
        }
        return null;
    }

    @Nullable
    @Contract(value="null -> null")
    public GrailsApplication getApplicationByRoot(@Nullable VirtualFile root) {
        if (root == null) {
            return null;
        }
        return this.getApplicationMap().get(root);
    }

    public void queueUpdate() {
        if (LOG.isTraceEnabled()) {
            LOG.debug("Update queued from ", new Throwable());
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Update queued from " + new Throwable().getStackTrace()[2]);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.doUpdate();
        } else {
            GrailsBackgroundService.getInstance(this.myProject).run(new GrailsRecomputeApplicationTask(this.myProject));
        }
    }

    private void doUpdate() {
        Map map;
        Map<VirtualFile, GrailsApplication> oldMap;
        do {
            boolean changed;
            boolean bl = changed = !(oldMap = this.myApplicationsRef.get()).equals(map = (Map)ApplicationManager.getApplication().runReadAction(this::doGetApplications));
            if (changed) continue;
            return;
        } while (!this.myApplicationsRef.compareAndSet(oldMap, map));
        oldMap.values().forEach(Disposer::dispose);
        ((GrailsStructureListener)this.myProject.getMessageBus().syncPublisher(GrailsStructureListener.LISTENER_TOPIC)).applicationsRecomputed();
    }

    @NotNull
    private Map<VirtualFile, GrailsApplication> doGetApplications() {
        Collection appRoots = FilenameIndex.getVirtualFilesByName((Project)this.myProject, (String)"grails-app", (GlobalSearchScope)GlobalSearchScope.allScope((Project)this.myProject));
        if (appRoots.isEmpty()) {
            Map<VirtualFile, GrailsApplication> map = Collections.emptyMap();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/structure/GrailsApplicationManager", "doGetApplications"));
            }
            return map;
        }
        HashMap result = ContainerUtil.newHashMap();
        appRoots.stream().filter(VirtualFile::isDirectory).forEach(appRoot -> {
            GrailsApplication application;
            VirtualFile root = appRoot.getParent();
            if (root != null && root.isDirectory() && (application = GrailsApplicationProvider.createGrailsApplication(this.myProject, root)) != null) {
                result.put(root, application);
            }
        });
        HashMap hashMap = result;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/structure/GrailsApplicationManager", "doGetApplications"));
        }
        return hashMap;
    }

    @NotNull
    public static GrailsApplicationManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/structure/GrailsApplicationManager", "getInstance"));
        }
        GrailsApplicationManager grailsApplicationManager = (GrailsApplicationManager)ServiceManager.getService((Project)project, GrailsApplicationManager.class);
        if (grailsApplicationManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/structure/GrailsApplicationManager", "getInstance"));
        }
        return grailsApplicationManager;
    }

    @Nullable
    @Contract(value="null -> null")
    public static GrailsApplication findApplication(@Nullable PsiElement element) {
        PsiFile psiFile;
        if (element == null) {
            return null;
        }
        VirtualFile file = element instanceof PsiFileSystemItem ? ((PsiFileSystemItem)element).getVirtualFile() : ((psiFile = element.getContainingFile()) == null ? null : psiFile.getVirtualFile());
        return GrailsApplicationManager.getInstance(element.getProject()).findApplication(file);
    }

    @Nullable
    @Contract(value="null -> null")
    public static OldGrailsApplication findApplication(@Nullable Module module) {
        if (module == null) {
            return null;
        }
        for (GrailsApplication application : GrailsApplicationManager.getInstance(module.getProject()).getApplications()) {
            if (!(application instanceof OldGrailsApplication) || !((OldGrailsApplication)application).getModule().equals(module)) continue;
            return (OldGrailsApplication)application;
        }
        return null;
    }

    private static class GrailsRecomputeApplicationTask
    extends Task.Backgroundable {
        public GrailsRecomputeApplicationTask(@Nullable Project project) {
            super(project, "Searching for Grails Applications", false);
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/grails/structure/GrailsApplicationManager$GrailsRecomputeApplicationTask", "run"));
            }
            GrailsApplicationManager.getInstance(this.getProject()).doUpdate();
        }
    }
}

