/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.structure.impl;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.grails.gradle.GrailsModuleData;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.structure.GrailsApplicationProvider;
import org.jetbrains.plugins.grails.structure.impl.Grails3Application;
import org.jetbrains.plugins.grails.structure.impl.OldGrailsGradleApplication;

public class GrailsGradleApplicationProvider
extends GrailsApplicationProvider {
    @Override
    @Nullable
    public GrailsApplication createApplication(@NotNull Project project, @NotNull VirtualFile root) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/structure/impl/GrailsGradleApplicationProvider", "createApplication"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/plugins/grails/structure/impl/GrailsGradleApplicationProvider", "createApplication"));
        }
        ExternalProjectInfo gradleProjectInfo = ExternalSystemUtil.getExternalProjectInfo((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID, (String)root.getPath());
        if (gradleProjectInfo == null) {
            return null;
        }
        DataNode moduleData = GradleProjectResolverUtil.findModule((DataNode)gradleProjectInfo.getExternalProjectStructure(), (String)root.getPath());
        if (moduleData == null) {
            return null;
        }
        DataNode dataNode = ExternalSystemApiUtil.find((DataNode)moduleData, GrailsModuleData.KEY);
        if (dataNode == null) {
            return null;
        }
        String name = ((ModuleData)moduleData.getData()).getExternalName();
        GrailsModuleData data = (GrailsModuleData)((Object)dataNode.getData());
        if (data.getGrailsPluginId().equals("grails")) {
            return new OldGrailsGradleApplication(project, root, name, data);
        }
        return new Grails3Application(project, root, name, data);
    }
}

