/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.structure.sync;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.util.messages.MessageBusConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.structure.GrailsStructureListener;
import org.jetbrains.plugins.grails.structure.impl.Grails2Application;
import org.jetbrains.plugins.groovy.mvc.MvcModuleStructureSynchronizer;

public class GrailsMvcStructureRefresher
implements StartupActivity {
    public void runActivity(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/structure/sync/GrailsMvcStructureRefresher", "runActivity"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        final MvcModuleStructureSynchronizer synchronizer = MvcModuleStructureSynchronizer.getInstance((Project)project);
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(GrailsStructureListener.LISTENER_TOPIC, (Object)new GrailsStructureListener(){

            @Override
            public void applicationsRecomputed() {
                synchronizer.getFileAndRootsModificationTracker().incModificationCount();
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/structure/sync/GrailsMvcStructureRefresher$1", "lambda$applicationsRecomputed$0"));
                    }
                    synchronizer.queue(MvcModuleStructureSynchronizer.SyncAction.UpdateProjectStructure, (Object)project);
                    synchronizer.queue(MvcModuleStructureSynchronizer.SyncAction.UpgradeFramework, (Object)project);
                }, project.getDisposed());
            }

            @Override
            public void sdkChanged(GrailsApplication application) {
                if (application instanceof Grails2Application) {
                    synchronizer.getFileAndRootsModificationTracker().incModificationCount();
                    ApplicationManager.getApplication().invokeLater(() -> GrailsFramework.forceSynchronizationSetting(((Grails2Application)application).getModule()), application.getDisposed());
                }
            }
        });
    }
}

