/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.structure.sync;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.util.messages.MessageBusConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.service.GrailsBackgroundService;
import org.jetbrains.plugins.grails.settings.GrailsInjectedTraitService;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.structure.GrailsApplicationManager;
import org.jetbrains.plugins.grails.structure.GrailsStructureListener;
import org.jetbrains.plugins.grails.structure.sync.GrailsRunConfigurationTask;
import org.jetbrains.plugins.grails.structure.sync.GrailsSdkCheckTask;

public class GrailsStartupActivity
implements StartupActivity {
    public void runActivity(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/structure/sync/GrailsStartupActivity", "runActivity"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(GrailsStructureListener.LISTENER_TOPIC, (Object)new GrailsStructureListener(){

            @Override
            public void applicationsRecomputed() {
                GrailsBackgroundService backgroundService = GrailsBackgroundService.getInstance(project);
                backgroundService.run(new GrailsRunConfigurationTask(project));
                backgroundService.run(new GrailsSdkCheckTask(project));
                GrailsInjectedTraitService.getInstance(project).queueUpdate(false);
            }

            @Override
            public void sdkChanged(GrailsApplication application) {
                GrailsInjectedTraitService.getInstance(project).queueUpdate(true);
            }
        });
        GrailsApplicationManager.getInstance(project).queueUpdate();
    }
}

