/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.ui;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.config.GrailsConfigUtils;
import org.jetbrains.plugins.grails.sdk.GrailsSDK;
import org.jetbrains.plugins.grails.util.version.Range;
import org.jetbrains.plugins.grails.util.version.Version;
import org.jetbrains.plugins.grails.util.version.VersionImpl;

public class GrailsSDKHomeForm {
    private static final FileChooserDescriptor FILE_CHOOSER_DESCRIPTOR = new FileChooserDescriptor(false, true, false, false, false, false){

        public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
            return super.isFileVisible(file, showHiddenFiles) && file.isDirectory();
        }

        public void validateSelectedFiles(VirtualFile[] files) throws Exception {
            assert (files.length == 1);
            VirtualFile file = files[0];
            String version = GrailsConfigUtils.getInstance().getSDKVersion(file.getPath());
            if (version == "undefined") {
                throw new Exception(ProjectBundle.message((String)(file.isDirectory() ? "sdk.configure.home.invalid.error" : "sdk.configure.home.file.invalid.error"), (Object[])new Object[]{"Grails SDK"}));
            }
        }
    }.withShowHiddenFiles(true);
    private JPanel myComponent;
    private TextFieldWithBrowseButton myPath;
    private JBLabel myVersionLabel;
    @Nullable
    private Range<Version> myVersionRange;
    @Nullable
    private Runnable myChangedCallback;
    private GrailsSDK mySelectedSdk;

    public GrailsSDKHomeForm() {
        this.$$$setupUI$$$();
        this.myPath.addBrowseFolderListener(new TextBrowseFolderListener(FILE_CHOOSER_DESCRIPTOR){

            protected void onFileChosen(@NotNull VirtualFile chosenFile) {
                if (chosenFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chosenFile", "org/jetbrains/plugins/grails/ui/GrailsSDKHomeForm$2", "onFileChosen"));
                }
                super.onFileChosen(chosenFile);
                GrailsSDKHomeForm.this.validate();
                if (GrailsSDKHomeForm.this.myChangedCallback != null) {
                    GrailsSDKHomeForm.this.myChangedCallback.run();
                }
            }

            @Nullable
            protected VirtualFile getInitialFile() {
                VirtualFile file = super.getInitialFile();
                if (file != null) {
                    return file;
                }
                VirtualFile gvmCurrent = VfsUtil.findRelativeFile((VirtualFile)VfsUtil.getUserHomeDir(), (String[])new String[]{".gvm", "grails", "current"});
                if (gvmCurrent != null) {
                    return gvmCurrent;
                }
                return VfsUtil.findRelativeFile((VirtualFile)VfsUtil.getUserHomeDir(), (String[])new String[]{".sdkman", "grails", "current"});
            }
        });
        this.myPath.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                GrailsSDKHomeForm.this.validate();
                if (GrailsSDKHomeForm.this.myChangedCallback != null) {
                    GrailsSDKHomeForm.this.myChangedCallback.run();
                }
            }
        });
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    public JComponent getPathComponent() {
        return this.myPath;
    }

    @NotNull
    public GrailsSDK getSelectedSdk() {
        GrailsSDK grailsSDK = (GrailsSDK)ObjectUtils.assertNotNull((Object)this.mySelectedSdk);
        if (grailsSDK == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/ui/GrailsSDKHomeForm", "getSelectedSdk"));
        }
        return grailsSDK;
    }

    public GrailsSDKHomeForm setPath(String path) {
        this.myPath.setText(path);
        this.validate();
        return this;
    }

    public GrailsSDKHomeForm setVersionRange(@Nullable Range<Version> versionRange) {
        this.myVersionRange = versionRange;
        this.validate();
        return this;
    }

    public GrailsSDKHomeForm setChangedCallback(@Nullable Runnable changedCallback) {
        this.myChangedCallback = changedCallback;
        return this;
    }

    public GrailsSDKHomeForm setEditable(boolean editable) {
        this.myPath.setEditable(editable);
        this.myPath.setButtonEnabled(editable);
        return this;
    }

    public boolean validate() {
        String path = this.myPath.getText();
        if (StringUtil.isEmpty((String)path)) {
            return this.error("Grails SDK is not selected");
        }
        String version = GrailsConfigUtils.getInstance().getSDKVersion(path);
        if (version == "undefined") {
            return this.error("Cannot determine Grails SDK version");
        }
        if (this.myVersionRange == null || this.myVersionRange.contains(new VersionImpl(version))) {
            this.mySelectedSdk = new GrailsSDK(path, new VersionImpl(version));
            return this.message("Grails SDK version " + version, false);
        }
        return this.error("Grails SDK version must be " + GrailsSDKHomeForm.prettyPrint(this.myVersionRange));
    }

    private boolean error(String message) {
        this.mySelectedSdk = null;
        return this.message(message, true);
    }

    private boolean message(String message, boolean isError) {
        this.myVersionLabel.setText("<html>" + message + "</html>");
        this.myVersionLabel.setForeground((Color)(isError ? JBColor.RED : JBColor.foreground()));
        return !isError;
    }

    @NotNull
    private static String prettyPrint(@NotNull Range<Version> range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "org/jetbrains/plugins/grails/ui/GrailsSDKHomeForm", "prettyPrint"));
        }
        StringBuilder sb = new StringBuilder();
        if (range.getStart() != null) {
            sb.append(range.isStartInclusive() ? "at least" : "more than").append(" ").append(range.getStart());
        }
        if (range.getStart() != null && range.getEnd() != null) {
            sb.append(" and ");
        }
        if (range.getEnd() != null) {
            sb.append(range.isEndInclusive() ? "not more than" : "less than").append(" ").append(range.getEnd());
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/ui/GrailsSDKHomeForm", "prettyPrint"));
        }
        return string;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.myComponent = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Grails SDK Home:");
        jBLabel2.setDisplayedMnemonic('H');
        jBLabel2.setDisplayedMnemonicIndex(11);
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 0, 3, 0, 0, null, null, null));
        this.myPath = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 3, 6, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myVersionLabel = jBLabel = new JBLabel();
        jBLabel.setVisible(true);
        jBLabel.setEnabled(true);
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel.setText("");
        jPanel.add((Component)jBLabel, new GridConstraints(1, 1, 1, 1, 1, 1, 0, 6, null, new Dimension(500, -1), null, 1));
        jBLabel2.setLabelFor((Component)textFieldWithBrowseButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myComponent;
    }
}

