/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc.plugins;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbModePermission;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.jetbrains.plugins.grails.actions.GrailsActionUtil;
import org.jetbrains.plugins.grails.runner.GrailsCommandExecutor;
import org.jetbrains.plugins.grails.runner.GrailsConsole;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.structure.OldGrailsApplication;
import org.jetbrains.plugins.grails.util.version.Version;
import org.jetbrains.plugins.groovy.mvc.plugins.AvailablePluginsModel;
import org.jetbrains.plugins.groovy.mvc.plugins.InstallUninstallPluginsDialog;
import org.jetbrains.plugins.groovy.mvc.plugins.MvcPluginDescriptor;
import org.jetbrains.plugins.groovy.mvc.plugins.MvcPluginIsInstalledColumnInfo;
import org.jetbrains.plugins.groovy.mvc.plugins.MvcPluginUtil;
import org.jetbrains.plugins.groovy.mvc.plugins.MvcPluginsMain;
import org.jetbrains.plugins.groovy.mvc.plugins.actions.ReloadMvcPluginListAction;

public class MvcPluginsAction
extends AnAction {
    public void update(AnActionEvent e) {
        GrailsApplication application = GrailsActionUtil.getGrailsApplication(e.getDataContext());
        e.getPresentation().setEnabledAndVisible(application instanceof OldGrailsApplication && application.getVersion().isLessThan(Version.GRAILS_2_3_0) && GrailsCommandExecutor.getGrailsExecutor(application) != null);
    }

    public void actionPerformed(AnActionEvent e) {
        final OldGrailsApplication application = (OldGrailsApplication)GrailsActionUtil.getGrailsApplication(e.getDataContext());
        assert (application != null);
        final Project project = application.getProject();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                final DialogBuilder dialogBuilder = new DialogBuilder(project);
                dialogBuilder.addOkAction().setText("&Apply changes");
                final MvcPluginsMain mvcPluginsMain = new MvcPluginsMain(application, dialogBuilder);
                AvailablePluginsModel tableModel = mvcPluginsMain.getPluginTable().getModel();
                final MvcPluginIsInstalledColumnInfo pluginIsInstalledColumnInfo = (MvcPluginIsInstalledColumnInfo)tableModel.getColumnInfos()[0];
                dialogBuilder.setOkActionEnabled(false);
                dialogBuilder.addCancelAction();
                dialogBuilder.setTitle("Grails plugins");
                dialogBuilder.setCenterPanel(mvcPluginsMain.getMainPanel());
                dialogBuilder.setOkOperation(new Runnable(){

                    @Override
                    public void run() {
                        Map<MvcPluginDescriptor, String> pluginToPath = mvcPluginsMain.getCustomPlugins();
                        Set<String> toRemovePluginNames = pluginIsInstalledColumnInfo.getToRemovePlugins();
                        Set<String> toInstallPluginNames = pluginIsInstalledColumnInfo.getToInstallPlugins();
                        if (toRemovePluginNames.size() == 0 && toInstallPluginNames.size() == 0) {
                            StatusBar statusBar = WindowManager.getInstance().getStatusBar(project);
                            if (statusBar != null) {
                                statusBar.setInfo("There are no plugins to install or uninstall");
                            }
                            return;
                        }
                        Map<String, MvcPluginDescriptor> pluginMap = mvcPluginsMain.getPluginDescriptions();
                        ArrayList<MvcPluginDescriptor> toInstallCustomPlugins = new ArrayList<MvcPluginDescriptor>();
                        ArrayList<MvcPluginDescriptor> toInstallServerPlugins = new ArrayList<MvcPluginDescriptor>();
                        for (String string : toInstallPluginNames) {
                            MvcPluginDescriptor plugin = pluginMap.get(string);
                            if (pluginToPath.containsKey(plugin)) {
                                toInstallCustomPlugins.add(plugin);
                                continue;
                            }
                            toInstallServerPlugins.add(plugin);
                        }
                        ArrayList<MvcPluginDescriptor> toRemovePlugins = new ArrayList<MvcPluginDescriptor>(toRemovePluginNames.size());
                        for (String toRemovePluginName : toRemovePluginNames) {
                            toRemovePlugins.add(pluginMap.get(toRemovePluginName));
                        }
                        InstallUninstallPluginsDialog installUninstallPluginsDialog = new InstallUninstallPluginsDialog(toInstallServerPlugins, toInstallCustomPlugins, toRemovePlugins, application, mvcPluginsMain.getCustomPlugins());
                        installUninstallPluginsDialog.show();
                        if (0 == installUninstallPluginsDialog.getExitCode()) {
                            dialogBuilder.getDialogWrapper().close(0);
                            installUninstallPluginsDialog.doInstallRemove();
                        }
                    }
                });
                dialogBuilder.getWindow().addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowOpened(WindowEvent e) {
                        Boolean f = (Boolean)MvcPluginUtil.PLUGIN_LIST_DONOT_DOWNLOADED.get((UserDataHolder)application);
                        if (f != null && f.booleanValue()) {
                            MvcPluginUtil.PLUGIN_LIST_DONOT_DOWNLOADED.set((UserDataHolder)application, null);
                            ApplicationManager.getApplication().invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (dialogBuilder.getWindow().isShowing() && !GrailsConsole.getInstance(project).isExecuting()) {
                                        ReloadMvcPluginListAction.doReloadPluginList(mvcPluginsMain);
                                    }
                                }
                            });
                        }
                    }
                });
                DumbService.allowStartingDumbModeInside((DumbModePermission)DumbModePermission.MAY_START_BACKGROUND, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        dialogBuilder.show();
                    }
                });
            }
        };
        GrailsConsole.getInstance(project).show(runnable, false);
    }
}

