/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.cloudfoundry.application.service;

import com.intellij.javaee.cloudfoundry.agent.service.CFAppServicesDomainImpl;
import com.intellij.javaee.cloudfoundry.agent.service.CFAppServicesImpl;
import com.intellij.javaee.cloudfoundry.agent.service.CFServiceWrapper;
import com.intellij.javaee.cloudfoundry.agent.service.CFServicesDomain;
import com.intellij.javaee.cloudfoundry.application.service.CFAppServicesModel;
import com.intellij.javaee.cloudfoundry.application.service.NewAppServiceEditor;
import com.intellij.javaee.oss.cloud.server.config.TableConfigEditor;
import com.intellij.javaee.oss.util.Column;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class AppServicesEditor
extends TableConfigEditor<CFAppServicesModel, CFServicesDomain, ServiceRow, ServiceColumn, CFServiceWrapper, NewAppServiceEditor> {
    private JPanel myMainPanel;
    private JPanel myServicesPanel;

    private static ServiceColumn[] createColumns(boolean perApplication) {
        ArrayList<ServiceColumn> result = new ArrayList<ServiceColumn>();
        if (perApplication) {
            result.add(new ActiveColumn());
        }
        result.add(new NameColumn());
        result.add(new VendorColumn());
        result.add(new VersionColumn());
        result.add(new TierColumn());
        return result.toArray(new ServiceColumn[result.size()]);
    }

    public AppServicesEditor(boolean perApplication) {
        super((Column[])AppServicesEditor.createColumns(perApplication));
        this.$$$setupUI$$$();
    }

    protected void doResetEditorFrom(CFAppServicesModel servicesModel, List<ServiceRow> rows) {
        HashSet<String> activeServiceNames = new HashSet<String>(servicesModel.getAppServices().getServiceNames());
        for (CFServiceWrapper serviceWrapper : servicesModel.getAppServicesDomain().getAvailableServices()) {
            ServiceRow row = new ServiceRow(serviceWrapper);
            row.setActive(activeServiceNames.contains(row.getName()));
            rows.add(row);
        }
    }

    protected void doApplyEditorTo(CFAppServicesModel servicesModel, List<ServiceRow> rows) throws ConfigurationException {
        ArrayList<CFServiceWrapper> services = new ArrayList<CFServiceWrapper>();
        ArrayList<String> activeServiceNames = new ArrayList<String>();
        for (ServiceRow row : rows) {
            services.add(row.getServiceWrapper());
            if (!row.isActive()) continue;
            activeServiceNames.add(row.getName());
        }
        CFAppServicesImpl appServices = new CFAppServicesImpl();
        appServices.setServiceNames(activeServiceNames);
        servicesModel.setAppServices(appServices);
        servicesModel.setAppServicesDomain(new CFAppServicesDomainImpl(services));
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/cloudfoundry/application/service/AppServicesEditor", "createEditor"));
        }
        return jPanel;
    }

    private void createUIComponents() {
        this.myServicesPanel = this.createTablePanel();
    }

    protected NewAppServiceEditor createItemEditor(CFServicesDomain domain) {
        return new NewAppServiceEditor(domain);
    }

    protected ServiceRow wrapItem2Row(CFServiceWrapper item) {
        return new ServiceRow(item);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = this.myServicesPanel;
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private static class TierColumn
    extends ServiceColumn {
        public TierColumn() {
            super("Tier");
        }

        public Object getColumnValue(ServiceRow row) {
            return row.getServiceWrapper().getTier();
        }
    }

    private static class VersionColumn
    extends ServiceColumn {
        public VersionColumn() {
            super("Version");
        }

        public Object getColumnValue(ServiceRow row) {
            return row.getServiceWrapper().getVersion();
        }
    }

    private static class VendorColumn
    extends ServiceColumn {
        public VendorColumn() {
            super("Vendor");
        }

        public Object getColumnValue(ServiceRow row) {
            return row.getServiceWrapper().getVendor();
        }
    }

    private static class NameColumn
    extends ServiceColumn {
        public NameColumn() {
            super("Name");
        }

        public Object getColumnValue(ServiceRow row) {
            return row.getName();
        }
    }

    private static class ActiveColumn
    extends ServiceColumn {
        public ActiveColumn() {
            super("Active");
        }

        public boolean isEditable() {
            return true;
        }

        public Class<?> getValueClass() {
            return Boolean.class;
        }

        public Object getColumnValue(ServiceRow row) {
            return row.isActive();
        }

        public void setColumnValue(ServiceRow row, Object value) {
            row.setActive((Boolean)value);
        }

        public boolean needPack() {
            return true;
        }
    }

    public static abstract class ServiceColumn
    extends Column<ServiceRow> {
        public ServiceColumn(String name) {
            super(name);
        }
    }

    public static class ServiceRow {
        private final CFServiceWrapper myServiceWrapper;
        private boolean myActive = false;

        public ServiceRow(CFServiceWrapper serviceWrapper) {
            this.myServiceWrapper = serviceWrapper;
        }

        public CFServiceWrapper getServiceWrapper() {
            return this.myServiceWrapper;
        }

        public boolean isActive() {
            return this.myActive;
        }

        public void setActive(boolean active) {
            this.myActive = active;
        }

        public String getName() {
            return this.getServiceWrapper().getName();
        }
    }
}

