/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.cloudfoundry.cloud;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.javaee.cloudfoundry.CFDeploymentType;
import com.intellij.javaee.cloudfoundry.agent.CFAppFogInfra;
import com.intellij.javaee.cloudfoundry.agent.service.CFAppServicesDomain;
import com.intellij.javaee.cloudfoundry.agent.service.CFAppServicesDomainImpl;
import com.intellij.javaee.cloudfoundry.agent.service.CFAppServicesImpl;
import com.intellij.javaee.cloudfoundry.agent.service.CFServicesDomain;
import com.intellij.javaee.cloudfoundry.agent.service.CFServicesDomainImpl;
import com.intellij.javaee.cloudfoundry.agent.settings.CFAppSettingsImpl;
import com.intellij.javaee.cloudfoundry.agent.settings.CFAppSettingsRange;
import com.intellij.javaee.cloudfoundry.agent.settings.CFAppSettingsRangeImpl;
import com.intellij.javaee.cloudfoundry.application.service.AppServicesEditor;
import com.intellij.javaee.cloudfoundry.application.service.CFAppServicesModel;
import com.intellij.javaee.cloudfoundry.application.settings.AppSettingsEditor;
import com.intellij.javaee.cloudfoundry.cloud.CFCloudLocation;
import com.intellij.javaee.cloudfoundry.cloud.CFConnectionTask;
import com.intellij.javaee.cloudfoundry.cloud.CFDeploymentConfiguration;
import com.intellij.javaee.cloudfoundry.cloud.CFManifest;
import com.intellij.javaee.cloudfoundry.cloud.CFServerConfiguration;
import com.intellij.javaee.cloudfoundry.cloud.CFServerRuntimeInstanceBase;
import com.intellij.javaee.cloudfoundry.cloud.CFServerRuntimeInstanceV1;
import com.intellij.javaee.oss.cloud.server.config.CloudConfigDialog;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.util.DelayedRunner;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;

public class CFDeploymentEditor
extends SettingsEditor<CFDeploymentConfiguration> {
    private static final Logger LOG = Logger.getInstance((String)("#" + CFDeploymentEditor.class.getName()));
    private static final String MANIFEST_FILE_EXTENSION = "yml";
    private JPanel myMainPanel;
    private JBLabel myTypeLabel;
    private JComboBox myTypeComboBox;
    private JBLabel myInfraLabel;
    private ComboBox myInfraComboBox;
    private JCheckBox myCustomDomainCheckBox;
    private JTextField myDomainTextField;
    private JBCheckBox myDebugCheckBox;
    private JButton myServicesButton;
    private JPanel mySettingsPanel;
    private TitledSeparator myServicesTitledSeparator;
    private JPanel myServicesPanel;
    private JBLabel myDomainLabel;
    private TextFieldWithBrowseButton myManifestTextField;
    private JComboBox myApplicationComboBox;
    private JBLabel myManifestLabel;
    private JBLabel myApplicationLabel;
    private AppSettingsEditor myAppSettingsEditor;
    private AppServicesEditor myAppServicesEditor;
    private JTextComponent myInfraText;
    private CFServerConfiguration myConfiguration;
    private RemoteServer<CFServerConfiguration> myServer;
    private DeploymentSource myDeploymentSource;
    private Project myProject;
    private CFAppSettingsRangeImpl mySettingsRange;
    private CFServicesDomainImpl myServicesDomain;

    public CFDeploymentEditor(Project project, RemoteServer<CFServerConfiguration> server, DeploymentSource source) {
        this.myProject = project;
        this.myDeploymentSource = source;
        this.$$$setupUI$$$();
        this.myConfiguration = (CFServerConfiguration)server.getConfiguration();
        this.myServer = server;
        for (CFDeploymentType cFDeploymentType : CFDeploymentType.values()) {
            this.myTypeComboBox.addItem(cFDeploymentType);
        }
        this.myTypeComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    CFDeploymentEditor.this.onTypeSelected();
                }
            }
        });
        this.myInfraText = (JTextComponent)this.myInfraComboBox.getEditor().getEditorComponent();
        this.myInfraText.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                CFDeploymentEditor.this.buildUI();
            }
        });
        this.myCustomDomainCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CFDeploymentEditor.this.buildUI();
            }
        });
        this.myServicesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CFDeploymentEditor.this.editServicesDomain();
            }
        });
        for (Enum enum_ : CFAppFogInfra.values()) {
            this.myInfraComboBox.addItem((Object)enum_);
        }
        this.buildUI();
        new DelayedRunner(this.myMainPanel){
            boolean myStarted;
            {
                this.myStarted = false;
            }

            protected boolean wasChanged() {
                if (this.myStarted) {
                    return false;
                }
                this.myStarted = true;
                return true;
            }

            protected void run() {
                CFDeploymentEditor.this.reload();
            }
        };
        String manifestFileChooserDescription = "Choose manifest file";
        FileChooserDescriptor manifestFileChooserDescriptor = new FileChooserDescriptor(true, false, false, false, false, false){

            public void validateSelectedFiles(VirtualFile[] files) throws Exception {
                for (VirtualFile virtualFile : files) {
                    new CFManifest(virtualFile.getPath()).validate();
                }
            }
        };
        manifestFileChooserDescriptor.withFileFilter((Condition)new Condition<VirtualFile>(){

            public boolean value(VirtualFile file) {
                return StringUtil.equals((CharSequence)file.getExtension(), (CharSequence)CFDeploymentEditor.MANIFEST_FILE_EXTENSION);
            }
        });
        manifestFileChooserDescriptor.setRoots(new VirtualFile[]{project.getBaseDir()});
        this.myManifestTextField.addBrowseFolderListener(null, manifestFileChooserDescription, null, manifestFileChooserDescriptor);
        this.myManifestTextField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                CFDeploymentEditor.this.loadApplications();
            }
        });
    }

    private void loadApplications() {
        this.myApplicationComboBox.removeAllItems();
        if (StringUtil.isEmpty((String)this.myManifestTextField.getText())) {
            return;
        }
        for (String application : this.createManifest().getApplicationsNames()) {
            this.myApplicationComboBox.addItem(application);
        }
    }

    private CFAppSettingsRangeImpl getSettingsRange() {
        if (this.mySettingsRange == null) {
            this.mySettingsRange = new CFAppSettingsRangeImpl();
        }
        return this.mySettingsRange;
    }

    private CFServicesDomainImpl getServicesDomain() {
        if (this.myServicesDomain == null) {
            this.myServicesDomain = new CFServicesDomainImpl();
        }
        return this.myServicesDomain;
    }

    private void resetSettingsRange() {
        this.getAppSettingsEditor().init(this.myProject, this.getSettingsRange());
    }

    private void resetServicesDomain() {
        this.getAppServicesEditor().init(this.myProject, this.getServicesDomain());
    }

    private void setAppServicesDomain(CFServicesDomain servicesDomain, CFAppServicesDomain appServicesDomain) {
        this.myServicesDomain = new CFServicesDomainImpl(servicesDomain);
        this.resetServicesDomain();
        try {
            AppServicesEditor appServicesEditor = this.getAppServicesEditor();
            CFAppServicesModel appServicesModel = new CFAppServicesModel();
            appServicesEditor.applyTo(appServicesModel);
            appServicesModel.setAppServicesDomain(appServicesDomain);
            appServicesEditor.resetFrom(appServicesModel);
        }
        catch (ConfigurationException e) {
            LOG.error((Throwable)e);
        }
    }

    private void buildUI() {
        boolean v2 = this.isV2();
        this.myManifestLabel.setVisible(v2);
        this.myApplicationLabel.setVisible(v2);
        this.myManifestTextField.setVisible(v2);
        this.myApplicationComboBox.setVisible(v2);
        boolean v1 = !v2;
        this.myServicesPanel.setVisible(v1);
        this.myTypeComboBox.setVisible(v1);
        this.myServicesTitledSeparator.setVisible(v1);
        this.myServicesButton.setVisible(v1);
        this.myTypeLabel.setVisible(v1);
        boolean appFog = this.myConfiguration.isAppFog();
        this.myInfraComboBox.setVisible(appFog);
        this.myInfraLabel.setVisible(appFog);
        boolean global = this.myConfiguration.getLocation() == CFCloudLocation.GLOBAL;
        this.myDomainTextField.setVisible(global);
        boolean defaultDomainAvailable = CFDeploymentConfiguration.isDefaultDomainAvailable(this.myConfiguration, this.getInfra());
        this.myCustomDomainCheckBox.setVisible(global && defaultDomainAvailable);
        this.myDomainLabel.setVisible(global && !defaultDomainAvailable);
        this.myDomainTextField.setEnabled(this.myCustomDomainCheckBox.isSelected() || !defaultDomainAvailable);
    }

    private boolean isV2() {
        return this.myConfiguration.isV2();
    }

    private String getInfra() {
        return this.myInfraText.getText();
    }

    private void reload() {
        final boolean v1 = !this.isV2();
        new CFConnectionTaskBase("Reload application settings"){
            CFAppSettingsRange myResultSettingsRange;
            CFServicesDomain myResultServicesDomain;
            CFAppServicesDomain myResultAppServicesDomain;

            protected Object run(CFServerRuntimeInstanceBase<?> serverRuntime) throws ServerRuntimeException {
                this.myResultSettingsRange = serverRuntime.getAppSettingsRange();
                if (v1) {
                    CFServerRuntimeInstanceV1 serverRuntimeV1 = (CFServerRuntimeInstanceV1)serverRuntime;
                    this.myResultServicesDomain = serverRuntimeV1.getServicesDomain();
                    this.myResultAppServicesDomain = serverRuntimeV1.getAppServicesDomain();
                }
                return null;
            }

            protected void postPerform(Object result) {
                CFDeploymentEditor.this.mySettingsRange = new CFAppSettingsRangeImpl(this.myResultSettingsRange);
                CFDeploymentEditor.this.resetSettingsRange();
                if (v1) {
                    CFDeploymentEditor.this.setAppServicesDomain(this.myResultServicesDomain, this.myResultAppServicesDomain);
                }
            }
        }.performAsync((Disposable)this);
    }

    private void editServicesDomain() {
        if (this.isV2()) {
            return;
        }
        final Ref servicesDomainRef = new Ref();
        final Ref appServicesDomainRef = new Ref();
        new CFConnectionTaskBase("Loading services configuration"){

            protected Object run(CFServerRuntimeInstanceBase<?> serverRuntime) throws ServerRuntimeException {
                CFServerRuntimeInstanceV1 serverRuntimeV1 = (CFServerRuntimeInstanceV1)serverRuntime;
                servicesDomainRef.set((Object)serverRuntimeV1.getServicesDomain());
                appServicesDomainRef.set((Object)serverRuntimeV1.getAppServicesDomain());
                return null;
            }
        }.performSync();
        if (appServicesDomainRef.isNull() || servicesDomainRef.isNull()) {
            return;
        }
        CFAppServicesModel initialConfig = new CFAppServicesModel();
        initialConfig.setAppServicesDomain((CFAppServicesDomain)appServicesDomainRef.get());
        initialConfig.setAppServices(new CFAppServicesImpl());
        final AppServicesEditor editor = new AppServicesEditor(false);
        editor.init(this.myProject, servicesDomainRef.get());
        CloudConfigDialog settingsDialog = new CloudConfigDialog(this.myProject, (SettingsEditor)editor, "Edit services"){

            protected void doOKAction() {
                final CFAppServicesModel config = new CFAppServicesModel();
                try {
                    editor.applyTo(config);
                }
                catch (ConfigurationException ex) {
                    this.setErrorText(ex.getMessage());
                    return;
                }
                super.doOKAction();
                final Ref success = new Ref((Object)false);
                new CFConnectionTaskBase("Applying services configuration"){

                    protected Object run(CFServerRuntimeInstanceBase<?> serverRuntime) throws ServerRuntimeException {
                        CFServerRuntimeInstanceV1 serverRuntimeV1 = (CFServerRuntimeInstanceV1)serverRuntime;
                        serverRuntimeV1.setAppServicesDomain(config.getAppServicesDomain());
                        success.set((Object)true);
                        return null;
                    }
                }.performSync();
                if (((Boolean)success.get()).booleanValue()) {
                    CFDeploymentEditor.this.setAppServicesDomain((CFServicesDomain)servicesDomainRef.get(), config.getAppServicesDomain());
                }
            }
        };
        editor.resetFrom(initialConfig);
        settingsDialog.show();
    }

    protected void resetEditorFrom(CFDeploymentConfiguration s) {
        this.myDebugCheckBox.setSelected(s.isDebug());
        this.myTypeComboBox.setSelectedItem((Object)s.getDeploymentType(this.myDeploymentSource, this.myProject));
        this.onTypeSelected();
        this.myInfraComboBox.setSelectedItem((Object)s.getInfra());
        this.myCustomDomainCheckBox.setSelected(!s.isDefaultDomain());
        this.myDomainTextField.setText(s.getDomain());
        this.mySettingsRange = s.getAppSettingsRange();
        this.resetSettingsRange();
        this.getAppSettingsEditor().resetFrom(s.getApplicationSettings());
        if (this.isV2()) {
            this.myManifestTextField.setText(s.getManifest().getPath());
            this.loadApplications();
            this.myApplicationComboBox.setSelectedItem(s.getManifest().getCurrentApplication());
        } else {
            this.myServicesDomain = s.getServicesDomain();
            this.resetServicesDomain();
            CFAppServicesDomainImpl appServicesDomain = s.getAppServicesDomain();
            if (appServicesDomain == null) {
                appServicesDomain = new CFAppServicesDomainImpl();
            }
            CFAppServicesModel appServicesModel = new CFAppServicesModel();
            appServicesModel.setAppServicesDomain(appServicesDomain);
            appServicesModel.setAppServices(s.getApplicationServices());
            this.getAppServicesEditor().resetFrom(appServicesModel);
        }
        this.buildUI();
    }

    protected void applyEditorTo(CFDeploymentConfiguration s) throws ConfigurationException {
        this.checkConfiguration();
        s.setDebug(this.myDebugCheckBox.isSelected());
        s.setType(this.getSelectedType());
        s.setInfra(this.getInfra());
        s.setDefaultDomain(!this.myCustomDomainCheckBox.isSelected());
        s.setDomain(this.myDomainTextField.getText());
        s.setAppSettingsRange(this.getSettingsRange());
        CFAppSettingsImpl appSettings = new CFAppSettingsImpl();
        this.getAppSettingsEditor().applyTo(appSettings);
        s.setAppSettings(appSettings);
        if (this.isV2()) {
            CFManifest manifest = this.createManifest();
            Object applicationSelectedItem = this.myApplicationComboBox.getSelectedItem();
            if (applicationSelectedItem != null) {
                manifest.setCurrentApplication(applicationSelectedItem.toString());
            }
            s.setManifest(manifest);
        } else {
            s.setServicesDomain(this.getServicesDomain());
            CFAppServicesModel appServicesModel = new CFAppServicesModel();
            this.getAppServicesEditor().applyTo(appServicesModel);
            s.setAppServicesDomain(new CFAppServicesDomainImpl(appServicesModel.getAppServicesDomain()));
            s.setApplicationServices(appServicesModel.getAppServices());
        }
    }

    private CFManifest createManifest() {
        return new CFManifest(this.myManifestTextField.getText());
    }

    private void checkConfiguration() throws RuntimeConfigurationError {
        boolean appFog = this.myConfiguration.isAppFog();
        if (appFog && StringUtil.isEmpty((String)this.getInfra())) {
            throw new RuntimeConfigurationError("Infra required");
        }
        boolean defaultDomainAvailable = CFDeploymentConfiguration.isDefaultDomainAvailable(this.myConfiguration, this.getInfra());
        if (this.myConfiguration.getLocation() == CFCloudLocation.GLOBAL && (!defaultDomainAvailable || this.myCustomDomainCheckBox.isSelected()) && StringUtil.isEmpty((String)this.myDomainTextField.getText())) {
            throw new RuntimeConfigurationError("Domain required");
        }
        this.createManifest().validate();
    }

    private void onTypeSelected() {
    }

    private CFDeploymentType getSelectedType() {
        return (CFDeploymentType)((Object)this.myTypeComboBox.getSelectedItem());
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/cloudfoundry/cloud/CFDeploymentEditor", "createEditor"));
        }
        return jPanel;
    }

    public AppSettingsEditor getAppSettingsEditor() {
        if (this.myAppSettingsEditor == null) {
            this.myAppSettingsEditor = new AppSettingsEditor();
        }
        return this.myAppSettingsEditor;
    }

    public AppServicesEditor getAppServicesEditor() {
        if (this.myAppServicesEditor == null) {
            this.myAppServicesEditor = new AppServicesEditor(true){

                protected boolean isAddRemoveAllowed() {
                    return false;
                }
            };
        }
        return this.myAppServicesEditor;
    }

    private void createUIComponents() {
        this.mySettingsPanel = (JPanel)this.getAppSettingsEditor().getComponent();
        this.myServicesPanel = (JPanel)this.getAppServicesEditor().getComponent();
    }

    protected void disposeEditor() {
        Disposer.dispose((Disposable)this.getAppSettingsEditor());
        Disposer.dispose((Disposable)this.getAppServicesEditor());
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JBLabel jBLabel3;
        TitledSeparator titledSeparator;
        JButton jButton;
        JBCheckBox jBCheckBox;
        JTextField jTextField;
        JCheckBox jCheckBox;
        ComboBox comboBox;
        JBLabel jBLabel4;
        JComboBox jComboBox;
        JBLabel jBLabel5;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(12, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myTypeLabel = jBLabel5 = new JBLabel();
        jBLabel5.setText("Type:");
        jPanel.add((Component)jBLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTypeComboBox = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myInfraLabel = jBLabel4 = new JBLabel();
        jBLabel4.setText("Infra:");
        jPanel.add((Component)jBLabel4, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myInfraComboBox = comboBox = new ComboBox();
        comboBox.setEditable(true);
        jPanel.add((Component)comboBox, new GridConstraints(1, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        this.myCustomDomainCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Use custom domain:");
        jPanel.add((Component)jCheckBox, new GridConstraints(4, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myDomainTextField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(5, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myDebugCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setHorizontalAlignment(10);
        jBCheckBox.setText("Debug");
        jBCheckBox.setVisible(false);
        jBCheckBox.setSelected(false);
        jPanel.add((Component)jBCheckBox, new GridConstraints(6, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(6, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myServicesButton = jButton = new JButton();
        jButton.setText("Edit services");
        jPanel2.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myServicesTitledSeparator = titledSeparator = new TitledSeparator();
        titledSeparator.setText("Services");
        jPanel.add((Component)titledSeparator, new GridConstraints(9, 0, 1, 2, 0, 1, 3, 0, null, null, null));
        JPanel jPanel3 = this.myServicesPanel;
        jPanel.add((Component)jPanel3, new GridConstraints(10, 0, 1, 2, 0, 3, 3, 3, null, new Dimension(-1, 100), null));
        JPanel jPanel4 = this.mySettingsPanel;
        jPanel.add((Component)jPanel4, new GridConstraints(8, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        TitledSeparator titledSeparator2 = new TitledSeparator();
        titledSeparator2.setText("Settings");
        jPanel.add((Component)titledSeparator2, new GridConstraints(7, 0, 1, 2, 0, 1, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(11, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myDomainLabel = jBLabel3 = new JBLabel();
        jBLabel3.setText("Domain:");
        jPanel.add((Component)jBLabel3, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myManifestLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("Manifest:");
        jPanel.add((Component)jBLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myApplicationLabel = jBLabel = new JBLabel();
        jBLabel.setText("Application:");
        jPanel.add((Component)jBLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myManifestTextField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        ComboBox comboBox2 = new ComboBox();
        this.myApplicationComboBox = comboBox2;
        jPanel.add((Component)comboBox2, new GridConstraints(3, 1, 1, 1, 0, 1, 2, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private abstract class CFConnectionTaskBase
    extends CFConnectionTask<Object, CFServerRuntimeInstanceBase<?>> {
        public CFConnectionTaskBase(String title) {
            super(CFDeploymentEditor.this.myProject, title, (RemoteServer<CFServerConfiguration>)CFDeploymentEditor.this.myServer);
        }
    }
}

