/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.osgi.bnd.run;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeBase;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.project.Project;
import icons.OsmorcIdeaIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.osgi.bnd.imp.BndProjectImporter;
import org.jetbrains.osgi.bnd.run.BndRunConfigurationBase;
import org.osmorc.i18n.OsmorcBundle;

public class BndRunConfigurationType
extends ConfigurationTypeBase {
    private static final String ID = "osgi.bnd.run";

    @NotNull
    public static BndRunConfigurationType getInstance() {
        BndRunConfigurationType bndRunConfigurationType = (BndRunConfigurationType)ConfigurationTypeUtil.findConfigurationType(BndRunConfigurationType.class);
        if (bndRunConfigurationType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/osgi/bnd/run/BndRunConfigurationType", "getInstance"));
        }
        return bndRunConfigurationType;
    }

    public BndRunConfigurationType() {
        super(ID, OsmorcBundle.message("bnd.configuration.name", new Object[0]), OsmorcBundle.message("bnd.configuration.description", new Object[0]), OsmorcIdeaIcons.Bnd);
        this.addFactory(new LaunchFactory((ConfigurationType)this));
        this.addFactory(new TestFactory((ConfigurationType)this));
    }

    private static class TestFactory
    extends FactoryBase {
        public TestFactory(@NotNull ConfigurationType type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/osgi/bnd/run/BndRunConfigurationType$TestFactory", "<init>"));
            }
            super(type, OsmorcBundle.message("bnd.test.configuration.name", new Object[0]), OsmorcIdeaIcons.BndTest);
        }

        public RunConfiguration createTemplateConfiguration(Project project) {
            return new BndRunConfigurationBase.Test(project, this, "");
        }
    }

    private static class LaunchFactory
    extends FactoryBase {
        public LaunchFactory(@NotNull ConfigurationType type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/osgi/bnd/run/BndRunConfigurationType$LaunchFactory", "<init>"));
            }
            super(type, OsmorcBundle.message("bnd.run.configuration.name", new Object[0]), OsmorcIdeaIcons.BndLaunch);
        }

        public RunConfiguration createTemplateConfiguration(Project project) {
            return new BndRunConfigurationBase.Launch(project, this, "");
        }
    }

    private static abstract class FactoryBase
    extends ConfigurationFactory {
        private final String myName;
        private final Icon myIcon;

        public FactoryBase(@NotNull ConfigurationType type, @NotNull String name, @NotNull Icon icon) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/osgi/bnd/run/BndRunConfigurationType$FactoryBase", "<init>"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/osgi/bnd/run/BndRunConfigurationType$FactoryBase", "<init>"));
            }
            if (icon == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "org/jetbrains/osgi/bnd/run/BndRunConfigurationType$FactoryBase", "<init>"));
            }
            super(type);
            this.myName = name;
            this.myIcon = icon;
        }

        public String getName() {
            return this.myName;
        }

        public Icon getIcon() {
            return this.myIcon;
        }

        public boolean isApplicable(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/osgi/bnd/run/BndRunConfigurationType$FactoryBase", "isApplicable"));
            }
            return BndProjectImporter.getWorkspace(project) != null;
        }
    }
}

