/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.jsp.unescapedEl;

import com.intellij.codeInsight.completion.ExtendedTagInsertHandler;
import com.intellij.codeInspection.JspInspectionGroupNames;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.codeInspection.jsp.AbstractWrapFix;
import com.intellij.codeInspection.jsp.WrapInTagFix;
import com.intellij.codeInspection.jsp.unescapedEl.JspUnescapedElOptionsPanel;
import com.intellij.codeInspection.jsp.unescapedEl.SafeTagInfo;
import com.intellij.jsp.impl.TypeAwareAttributeDescriptor;
import com.intellij.lang.Language;
import com.intellij.lang.jsp.NewJspLanguage;
import com.intellij.lang.jspx.JSPXLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.jsp.el.impl.ELResolveUtil;
import com.intellij.psi.jsp.BaseJspFile;
import com.intellij.psi.jsp.BaseJspUtil;
import com.intellij.psi.jsp.ELElementType;
import com.intellij.psi.jsp.el.ELBinaryExpression;
import com.intellij.psi.jsp.el.ELConditionalExpression;
import com.intellij.psi.jsp.el.ELElementVisitor;
import com.intellij.psi.jsp.el.ELExpression;
import com.intellij.psi.jsp.el.ELExpressionHolder;
import com.intellij.psi.jsp.el.ELFunctionCallExpression;
import com.intellij.psi.jsp.el.ELLiteralExpression;
import com.intellij.psi.jsp.el.ELTokenType;
import com.intellij.psi.jsp.el.ELUnaryExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JspUnescapedElInspection
extends XmlSuppressableInspectionTool
implements ELTokenType {
    private static final TokenSet SAFE_OPERATIONS = TokenSet.create((IElementType[])new IElementType[]{JSP_EL_AND, JSP_EL_OR, JSP_EL_NOT_KEYWORD, JSP_EL_NOT, JSP_EL_EQ, JSP_EL_NE, JSP_EL_LT, JSP_EL_GT, JSP_EL_LE, JSP_EL_GE, JSP_EL_TRUE, JSP_EL_FALSE, JSP_EL_NULL, JSP_EL_INSTANCEOF, JSP_EL_EMPTY, JSP_EL_DIV, JSP_EL_MOD, JSP_EL_LESS, JSP_EL_GREATER, JSP_EL_LESS_OR_EQUAL, JSP_EL_GREATER_OR_EQUAL, JSP_EL_MINUS, JSP_EL_PLUS, JSP_EL_DIVISION, JSP_EL_MODULO, JSP_EL_MULTIPLY, JSP_EL_NOT_EQUAL, JSP_EL_EQUAL, JSP_EL_AND_AND, JSP_EL_OR_OR, ELElementType.JSP_EL_LITERAL});
    public List<SafeTagInfo> safeTags = new ArrayList<SafeTagInfo>(Arrays.asList(new SafeTagInfo("http://java.sun.com/jsp/jstl/core", "out", "value", true)));
    public boolean suggestEscapeXml = true;
    private final NotNullLazyValue<JspUnescapedElOptionsPanel> myPanel = new NotNullLazyValue<JspUnescapedElOptionsPanel>(){

        @NotNull
        protected JspUnescapedElOptionsPanel compute() {
            JspUnescapedElOptionsPanel jspUnescapedElOptionsPanel = new JspUnescapedElOptionsPanel(JspUnescapedElInspection.this);
            if (jspUnescapedElOptionsPanel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/jsp/unescapedEl/JspUnescapedElInspection$5", "compute"));
            }
            return jspUnescapedElOptionsPanel;
        }
    };

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder problemsHolder, boolean isOnTheFly) {
        if (problemsHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemsHolder", "com/intellij/codeInspection/jsp/unescapedEl/JspUnescapedElInspection", "buildVisitor"));
        }
        ELElementVisitor eLElementVisitor = new ELElementVisitor(){

            @Override
            public void visitELExpressionHolder(@NotNull ELExpressionHolder expressionHolder) {
                XmlAttribute attr;
                if (expressionHolder == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionHolder", "com/intellij/codeInspection/jsp/unescapedEl/JspUnescapedElInspection$1", "visitELExpressionHolder"));
                }
                PsiElement[] children = expressionHolder.getChildren();
                if (children.length == 1) {
                    IElementType type;
                    PsiElement child = children[0];
                    if (SAFE_OPERATIONS.contains(child.getNode().getElementType())) {
                        return;
                    }
                    if (child instanceof ELBinaryExpression) {
                        type = ((ELBinaryExpression)child).getOperationSign();
                        if (SAFE_OPERATIONS.contains(type)) {
                            return;
                        }
                    } else if (child instanceof ELUnaryExpression) {
                        IElementType sign = ((ELUnaryExpression)child).getOperationSign();
                        if (SAFE_OPERATIONS.contains(sign)) {
                            return;
                        }
                    } else if (child instanceof ELConditionalExpression) {
                        ELExpression then = ((ELConditionalExpression)child).getThen();
                        ELExpression eLExpression = ((ELConditionalExpression)child).getElse();
                        if (then instanceof ELLiteralExpression && eLExpression instanceof ELLiteralExpression) {
                            return;
                        }
                    } else {
                        if (child instanceof ELLiteralExpression) {
                            return;
                        }
                        if (child instanceof ELExpression && TypeConversionUtil.isPrimitiveAndNotNullOrWrapper((PsiType)(type = ELResolveUtil.resolveContextAsType((ELExpression)child)))) {
                            return;
                        }
                    }
                }
                if ((attr = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)expressionHolder, XmlAttribute.class)) != null) {
                    String type;
                    String namespace = attr.getParent().getNamespace();
                    for (String uri : XmlUtil.JSTL_CORE_URIS) {
                        if (!uri.equals(namespace)) continue;
                        return;
                    }
                    XmlAttributeDescriptor xmlAttributeDescriptor = attr.getDescriptor();
                    if (xmlAttributeDescriptor instanceof TypeAwareAttributeDescriptor && TypeConversionUtil.isPrimitive((String)(type = ((TypeAwareAttributeDescriptor)xmlAttributeDescriptor).getType()))) {
                        return;
                    }
                    for (SafeTagInfo info : JspUnescapedElInspection.this.safeTags) {
                        if (!info.matchAttribute(attr)) continue;
                        return;
                    }
                    if (!JspUnescapedElInspection.isEscapedByJSTL(expressionHolder)) {
                        JspUnescapedElInspection.this.reportProblem(expressionHolder, problemsHolder, attr, JspUnescapedElInspection.this.suggestEscapeXml ? new EscapeByJSTL() : null);
                    }
                } else {
                    Language language;
                    PsiElement parent = expressionHolder.getParent();
                    if (parent != null && ((language = parent.getLanguage()) == NewJspLanguage.INSTANCE || language == JSPXLanguage.INSTANCE)) {
                        JspUnescapedElInspection.this.reportProblem(expressionHolder, problemsHolder, null, null);
                    }
                }
            }
        };
        if (eLElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/jsp/unescapedEl/JspUnescapedElInspection", "buildVisitor"));
        }
        return eLElementVisitor;
    }

    private static boolean isEscapedByJSTL(ELExpressionHolder expressionHolder) {
        ELFunctionCallExpression call;
        PsiElement[] children = expressionHolder.getChildren();
        return children.length == 1 && children[0] instanceof ELFunctionCallExpression && "escapeXml".equals((call = (ELFunctionCallExpression)children[0]).getFunctionName());
    }

    private void reportProblem(ELExpressionHolder expressionHolder, ProblemsHolder problemsHolder, @Nullable XmlAttribute attribute, @Nullable LocalQuickFix additional) {
        XmlTag tag;
        final BaseJspFile jspFile = BaseJspUtil.getJspFile((PsiElement)expressionHolder);
        ArrayList<RegisterAsSafeFix> fixes = new ArrayList<RegisterAsSafeFix>(ContainerUtil.mapNotNull(this.safeTags, (Function)new NullableFunction<SafeTagInfo, LocalQuickFix>(){

            @Nullable
            public LocalQuickFix fun(SafeTagInfo tagInfo) {
                if (jspFile == null || ExtendedTagInsertHandler.suggestPrefix((XmlFile)jspFile, (String)tagInfo.namespace) == null) {
                    return null;
                }
                return tagInfo.fix ? new WrapInTagFix(tagInfo) : null;
            }
        }));
        ContainerUtil.addIfNotNull(fixes, (Object)additional);
        if (attribute != null && (tag = attribute.getParent()) != null) {
            fixes.add(new RegisterAsSafeFix("Register <" + tag.getLocalName() + " " + attribute.getLocalName() + "=\"\"> as safe place"));
            fixes.add(new RegisterAsSafeFix("Register <" + tag.getLocalName() + "> tag as safe place"){

                @Override
                protected SafeTagInfo createInfo(XmlAttribute attribute) {
                    return new SafeTagInfo(attribute.getParent().getNamespace(), attribute.getParent().getLocalName(), null, false);
                }
            });
            fixes.add(new RegisterAsSafeFix("Register all tags from " + tag.getNamespace() + " as safe"){

                @Override
                protected SafeTagInfo createInfo(XmlAttribute attribute) {
                    return new SafeTagInfo(attribute.getParent().getNamespace(), null, null, false);
                }
            });
        }
        problemsHolder.registerProblem((PsiElement)expressionHolder, "Unescaped EL expression", fixes.toArray(new LocalQuickFix[fixes.size()]));
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return ((JspUnescapedElOptionsPanel)this.myPanel.getValue()).getOptionsPanel();
    }

    private class RegisterAsSafeFix
    implements LocalQuickFix {
        private final String myName;

        public RegisterAsSafeFix(String name) {
            this.myName = name;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/jsp/unescapedEl/JspUnescapedElInspection$RegisterAsSafeFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = JspInspectionGroupNames.JSP_INSPECTIONS;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/jsp/unescapedEl/JspUnescapedElInspection$RegisterAsSafeFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/jsp/unescapedEl/JspUnescapedElInspection$RegisterAsSafeFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/jsp/unescapedEl/JspUnescapedElInspection$RegisterAsSafeFix", "applyFix"));
            }
            final XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), XmlAttribute.class);
            InspectionProjectProfileManager.getInstance((Project)project).getInspectionProfile().modifyToolSettings(Key.create((String)JspUnescapedElInspection.this.getShortName()), descriptor.getPsiElement(), (Consumer)new Consumer<JspUnescapedElInspection>(){

                public void consume(JspUnescapedElInspection inspection) {
                    inspection.safeTags.add(RegisterAsSafeFix.this.createInfo(attribute));
                }
            });
        }

        protected SafeTagInfo createInfo(XmlAttribute attribute) {
            XmlTag tag = attribute.getParent();
            return new SafeTagInfo(tag.getNamespace(), tag.getLocalName(), attribute.getLocalName(), false);
        }
    }

    private static class EscapeByJSTL
    extends AbstractWrapFix {
        private EscapeByJSTL() {
        }

        @NotNull
        public String getName() {
            if ("Wrap in JSTL escapeXml() function" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/jsp/unescapedEl/JspUnescapedElInspection$EscapeByJSTL", "getName"));
            }
            return "Wrap in JSTL escapeXml() function";
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = JspInspectionGroupNames.JSP_INSPECTIONS;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/jsp/unescapedEl/JspUnescapedElInspection$EscapeByJSTL", "getFamilyName"));
            }
            return string;
        }

        @Override
        protected String getNamespace() {
            return "http://java.sun.com/jsp/jstl/functions";
        }

        @Override
        protected PsiElement getElementToReplace(PsiElement holder) {
            return holder.getChildren()[0];
        }

        @Override
        protected StringBuilder buildNewText(String prefix, String text) {
            return new StringBuilder().append(prefix).append(":escapeXml(").append(text).append(')');
        }
    }
}

