/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsp.impl;

import com.intellij.codeInsight.editorActions.JavaInJspQuoteHandler;
import com.intellij.codeInsight.editorActions.JavaQuoteHandler;
import com.intellij.ide.highlighter.JavaFileHighlighter;
import com.intellij.ide.highlighter.JavaInJspHighlighter;
import com.intellij.javaee.ExternalResourceManager;
import com.intellij.jsp.impl.TldDescriptor;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.jsp.IBaseJspManager;
import com.intellij.lang.jsp.JavaInJspProvider;
import com.intellij.lang.jsp.JspFileViewProviderImpl;
import com.intellij.lang.jsp.JspxFileViewProvider;
import com.intellij.lexer.JavaHighlightingLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.module.EffectiveLanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.IdentityCharTable;
import com.intellij.psi.impl.source.jsp.JspFileImpl;
import com.intellij.psi.impl.source.jsp.JspJavaFileImpl;
import com.intellij.psi.impl.source.jsp.JspManager;
import com.intellij.psi.impl.source.jsp.JspManagerImpl;
import com.intellij.psi.impl.source.jsp.el.impl.JspElVariablesProvider;
import com.intellij.psi.impl.source.jsp.jspXml.JspCommentImpl;
import com.intellij.psi.impl.source.jsp.jspXml.JspDirective;
import com.intellij.psi.impl.source.jsp.jspXml.JspXmlRootTagImpl;
import com.intellij.psi.impl.source.parsing.jsp.JspLexer2;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.jsp.BaseJspElementType;
import com.intellij.psi.jsp.JspDirectiveKind;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.jsp.JspUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.java.IJavaDocElementType;
import com.intellij.psi.tree.java.IJavaElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.CharTable;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.xml.XmlNSDescriptor;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaInJspHandler
implements JavaInJspProvider {
    @NonNls
    private static final String PAGE = "page";

    @Override
    @NotNull
    public JavaInJspHighlighter createJavaHighlighter(@Nullable Project project, @Nullable VirtualFile virtualFile) {
        LanguageLevel languageLevel;
        if (project != null && virtualFile != null) {
            Module module;
            Module module2 = module = project.isDefault() ? null : ProjectRootManager.getInstance((Project)project).getFileIndex().getModuleForFile(virtualFile);
            languageLevel = module != null ? EffectiveLanguageLevelUtil.getEffectiveLanguageLevel((Module)module) : LanguageLevel.HIGHEST;
        } else {
            languageLevel = LanguageLevel.HIGHEST;
        }
        CustomizedJavaFileHighlighter customizedJavaFileHighlighter = new CustomizedJavaFileHighlighter(languageLevel);
        if (customizedJavaFileHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsp/impl/JavaInJspHandler", "createJavaHighlighter"));
        }
        return customizedJavaFileHighlighter;
    }

    @Override
    @NotNull
    public Lexer createJavaLexer() {
        JavaHighlightingLexer javaHighlightingLexer = new JavaHighlightingLexer(LanguageLevel.HIGHEST);
        if (javaHighlightingLexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsp/impl/JavaInJspHandler", "createJavaLexer"));
        }
        return javaHighlightingLexer;
    }

    @Override
    public String detectCharsetAsPerJspSpec(@NotNull VirtualFile file, @NotNull byte[] content, @NotNull Language language) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/jsp/impl/JavaInJspHandler", "detectCharsetAsPerJspSpec"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/jsp/impl/JavaInJspHandler", "detectCharsetAsPerJspSpec"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/jsp/impl/JavaInJspHandler", "detectCharsetAsPerJspSpec"));
        }
        return JspUtil.detectCharsetAsPerJspSpec(file, content, language);
    }

    @Override
    public Charset detectCharsetAsPerJspSpec(Project project, @Nullable VirtualFile file, @NotNull CharSequence content, @NotNull Language language) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/jsp/impl/JavaInJspHandler", "detectCharsetAsPerJspSpec"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/jsp/impl/JavaInJspHandler", "detectCharsetAsPerJspSpec"));
        }
        return JspUtil.detectCharsetAsPerJspSpec(project, file, content, language);
    }

    @Override
    public boolean isJavaStructuralBrace(IElementType tokenType) {
        return tokenType == JavaTokenType.LBRACE || tokenType == JavaTokenType.RBRACE;
    }

    @Override
    @NotNull
    public JavaInJspQuoteHandler createJavaInJspQuoteHandler() {
        CustomizedJavaQuoteHandler customizedJavaQuoteHandler = new CustomizedJavaQuoteHandler();
        if (customizedJavaQuoteHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsp/impl/JavaInJspHandler", "createJavaInJspQuoteHandler"));
        }
        return customizedJavaQuoteHandler;
    }

    @Override
    @NotNull
    public Language getJavaLanguage() {
        JavaLanguage javaLanguage = JavaLanguage.INSTANCE;
        if (javaLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsp/impl/JavaInJspHandler", "getJavaLanguage"));
        }
        return javaLanguage;
    }

    @Override
    public JspFileViewProviderImpl.PrefixesWithLanguage getLocalPrefixes(JspFileViewProviderImpl viewProvider, CharSequence contents) {
        IElementType type;
        JspFileViewProviderImpl.PrefixesWithLanguage prefixesWithLanguage = new JspFileViewProviderImpl.PrefixesWithLanguage();
        ArrayList<String> prefixes = new ArrayList<String>();
        String contentType = null;
        PsiManager psiManager = PsiManager.getInstance((Project)viewProvider.getManager().getProject());
        JspLexer2 lexer = new JspLexer2(Collections.emptySet(), false, false);
        lexer.start(contents);
        while ((type = lexer.getTokenType()) != null) {
            String token;
            if (type == BaseJspElementType.JSP_DIRECTIVE) {
                String attributeValue;
                DummyHolder dummyHolder = new DummyHolder(psiManager, null, BaseJspElementType.JSP_DIRECTIVE.getLanguage());
                JspDirective directive = (JspDirective)BaseJspElementType.JSP_DIRECTIVE.parse(lexer.getTokenSequence(), (CharTable)IdentityCharTable.INSTANCE);
                dummyHolder.getTreeElement().rawAddChildren((TreeElement)directive);
                if (PAGE.equals(directive.getName()) && (attributeValue = directive.getAttributeValue("contentType")) != null) {
                    contentType = attributeValue;
                }
            } else if (type == XmlTokenType.XML_NAME && (token = lexer.getTokenText()).startsWith("xmlns:")) {
                prefixes.add(token.substring(6));
            }
            lexer.advance();
        }
        if (!StringUtil.isEmpty(contentType)) {
            prefixesWithLanguage.setTemplateLanguage(JspUtil.getLanguageByContentType(contentType));
        }
        prefixesWithLanguage.addKnownPrefixes(prefixes);
        return prefixesWithLanguage;
    }

    @Override
    @NotNull
    public PsiFile createJavaFile(@NotNull JspxFileViewProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/jsp/impl/JavaInJspHandler", "createJavaFile"));
        }
        JspJavaFileImpl jspJavaFileImpl = new JspJavaFileImpl((FileViewProvider)provider);
        if (jspJavaFileImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsp/impl/JavaInJspHandler", "createJavaFile"));
        }
        return jspJavaFileImpl;
    }

    @Override
    @NotNull
    public PsiFile createJspFile(JspxFileViewProvider viewProvider) {
        JspFileImpl jspFileImpl = new JspFileImpl(viewProvider);
        if (jspFileImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsp/impl/JavaInJspHandler", "createJspFile"));
        }
        return jspFileImpl;
    }

    @Override
    public void fillInNamespaces(final JspXmlRootTagImpl tag, BidirectionalMap<String, String> namespacePrefixMap, Map<String, CachedValue<XmlNSDescriptor>> namespaceMap) {
        XmlTag[] directiveTags;
        PsiFile psiFile = tag.getContainingFile().getOriginalFile();
        JspFile jspxFile = JspPsiUtil.getJspFile((PsiElement)psiFile);
        for (XmlTag directiveTag : directiveTags = jspxFile.getDirectiveTagsInContext(JspDirectiveKind.TAGLIB)) {
            String tldUri;
            String uri = directiveTag.getAttributeValue("uri");
            if (uri == null && (uri = directiveTag.getAttributeValue("tagdir")) != null) {
                uri = "urn:jsptagdir:" + uri;
            }
            String prefix = directiveTag.getAttributeValue("prefix");
            if (uri == null || prefix == null) continue;
            final String originalUri = uri;
            XmlNSDescriptor tagLibDescriptor = JavaInJspHandler.getDescriptorByUri(tag, originalUri);
            if (tagLibDescriptor instanceof TldDescriptor && (tldUri = ((TldDescriptor)tagLibDescriptor).getUri()) != null && tldUri.length() > 0 && !namespaceMap.containsKey(tldUri)) {
                uri = tldUri;
            }
            namespacePrefixMap.put((Object)prefix, (Object)uri);
            namespaceMap.put(uri, (CachedValue<XmlNSDescriptor>)CachedValuesManager.getManager((Project)tag.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<XmlNSDescriptor>(){

                public CachedValueProvider.Result<XmlNSDescriptor> compute() {
                    Object[] objectArray;
                    XmlNSDescriptor nsDescriptor = JavaInJspHandler.getDescriptorByUri(tag, originalUri);
                    Object object = nsDescriptor != null ? nsDescriptor : JspXmlRootTagImpl.EMPTY_DESCRIPTOR;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = ExternalResourceManager.getInstance();
                    if (nsDescriptor != null) {
                        objectArray = nsDescriptor.getDependences();
                    } else {
                        Object[] objectArray3 = new Object[1];
                        objectArray = objectArray3;
                        objectArray3[0] = PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT;
                    }
                    objectArray2[1] = objectArray;
                    return new CachedValueProvider.Result(object, objectArray2);
                }
            }, false));
        }
    }

    @Override
    public PsiReference[] getReferencesFromJspComment(JspCommentImpl jspComment) {
        return JspElVariablesProvider.getReferencesFromComment(jspComment);
    }

    @Override
    public IBaseJspManager getJspManagerInstance(Project project) {
        return JspManager.getInstance((Project)project);
    }

    @Nullable
    private static XmlNSDescriptor getDescriptorByUri(JspXmlRootTagImpl tag, String originalUri) {
        XmlFile tldFileByUri = JspManagerImpl.getInstance(tag.getProject()).getTldFileByUri(originalUri, JspPsiUtil.getJspFile((PsiElement)tag.getContainingFile()));
        if (tldFileByUri != null) {
            XmlDocument document = tldFileByUri.getDocument();
            if (document == null) {
                return null;
            }
            return (XmlNSDescriptor)document.getMetaData();
        }
        return null;
    }

    private static class CustomizedJavaQuoteHandler
    extends JavaQuoteHandler
    implements JavaInJspQuoteHandler {
        private CustomizedJavaQuoteHandler() {
        }

        @Override
        public boolean isMine(@NotNull IElementType tokenType) {
            if (tokenType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tokenType", "com/intellij/jsp/impl/JavaInJspHandler$CustomizedJavaQuoteHandler", "isMine"));
            }
            return tokenType instanceof IJavaElementType;
        }
    }

    private static class CustomizedJavaFileHighlighter
    extends JavaFileHighlighter
    implements JavaInJspHighlighter {
        public CustomizedJavaFileHighlighter(LanguageLevel languageLevel) {
            super(languageLevel);
        }

        @Override
        public boolean isMine(IElementType tokenType) {
            return tokenType instanceof IJavaElementType || tokenType instanceof IJavaDocElementType;
        }
    }
}

