/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.jsp;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.jsp.JspManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class TagdirReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/jsp/TagdirReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/source/jsp/TagdirReferenceProvider", "getReferencesByElement"));
        }
        FileReference[] fileReferenceArray = new FileReferenceSet(element){

            public FileReference createFileReference(TextRange range, int index, String text) {
                return new FileReference(this, range, index, text){

                    @NotNull
                    protected ResolveResult[] innerResolve(boolean caseSensitive, @NotNull PsiFile containingFile) {
                        if (containingFile == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/source/jsp/TagdirReferenceProvider$1$1", "innerResolve"));
                        }
                        ResolveResult[] results = super.innerResolve(caseSensitive, containingFile);
                        String pathString = this.getFileReferenceSet().getPathString();
                        if (!pathString.startsWith("/WEB-INF/tags")) {
                            if (results == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/TagdirReferenceProvider$1$1", "innerResolve"));
                            }
                            return results;
                        }
                        if (!"WEB-INF".equals(this.getCanonicalText())) {
                            if (results == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/TagdirReferenceProvider$1$1", "innerResolve"));
                            }
                            return results;
                        }
                        PsiPackage psiPackage = JavaPsiFacade.getInstance((Project)this.getElement().getProject()).findPackage("/WEB-INF/tags".substring(1).replace('/', '.'));
                        if (psiPackage == null) {
                            if (results == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/TagdirReferenceProvider$1$1", "innerResolve"));
                            }
                            return results;
                        }
                        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement());
                        if (module == null) {
                            if (results == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/TagdirReferenceProvider$1$1", "innerResolve"));
                            }
                            return results;
                        }
                        PsiPackage webInf = psiPackage.getParentPackage();
                        assert (webInf != null);
                        ArrayList<ResolveResult> list = new ArrayList<ResolveResult>();
                        list.addAll(Arrays.asList(results));
                        Object[] directories = webInf.getDirectories(module.getModuleWithDependenciesAndLibrariesScope(false));
                        list.addAll(ContainerUtil.map((Object[])directories, (Function)new Function<PsiDirectory, ResolveResult>(){

                            public ResolveResult fun(PsiDirectory directory) {
                                return new PsiElementResolveResult((PsiElement)directory);
                            }
                        }));
                        ResolveResult[] resolveResultArray = list.toArray(new ResolveResult[list.size()]);
                        if (resolveResultArray == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/TagdirReferenceProvider$1$1", "innerResolve"));
                        }
                        return resolveResultArray;
                    }

                    @NotNull
                    public Object[] getVariants() {
                        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement());
                        if (module == null) {
                            if (EMPTY_ARRAY == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/TagdirReferenceProvider$1$1", "getVariants"));
                            }
                            return EMPTY_ARRAY;
                        }
                        String[] uris = JspManager.getInstance((Project)this.getElement().getProject()).getPossibleTldUris(module);
                        ArrayList<String> list = new ArrayList<String>();
                        int start = ElementManipulators.getOffsetInElement((PsiElement)this.getElement());
                        int end = this.getRangeInElement().getStartOffset();
                        int shift = end - start;
                        for (String uri : uris) {
                            String tagdir;
                            if (!StringUtil.startsWithConcatenation((String)uri, (String[])new String[]{"urn:jsptagdir:", "/WEB-INF/tags"}) || (tagdir = uri.substring("urn:jsptagdir:".length())).length() <= shift) continue;
                            list.add(tagdir.substring(shift));
                        }
                        Object[] objectArray = ArrayUtil.toObjectArray(list);
                        if (objectArray == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/TagdirReferenceProvider$1$1", "getVariants"));
                        }
                        return objectArray;
                    }
                };
            }
        }.getAllReferences();
        if (fileReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/TagdirReferenceProvider", "getReferencesByElement"));
        }
        return fileReferenceArray;
    }
}

