/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.jsp;

import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.source.jsp.TagdirSupport;
import com.intellij.psi.impl.source.jsp.TldProvider;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.jsp.WebDirectoryElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebTldProvider
implements TldProvider {
    @Override
    public XmlFile getTldFileByUri(String uri, @NotNull Module module, @Nullable JspFile context) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/psi/impl/source/jsp/WebTldProvider", "getTldFileByUri"));
        }
        if (module.isDisposed()) {
            return null;
        }
        PsiManager manager = PsiManager.getInstance((Project)module.getProject());
        if (uri.startsWith("urn:jsptagdir:")) {
            String tagdir = uri.substring("urn:jsptagdir:".length());
            if (tagdir.startsWith("/WEB-INF/tags") && context != null) {
                PsiPackage psiPackage;
                PsiElement element;
                ArrayList<Object> dirs = null;
                WebDirectoryElement parentWebDirectory = WebUtil.getWebUtil().getParentWebDirectory((PsiFile)context);
                if (parentWebDirectory != null && (element = parentWebDirectory.resolveRelative(tagdir)) instanceof WebDirectoryElement) {
                    dirs = new ArrayList<VirtualFile>();
                    dirs.addAll(((WebDirectoryElement)element).getOriginalVirtualFiles());
                }
                if ((psiPackage = JavaPsiFacade.getInstance((Project)module.getProject()).findPackage("/WEB-INF/tags".substring(1).replace('/', '.'))) != null) {
                    PsiDirectory[] psiDirectories;
                    for (PsiDirectory psiDirectory : psiDirectories = psiPackage.getDirectories(module.getModuleWithDependenciesAndLibrariesScope(false))) {
                        VirtualFile file = VfsUtilCore.findRelativeFile((String)tagdir.substring("/WEB-INF/tags".length()), (VirtualFile)psiDirectory.getVirtualFile());
                        if (file == null) continue;
                        if (dirs == null) {
                            dirs = new ArrayList();
                        }
                        dirs.add(file);
                    }
                }
                return dirs == null ? null : TagdirSupport.getImplicitTagLibForTagDir(tagdir, manager, dirs);
            }
        } else {
            for (WebFacet facet : WebFacet.getInstances((Module)module)) {
                XmlFile xmlFile;
                Map map = facet.getTaglibUriToResourceMap();
                String location = (String)map.get(uri);
                if (location == null || (xmlFile = WebTldProvider.resolveResource(location, facet)) == null) continue;
                return xmlFile;
            }
        }
        return null;
    }

    @Override
    public void collectUris(@NotNull Module module, FactoryMap<String, XmlFile> map, JspFile context) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/psi/impl/source/jsp/WebTldProvider", "collectUris"));
        }
        PsiManager psiManager = PsiManager.getInstance((Project)module.getProject());
        for (WebFacet facet : WebFacet.getInstances((Module)module)) {
            WebTldProvider.processLocalTlds(facet, psiManager, map);
        }
        PsiPackage psiPackage = JavaPsiFacade.getInstance((Project)module.getProject()).findPackage("/WEB-INF/tags".substring(1).replace('/', '.'));
        if (psiPackage != null) {
            WebTldProvider.processTagDirs(new PackageDirectoryContainer(psiPackage), psiManager, map);
        }
    }

    private static boolean processLocalTlds(WebFacet webFacet, PsiManager manager, FactoryMap<String, XmlFile> map) {
        WebDirectoryElement element = WebUtil.getWebUtil().findWebDirectoryElement("/WEB-INF/tags", webFacet);
        if (element != null) {
            WebTldProvider.processTagDirs(new WebDirectoryContainer(element), manager, map);
        }
        Map resourceMap = webFacet.getTaglibUriToResourceMap();
        for (Map.Entry entry : resourceMap.entrySet()) {
            XmlFile xmlFile = WebTldProvider.resolveResource((String)entry.getValue(), webFacet);
            if (xmlFile == null) continue;
            map.put(entry.getKey(), (Object)xmlFile);
        }
        return true;
    }

    @Nullable
    static XmlFile resolveResource(String uri, WebFacet webFacet) {
        Collection path;
        WebDirectoryElement element;
        if (!StringUtil.startsWithChar((CharSequence)uri, (char)'/')) {
            uri = "/WEB-INF/" + uri;
        }
        if ((element = WebUtil.getWebUtil().findWebDirectoryElement(uri, webFacet)) == null && !(path = WebUtil.getWebUtil().getContextsByPath(uri, webFacet.getModule())).isEmpty()) {
            element = (WebDirectoryElement)path.iterator().next();
        }
        if (element == null) {
            return null;
        }
        PsiFile file = element.getOriginalFile();
        if (file instanceof XmlFile) {
            return (XmlFile)file;
        }
        return null;
    }

    private static void processTagDirs(DirectoryContainer element, PsiManager manager, FactoryMap<String, XmlFile> map) {
        String uri = element.getPath();
        XmlFile xmlFile = TagdirSupport.getImplicitTagLibForTagDir(uri, manager, element.getDirectories());
        map.put((Object)("urn:jsptagdir:" + uri), (Object)xmlFile);
        for (DirectoryContainer child : element.getChildren()) {
            WebTldProvider.processTagDirs(child, manager, map);
        }
    }

    private static interface DirectoryContainer {
        public List<VirtualFile> getDirectories();

        public List<DirectoryContainer> getChildren();

        public String getPath();
    }

    private static class WebDirectoryContainer
    implements DirectoryContainer {
        private final WebDirectoryElement myElement;

        private WebDirectoryContainer(WebDirectoryElement element) {
            this.myElement = element;
        }

        @Override
        public List<VirtualFile> getDirectories() {
            return this.myElement.getOriginalVirtualFiles();
        }

        @Override
        public List<DirectoryContainer> getChildren() {
            Object[] children = this.myElement.getChildren();
            return ContainerUtil.mapNotNull((Object[])children, (Function)new NullableFunction<WebDirectoryElement, DirectoryContainer>(){

                public DirectoryContainer fun(WebDirectoryElement element) {
                    return element.isDirectory() ? new WebDirectoryContainer(element) : null;
                }
            });
        }

        @Override
        public String getPath() {
            return this.myElement.getPath();
        }
    }

    private static class PackageDirectoryContainer
    implements DirectoryContainer {
        private final PsiPackage myPackage;

        private PackageDirectoryContainer(PsiPackage psiPackage) {
            this.myPackage = psiPackage;
        }

        @Override
        public List<VirtualFile> getDirectories() {
            Object[] directories = this.myPackage.getDirectories();
            return ContainerUtil.map((Object[])directories, (Function)new Function<PsiDirectory, VirtualFile>(){

                public VirtualFile fun(PsiDirectory directory) {
                    return directory.getVirtualFile();
                }
            });
        }

        @Override
        public List<DirectoryContainer> getChildren() {
            Object[] subPackages = this.myPackage.getSubPackages();
            return ContainerUtil.map((Object[])subPackages, (Function)new Function<PsiPackage, DirectoryContainer>(){

                public DirectoryContainer fun(PsiPackage psiPackage) {
                    return new PackageDirectoryContainer(psiPackage);
                }
            });
        }

        @Override
        public String getPath() {
            return '/' + this.myPackage.getQualifiedName().replace('.', '/');
        }
    }
}

