/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.lang.jsp.inlineInclude;

import com.intellij.lang.Language;
import com.intellij.lang.refactoring.InlineActionHandler;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceUtil;
import com.intellij.psi.jsp.BaseJspFile;
import com.intellij.psi.jsp.BaseJspUtil;
import com.intellij.psi.jsp.JspDirectiveKind;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.FileReferenceContextUtil;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringMessageDialog;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InlineIncludeFileHandler
extends InlineActionHandler {
    private static final String REFACTORING_NAME = RefactoringBundle.message((String)"inline.included.file.title");
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.jsp.inlineInclude.InlineIncludeFileHandler");
    public static final String HELP_ID = "refactoring.inlineInclude";

    public boolean isEnabledForLanguage(Language l) {
        return l.equals(StdFileTypes.JSPX.getLanguage()) || l.equals(StdFileTypes.JSP.getLanguage());
    }

    public boolean isEnabledOnElement(PsiElement element, @Nullable Editor editor) {
        if (editor == null) {
            return false;
        }
        if (element instanceof XmlToken) {
            if (InlineIncludeFileHandler.getDirective(editor) == null) {
                return false;
            }
            XmlAttributeValue value = (XmlAttributeValue)PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttributeValue.class);
            if (value != null && value.getParent() instanceof XmlAttribute && ((XmlAttribute)value.getParent()).getName().equals("file")) {
                return FileReferenceUtil.findFile((PsiElement)value) != null;
            }
            return false;
        }
        if (!(element instanceof PsiFile)) {
            return false;
        }
        return InlineIncludeFileHandler.getDirective(editor) != null;
    }

    @Nullable
    private static XmlTag getDirective(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/refactoring/lang/jsp/inlineInclude/InlineIncludeFileHandler", "getDirective"));
        }
        PsiElement elementAtCaret = PsiUtilBase.getElementAtCaret((Editor)editor);
        XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)elementAtCaret, XmlTag.class);
        return xmlTag != null && BaseJspUtil.getDirectiveKindByTag(xmlTag) == JspDirectiveKind.INCLUDE ? xmlTag : null;
    }

    public boolean canInlineElement(PsiElement element) {
        return false;
    }

    public boolean canInlineElementInEditor(PsiElement element, Editor editor) {
        return element instanceof PsiFile;
    }

    public void inlineElement(Project project, Editor editor, PsiElement element) {
        XmlTag include = InlineIncludeFileHandler.getDirective(editor);
        BaseJspFile jspFile = (BaseJspFile)PsiUtilCore.getTemplateLanguageFile((PsiElement)include);
        if (jspFile == null || !(element instanceof PsiFile)) {
            String message = RefactoringBundle.message((String)"the.caret.should.be.positioned.on.the.included.file.to.inline");
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)HELP_ID);
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)jspFile.getProject(), (PsiElement)jspFile)) {
            return;
        }
        InlineIncludeFileHandler.doInlineIncluded((PsiFile)element, jspFile, include);
    }

    private static void doInlineIncluded(final PsiFile included, final BaseJspFile including, final XmlTag includeTag) {
        RefactoringMessageDialog dialog;
        final Project project = included.getProject();
        final Application application = ApplicationManager.getApplication();
        if (!application.isUnitTestMode() && !(dialog = new RefactoringMessageDialog(REFACTORING_NAME, RefactoringBundle.message((String)"inline.the.contents.include.prompt", (Object[])new Object[]{included.getVirtualFile().getPresentableUrl()}), HELP_ID, "OptionPane.questionIcon", true, project)).showAndGet()) {
            return;
        }
        final Map map = FileReferenceContextUtil.encodeFileReferences((PsiElement)included);
        CommandProcessor.getInstance().executeCommand(project, new Runnable(){

            @Override
            public void run() {
                application.runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            PsiElement parent = includeTag.getParent();
                            if (included instanceof BaseJspFile) {
                                InlineIncludeFileHandler.inlineJsp((BaseJspFile)included, includeTag);
                                FileReferenceContextUtil.decodeFileReferences((PsiElement)parent);
                                includeTag.delete();
                            } else {
                                TextRange range = includeTag.getTextRange();
                                PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
                                Document document = documentManager.getDocument((PsiFile)including);
                                int start = range.getStartOffset();
                                document.replaceString(start, range.getEndOffset(), (CharSequence)included.getText());
                                documentManager.commitDocument(document);
                                List files = including.getViewProvider().getAllFiles();
                                for (PsiFile file : files) {
                                    FileReferenceContextUtil.decodeFileReferences((PsiElement)file, (Map)map, (TextRange)TextRange.from((int)start, (int)(start + included.getTextLength())));
                                }
                            }
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                });
            }
        }, REFACTORING_NAME, null);
        if (!application.isUnitTestMode() && ReferencesSearch.search((PsiElement)included, (SearchScope)GlobalSearchScope.allScope((Project)project), (boolean)false).findFirst() == null) {
            InlineIncludeFileHandler.deleteIncludedJsp(project, included, including);
        }
    }

    private static void inlineJsp(BaseJspFile included, XmlTag includeTag) throws IncorrectOperationException {
        String[] namespaces;
        PsiElement[] contentsElements = BaseJspUtil.getJspFile(included.copy()).getContentsElements();
        XmlDocument document = included.getDocument();
        assert (document != null);
        XmlTag rootTag = document.getRootTag();
        assert (rootTag != null);
        for (String namespace : namespaces = rootTag.knownNamespaces()) {
            String prefixInIncluding;
            String prefixInIncluded = rootTag.getPrefixByNamespace(namespace);
            String namespaceInIncluding = includeTag.getNamespaceByPrefix(prefixInIncluded);
            if (namespace.equals(namespaceInIncluding)) continue;
            if (namespaceInIncluding == "") {
                prefixInIncluding = prefixInIncluded;
            } else {
                int index = 0;
                while (includeTag.getParentTag().getNamespaceByPrefix(prefixInIncluded + index) != "") {
                    ++index;
                }
                prefixInIncluding = prefixInIncluded + index;
                InlineIncludeFileHandler.correctTagNames(contentsElements, prefixInIncluded, prefixInIncluding);
            }
            includeTag.getParentTag().setAttribute("xmlns:" + prefixInIncluding, namespace);
        }
        if (contentsElements.length > 0) {
            int lastIndex;
            XmlTag anchor = includeTag;
            XmlTag parentTag = includeTag.getParentTag();
            while (anchor.getParent() != parentTag) {
                anchor = anchor.getParent();
            }
            for (lastIndex = contentsElements.length - 1; lastIndex > 0 && contentsElements[lastIndex] instanceof XmlText && StringUtil.isEmptyOrSpaces((String)((XmlText)contentsElements[lastIndex]).getValue()); --lastIndex) {
            }
            parentTag.addRangeBefore(contentsElements[0], contentsElements[lastIndex], (PsiElement)anchor);
        }
    }

    private static void correctTagNames(PsiElement[] contentsElements, final String oldPrefix, final String newPrefix) {
        for (PsiElement element : contentsElements) {
            element.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

                public void visitXmlTag(XmlTag tag) {
                    if (oldPrefix.equals(tag.getPrefixByNamespace(tag.getNamespace()))) {
                        try {
                            tag.setName(newPrefix + "." + tag.getLocalName());
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                    super.visitXmlTag(tag);
                }
            });
        }
    }

    private static void deleteIncludedJsp(final Project project, final PsiFile included, BaseJspFile including) {
        RefactoringMessageDialog dialog = new RefactoringMessageDialog(REFACTORING_NAME, RefactoringBundle.message((String)"remove.include.prompt"), HELP_ID, "OptionPane.questionIcon", true, project);
        if (dialog.showAndGet()) {
            Document includingDocument = PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)including);
            CommandProcessor.getInstance().executeCommand(project, new Runnable(){

                @Override
                public void run() {
                    SafeDeleteProcessor.createInstance((Project)project, null, (PsiElement[])new PsiElement[]{included}, (boolean)true, (boolean)true).run();
                }
            }, RefactoringBundle.message((String)"delete.include.command", (Object[])new Object[]{included.getVirtualFile().getPresentableUrl()}), null, includingDocument);
        }
    }
}

