/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.lang.jsp.introduceParameter;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.jsp.JspDirectiveKind;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.usageView.BaseUsageViewDescriptor;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JspIntroduceParameterProcessor
extends BaseRefactoringProcessor {
    protected final JspFile myTagFile;
    private final String myParameterName;
    private final String myParameterValue;
    protected Editor myEditor;

    public JspIntroduceParameterProcessor(JspFile tagFile, Editor editor, String parameterName, String parameterValue) {
        super(tagFile.getProject());
        this.myTagFile = tagFile;
        this.myEditor = editor;
        this.myParameterName = parameterName;
        this.myParameterValue = parameterValue;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/lang/jsp/introduceParameter/JspIntroduceParameterProcessor", "createUsageViewDescriptor"));
        }
        BaseUsageViewDescriptor baseUsageViewDescriptor = new BaseUsageViewDescriptor(new PsiElement[]{this.myTagFile});
        if (baseUsageViewDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/lang/jsp/introduceParameter/JspIntroduceParameterProcessor", "createUsageViewDescriptor"));
        }
        return baseUsageViewDescriptor;
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        final List infos = Collections.synchronizedList(new ArrayList());
        ReferencesSearch.search((PsiElement)this.myTagFile).forEach((Processor)new Processor<PsiReference>(){

            public boolean process(PsiReference psiReference) {
                if (psiReference.isReferenceTo((PsiElement)JspIntroduceParameterProcessor.this.myTagFile)) {
                    infos.add(new UsageInfo(psiReference));
                }
                return true;
            }
        });
        UsageInfo[] usageInfoArray = infos.toArray(new UsageInfo[infos.size()]);
        if (usageInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/lang/jsp/introduceParameter/JspIntroduceParameterProcessor", "findUsages"));
        }
        return usageInfoArray;
    }

    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/lang/jsp/introduceParameter/JspIntroduceParameterProcessor", "performRefactoring"));
        }
        for (UsageInfo usage : usages) {
            PsiElement element = usage.getElement();
            if (!(element instanceof XmlTag)) continue;
            ((XmlTag)element).setAttribute(this.myParameterName, this.myParameterValue);
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                int attrOffset;
                Document document = JspIntroduceParameterProcessor.this.myEditor.getDocument();
                SelectionModel selectionModel = JspIntroduceParameterProcessor.this.myEditor.getSelectionModel();
                if (selectionModel.hasSelection()) {
                    attrOffset = selectionModel.getSelectionStart();
                    document.deleteString(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd());
                } else {
                    attrOffset = JspIntroduceParameterProcessor.this.myEditor.getCaretModel().getOffset();
                }
                document.insertString(attrOffset, (CharSequence)JspIntroduceParameterProcessor.this.getSubstitution(JspIntroduceParameterProcessor.this.myParameterName));
                PsiDocumentManager.getInstance((Project)JspIntroduceParameterProcessor.this.myProject).commitDocument(document);
                int offset = JspIntroduceParameterProcessor.this.getDeclarationOffset();
                JspIntroduceParameterProcessor.this.myEditor.getCaretModel().moveToOffset(offset);
            }
        });
        TemplateImpl template = this.getTemplate();
        template.setToReformat(true);
        template.setToIndent(true);
        Map<String, String> values = this.getTemplateProperties();
        TemplateManager.getInstance((Project)this.myProject).startTemplate(this.myEditor, (Template)template, true, values, null);
    }

    protected String getSubstitution(String parameterName) {
        return "${" + parameterName + "}";
    }

    protected Map<String, String> getTemplateProperties() {
        HashMap values = new HashMap();
        values.put("NAME", this.myParameterName);
        return values;
    }

    protected int getDeclarationOffset() {
        XmlTag anchor = (XmlTag)ArrayUtil.getLastElement((Object[])this.myTagFile.getDirectiveTags(JspDirectiveKind.ATTRIBUTE, false));
        if (anchor == null) {
            anchor = (XmlTag)ArrayUtil.getLastElement((Object[])this.myTagFile.getDirectiveTags(JspDirectiveKind.PAGE, false));
        }
        return anchor == null ? 0 : anchor.getTextRange().getEndOffset();
    }

    protected TemplateImpl getTemplate() {
        return TemplateSettings.getInstance().getTemplate("jspa", "JSP");
    }

    protected String getCommandName() {
        return "Introduce JSP parameter";
    }
}

