/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.debugger;

import com.intellij.javascript.trace.debugger.TraceFileValueHint;
import com.intellij.javascript.trace.execution.common.TraceRangeValue;
import com.intellij.javascript.trace.execution.common.TraceVirtualFile;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.impl.evaluate.quick.common.AbstractValueHint;
import com.intellij.xdebugger.impl.evaluate.quick.common.QuickEvaluateHandler;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueHintType;
import java.awt.Point;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TraceFileQuickEvaluateHandler
extends QuickEvaluateHandler {
    public boolean isEnabled(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/trace/debugger/TraceFileQuickEvaluateHandler", "isEnabled"));
        }
        Editor activeEditor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        if (activeEditor == null || !(activeEditor instanceof EditorEx)) {
            return false;
        }
        VirtualFile file = ((EditorEx)activeEditor).getVirtualFile();
        return file instanceof TraceVirtualFile;
    }

    @Nullable
    public AbstractValueHint createValueHint(@NotNull Project project, @NotNull Editor editor, @NotNull Point point, ValueHintType type) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/trace/debugger/TraceFileQuickEvaluateHandler", "createValueHint"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/javascript/trace/debugger/TraceFileQuickEvaluateHandler", "createValueHint"));
        }
        if (point == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "com/intellij/javascript/trace/debugger/TraceFileQuickEvaluateHandler", "createValueHint"));
        }
        VirtualFile file = ((EditorEx)editor).getVirtualFile();
        if (!(file instanceof TraceVirtualFile)) {
            return null;
        }
        TraceVirtualFile traceVirtualFile = (TraceVirtualFile)file;
        final int offset = AbstractValueHint.calculateOffset((Editor)editor, (Point)point);
        TextRange funcScopeRange = traceVirtualFile.getCurrentScopeApproxRange(editor);
        if (!funcScopeRange.contains(offset)) {
            return null;
        }
        TraceRangeValue rangeValue = (TraceRangeValue)ContainerUtil.find((Object[])traceVirtualFile.getActiveRangeValues(), (Condition)new Condition<TraceRangeValue>(){

            public boolean value(TraceRangeValue value) {
                return value.getTextRange().contains(offset);
            }
        });
        if (rangeValue == null) {
            return null;
        }
        return new TraceFileValueHint(project, editor, point, type, rangeValue.getTextRange(), rangeValue.getValue());
    }

    public boolean canShowHint(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/trace/debugger/TraceFileQuickEvaluateHandler", "canShowHint"));
        }
        return this.isEnabled(project);
    }

    public int getValueLookupDelay(Project project) {
        return 30;
    }
}

