/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution;

import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.javascript.nodejs.NodeDetectionUtil;
import com.intellij.javascript.nodejs.NodeUIUtil;
import com.intellij.javascript.trace.TraceBundle;
import com.intellij.javascript.trace.execution.TraceConfigurationEditorUtils;
import com.intellij.javascript.trace.execution.TraceLimitsPanel;
import com.intellij.javascript.trace.execution.TraceNodeConfiguration;
import com.intellij.javascript.trace.execution.TraceNodeRunConfigurationSettings;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.PortField;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.ReadonlyFieldWithHistoryWithBrowseButton;
import com.intellij.util.ui.SwingHelper;
import java.awt.Component;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TraceNodeRunConfigurationEditor
extends SettingsEditor<TraceNodeConfiguration> {
    private final ReadonlyFieldWithHistoryWithBrowseButton myNodeInterpreterField;
    private final PortField myTraceServerPortField;
    private final JPanel myRootComponent;
    private final RawCommandLineEditor myNodeParamsField;
    private final TextFieldWithBrowseButton myWorkingDirField;
    private final RawCommandLineEditor myAppParamsField;
    private final EnvironmentVariablesComponent myEnvironmentComponent;
    private final TextFieldWithBrowseButton myAppField;
    private final TextFieldWithHistoryWithBrowseButton myConfig;
    private final String myTheOnlyNodePath;
    private final TraceLimitsPanel myTraceLimitsPanel;

    public TraceNodeRunConfigurationEditor(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/trace/execution/TraceNodeRunConfigurationEditor", "<init>"));
        }
        List nodePaths = NodeDetectionUtil.listAllPossibleNodeInterpreters();
        this.myTheOnlyNodePath = nodePaths.size() == 1 ? ((File)nodePaths.get(0)).getAbsolutePath() : null;
        this.myNodeInterpreterField = NodeUIUtil.createNodeInterpreterTextField((Project)project);
        this.myTraceServerPortField = new PortField(3547);
        this.myConfig = TraceConfigurationEditorUtils.createConfigurationFileTextField(project);
        ((TextFieldWithHistory)this.myConfig.getChildComponent()).addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                TraceNodeRunConfigurationEditor.this.myTraceLimitsPanel.setEditable(StringUtil.isEmpty((String)((TextFieldWithHistory)TraceNodeRunConfigurationEditor.this.myConfig.getChildComponent()).getText()));
            }
        });
        this.myNodeParamsField = new RawCommandLineEditor();
        this.myNodeParamsField.setDialogCaption(TraceBundle.message("configuration.label.node.params.dialogTitle", new Object[0]));
        this.myWorkingDirField = TraceNodeRunConfigurationEditor.createWorkingDirTextField(project);
        this.myAppField = TraceNodeRunConfigurationEditor.createAppFileTextField(project, this.myWorkingDirField.getTextField());
        this.myAppParamsField = new RawCommandLineEditor();
        this.myAppParamsField.setDialogCaption(TraceBundle.message("configuration.label.node.appParams.dialogTitle", new Object[0]));
        this.myEnvironmentComponent = new EnvironmentVariablesComponent();
        String envLabelText = this.myEnvironmentComponent.getLabel().getText();
        this.myEnvironmentComponent.remove((Component)this.myEnvironmentComponent.getLabel());
        this.myTraceLimitsPanel = new TraceLimitsPanel();
        this.myRootComponent = FormBuilder.createFormBuilder().addLabeledComponent(TraceBundle.message("configuration.label.node", new Object[0]), this.myNodeInterpreterField.getComponent()).addLabeledComponent(TraceBundle.message("configuration.label.node.params", new Object[0]), (JComponent)this.myNodeParamsField).addLabeledComponent(TraceBundle.message("configuration.label.node.workDir", new Object[0]), (JComponent)this.myWorkingDirField).addLabeledComponent(TraceBundle.message("configuration.label.node.file", new Object[0]), (JComponent)this.myAppField).addLabeledComponent(TraceBundle.message("configuration.label.node.appParams", new Object[0]), (JComponent)this.myAppParamsField).addLabeledComponent(envLabelText, (JComponent)this.myEnvironmentComponent).addLabeledComponent(TraceBundle.message("configuration.label.configFile", new Object[0]), (JComponent)this.myConfig).addLabeledComponent(TraceBundle.message("configuration.label.traceLimits", new Object[0]), (JComponent)this.myTraceLimitsPanel).addLabeledComponent(TraceBundle.message("configuration.label.port", new Object[0]), (JComponent)this.myTraceServerPortField).getPanel();
    }

    protected void resetEditorFrom(TraceNodeConfiguration configuration) {
        TraceNodeRunConfigurationSettings settings = configuration.getTraceSettings();
        String nodePath = settings.getNodePath();
        if (nodePath.isEmpty() && this.myTheOnlyNodePath != null) {
            nodePath = this.myTheOnlyNodePath;
        }
        this.myNodeInterpreterField.set(nodePath);
        this.myNodeParamsField.setText(settings.getNodeParams());
        this.myWorkingDirField.setText(settings.getWorkingDir());
        this.myAppField.setText(settings.getAppPath());
        this.myAppParamsField.setText(settings.getAppParams());
        this.myEnvironmentComponent.setEnvs(settings.getEnv());
        this.myEnvironmentComponent.setPassParentEnvs(settings.isPassParentEnv());
        TraceConfigurationEditorUtils.setTextAndAddToHistory((TextFieldWithHistory)this.myConfig.getChildComponent(), settings.getConfigPath());
        boolean noConfig = StringUtil.nullize((String)settings.getConfigPath()) == null;
        this.myTraceLimitsPanel.setEditable(noConfig);
        if (noConfig && settings.getTraceLimits() != null) {
            this.myTraceLimitsPanel.setValue(settings.getTraceLimits());
        }
        this.myTraceServerPortField.setValue((Object)settings.getProxyPort());
    }

    protected void applyEditorTo(TraceNodeConfiguration configuration) throws ConfigurationException {
        String nodePath = this.myNodeInterpreterField.get();
        if (nodePath.isEmpty() && this.myTheOnlyNodePath != null) {
            nodePath = this.myTheOnlyNodePath;
        }
        String configPath = ((TextFieldWithHistory)this.myConfig.getChildComponent()).getText();
        configuration.setTraceSettings(new TraceNodeRunConfigurationSettings(this.myTraceServerPortField.getNumber(), StringUtil.notNullize((String)configPath), !StringUtil.isEmpty((String)configPath) ? null : this.myTraceLimitsPanel.getValue(), StringUtil.notNullize((String)nodePath), StringUtil.notNullize((String)this.myNodeParamsField.getText()), StringUtil.notNullize((String)this.myWorkingDirField.getText()), StringUtil.notNullize((String)this.myAppField.getText()), StringUtil.notNullize((String)this.myAppParamsField.getText()), this.myEnvironmentComponent.getEnvs(), this.myEnvironmentComponent.isPassParentEnvs()));
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myRootComponent;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/TraceNodeRunConfigurationEditor", "createEditor"));
        }
        return jPanel;
    }

    @NotNull
    private static TextFieldWithBrowseButton createWorkingDirTextField(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/trace/execution/TraceNodeRunConfigurationEditor", "createWorkingDirTextField"));
        }
        TextFieldWithBrowseButton textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        SwingHelper.installFileCompletionAndBrowseDialog((Project)project, (TextFieldWithBrowseButton)textFieldWithBrowseButton, (String)TraceBundle.message("configuration.label.node.workDir.dialogTitle", new Object[0]), (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFolderDescriptor());
        TextFieldWithBrowseButton textFieldWithBrowseButton2 = textFieldWithBrowseButton;
        if (textFieldWithBrowseButton2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/TraceNodeRunConfigurationEditor", "createWorkingDirTextField"));
        }
        return textFieldWithBrowseButton2;
    }

    @NotNull
    private static TextFieldWithBrowseButton createAppFileTextField(@NotNull Project project, final @NotNull JTextField baseDir) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/trace/execution/TraceNodeRunConfigurationEditor", "createAppFileTextField"));
        }
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/intellij/javascript/trace/execution/TraceNodeRunConfigurationEditor", "createAppFileTextField"));
        }
        TextFieldWithBrowseButton textFieldWithBrowseButton = new TextFieldWithBrowseButton(new JTextField(){

            @Override
            public void setText(String text) {
                super.setText(FileUtil.toSystemDependentName((String)this.refineText(text, baseDir.getText())));
            }

            @NotNull
            private String refineText(@Nullable String path, @Nullable String baseDirPath) {
                String relativePath;
                boolean inside;
                if (StringUtil.isEmpty((String)path)) {
                    String string = StringUtil.notNullize((String)path);
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/TraceNodeRunConfigurationEditor$2", "refineText"));
                    }
                    return string;
                }
                if (StringUtil.isEmpty((String)baseDirPath)) {
                    String string = StringUtil.notNullize((String)path);
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/TraceNodeRunConfigurationEditor$2", "refineText"));
                    }
                    return string;
                }
                File baseDir2 = new File(baseDirPath);
                File file = new File(path);
                if (file.isAbsolute() && baseDir2.isDirectory() && (inside = FileUtil.isAncestor((File)baseDir2, (File)file, (boolean)true)) && (relativePath = FileUtil.getRelativePath((File)baseDir2, (File)file)) != null) {
                    String string = relativePath;
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/TraceNodeRunConfigurationEditor$2", "refineText"));
                    }
                    return string;
                }
                String string = StringUtil.notNullize((String)path);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/TraceNodeRunConfigurationEditor$2", "refineText"));
                }
                return string;
            }
        });
        SwingHelper.installFileCompletionAndBrowseDialog((Project)project, (TextFieldWithBrowseButton)textFieldWithBrowseButton, (String)TraceBundle.message("configuration.label.node.file.dialogTitle", new Object[0]), (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFileDescriptor((FileType)JavaScriptFileType.INSTANCE));
        TextFieldWithBrowseButton textFieldWithBrowseButton2 = textFieldWithBrowseButton;
        if (textFieldWithBrowseButton2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/TraceNodeRunConfigurationEditor", "createAppFileTextField"));
        }
        return textFieldWithBrowseButton2;
    }
}

