/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution;

import com.intellij.javascript.trace.execution.TraceLimits;
import java.io.File;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TraceNodeRunConfigurationSettings {
    private final String myConfigPath;
    @NotNull
    private final String myNodePath;
    @NotNull
    private final String myNodeParams;
    @NotNull
    private final String myWorkingDir;
    @NotNull
    private final String myAppPath;
    @NotNull
    private final String myAppParams;
    @NotNull
    private final Map<String, String> myEnv;
    private final int myProxyPort;
    private final boolean myPassParentEnv;
    private TraceLimits myTraceLimits;

    public TraceNodeRunConfigurationSettings(int proxyPort, @NotNull String configPath, @Nullable TraceLimits traceLimits, @NotNull String nodePath, @NotNull String nodeParams, @NotNull String workingDir, @NotNull String appPath, @NotNull String appParams, @NotNull Map<String, String> env, boolean passParentEnv) {
        if (configPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configPath", "com/intellij/javascript/trace/execution/TraceNodeRunConfigurationSettings", "<init>"));
        }
        if (nodePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodePath", "com/intellij/javascript/trace/execution/TraceNodeRunConfigurationSettings", "<init>"));
        }
        if (nodeParams == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeParams", "com/intellij/javascript/trace/execution/TraceNodeRunConfigurationSettings", "<init>"));
        }
        if (workingDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workingDir", "com/intellij/javascript/trace/execution/TraceNodeRunConfigurationSettings", "<init>"));
        }
        if (appPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "appPath", "com/intellij/javascript/trace/execution/TraceNodeRunConfigurationSettings", "<init>"));
        }
        if (appParams == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "appParams", "com/intellij/javascript/trace/execution/TraceNodeRunConfigurationSettings", "<init>"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/javascript/trace/execution/TraceNodeRunConfigurationSettings", "<init>"));
        }
        this.myProxyPort = proxyPort;
        this.myConfigPath = configPath;
        this.myTraceLimits = traceLimits;
        this.myNodePath = nodePath;
        this.myNodeParams = nodeParams;
        this.myWorkingDir = workingDir;
        this.myAppPath = appPath;
        this.myAppParams = appParams;
        this.myEnv = env;
        this.myPassParentEnv = passParentEnv;
    }

    public boolean isPassParentEnv() {
        return this.myPassParentEnv;
    }

    @NotNull
    public String getConfigPath() {
        String string = this.myConfigPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/TraceNodeRunConfigurationSettings", "getConfigPath"));
        }
        return string;
    }

    public int getProxyPort() {
        return this.myProxyPort;
    }

    @NotNull
    public String getNodePath() {
        String string = this.myNodePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/TraceNodeRunConfigurationSettings", "getNodePath"));
        }
        return string;
    }

    @NotNull
    public String getNodeParams() {
        String string = this.myNodeParams;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/TraceNodeRunConfigurationSettings", "getNodeParams"));
        }
        return string;
    }

    @NotNull
    public String getWorkingDir() {
        String string = this.myWorkingDir;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/TraceNodeRunConfigurationSettings", "getWorkingDir"));
        }
        return string;
    }

    @NotNull
    public String getAppPath() {
        String string = this.myAppPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/TraceNodeRunConfigurationSettings", "getAppPath"));
        }
        return string;
    }

    @NotNull
    public String getAppParams() {
        String string = this.myAppParams;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/TraceNodeRunConfigurationSettings", "getAppParams"));
        }
        return string;
    }

    @NotNull
    public Map<String, String> getEnv() {
        Map<String, String> map = this.myEnv;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/TraceNodeRunConfigurationSettings", "getEnv"));
        }
        return map;
    }

    @NotNull
    public File getAppFile() {
        File file = new File(this.getWorkingDir(), this.getAppPath());
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/TraceNodeRunConfigurationSettings", "getAppFile"));
        }
        return file;
    }

    @Nullable
    public TraceLimits getTraceLimits() {
        return this.myTraceLimits;
    }
}

