/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.events.actions;

import com.intellij.javascript.trace.TraceBundle;
import com.intellij.javascript.trace.execution.Utils;
import com.intellij.javascript.trace.execution.events.EventNode;
import com.intellij.javascript.trace.execution.events.EventTree;
import com.intellij.javascript.trace.execution.events.actions.EventNodeAction;
import com.intellij.javascript.trace.settings.TraceProjectSettings;
import com.intellij.javascript.trace.settings.TraceSettingsManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;

public class AddFileToFilterAction
extends EventNodeAction {
    @Override
    protected void doUpdate(@NotNull AnActionEvent e, @NotNull EventNode context, @NotNull EventTree tree) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/javascript/trace/execution/events/actions/AddFileToFilterAction", "doUpdate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/trace/execution/events/actions/AddFileToFilterAction", "doUpdate"));
        }
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/javascript/trace/execution/events/actions/AddFileToFilterAction", "doUpdate"));
        }
        TraceProjectSettings.EventFilterState activeFilter = tree.getTraceSettingsManager().getActiveFilter();
        String file = AddFileToFilterAction.getFirstNonExcludedFile(context, activeFilter);
        if (file == null) {
            e.getPresentation().setVisible(false);
        } else {
            e.getPresentation().setText(String.format(TraceBundle.message("console.trace.toolbar.filterEvents.muteFileTemplate", new Object[0]), Utils.getShortFileName(file)), false);
        }
    }

    private static String getFirstNonExcludedFile(EventNode context, final TraceProjectSettings.EventFilterState activeFilter) {
        return (String)ContainerUtil.find((Object[])context.getEvent().getFiles(), (Condition)new Condition<String>(){

            public boolean value(String file) {
                return !activeFilter.matchesFileName(file);
            }
        });
    }

    @Override
    protected void doPerform(@NotNull AnActionEvent e, @NotNull EventNode context, @NotNull EventTree tree) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/javascript/trace/execution/events/actions/AddFileToFilterAction", "doPerform"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/trace/execution/events/actions/AddFileToFilterAction", "doPerform"));
        }
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/javascript/trace/execution/events/actions/AddFileToFilterAction", "doPerform"));
        }
        TraceSettingsManager traceSettingsManager = tree.getTraceSettingsManager();
        TraceProjectSettings.EventFilterState activeFilter = traceSettingsManager.getActiveFilter();
        String file = AddFileToFilterAction.getFirstNonExcludedFile(context, activeFilter);
        if (file == null) {
            return;
        }
        TraceProjectSettings.EventFilterConditionState condition = new TraceProjectSettings.EventFilterConditionState();
        condition.setType("file");
        condition.setValue(StringUtil.escapeBackSlashes((String)file));
        traceSettingsManager.addToActiveOrCreateNewFilterAndApply(condition, String.format(TraceBundle.message("console.trace.toolbar.filterEvents.muteNameSuggestionTemplate", new Object[0]), Utils.getShortFileName(file)));
    }
}

