/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.fileDependency;

import com.intellij.javascript.trace.execution.fileDependency.FileNode;
import com.intellij.util.containers.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class FunctionCombination {
    @NotNull
    private final FileNode mySourceFile;
    @NotNull
    private FileNode myTargetFile;
    @NotNull
    private final String myFromFunctionId;
    @NotNull
    private final String myToFunctionId;
    private final HashMap<Long, Long> myEventHits;

    public FunctionCombination(@NotNull FileNode sourceFile, @NotNull String fromFunctionId, @NotNull FileNode targetFile, @NotNull String toFunctionId) {
        if (sourceFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFile", "com/intellij/javascript/trace/execution/fileDependency/FunctionCombination", "<init>"));
        }
        if (fromFunctionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromFunctionId", "com/intellij/javascript/trace/execution/fileDependency/FunctionCombination", "<init>"));
        }
        if (targetFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetFile", "com/intellij/javascript/trace/execution/fileDependency/FunctionCombination", "<init>"));
        }
        if (toFunctionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toFunctionId", "com/intellij/javascript/trace/execution/fileDependency/FunctionCombination", "<init>"));
        }
        this.myEventHits = new HashMap();
        this.myTargetFile = targetFile;
        this.mySourceFile = sourceFile;
        this.myFromFunctionId = fromFunctionId;
        this.myToFunctionId = toFunctionId;
    }

    public void addEvent(long eventId, long hitCount) {
        this.myEventHits.put((Object)eventId, (Object)hitCount);
    }

    @NotNull
    public String getFromFunctionId() {
        String string = this.myFromFunctionId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/fileDependency/FunctionCombination", "getFromFunctionId"));
        }
        return string;
    }

    @NotNull
    public String getToFunctionId() {
        String string = this.myToFunctionId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/fileDependency/FunctionCombination", "getToFunctionId"));
        }
        return string;
    }

    @NotNull
    public FileNode getSourceFile() {
        FileNode fileNode = this.mySourceFile;
        if (fileNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/fileDependency/FunctionCombination", "getSourceFile"));
        }
        return fileNode;
    }

    @NotNull
    public FileNode getTargetFile() {
        FileNode fileNode = this.myTargetFile;
        if (fileNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/fileDependency/FunctionCombination", "getTargetFile"));
        }
        return fileNode;
    }

    @NotNull
    public Map<Long, Long> getEventHits() {
        HashMap<Long, Long> hashMap = this.myEventHits;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/fileDependency/FunctionCombination", "getEventHits"));
        }
        return hashMap;
    }
}

