/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.settings;

import com.intellij.javascript.trace.execution.TraceConsoleProperties;
import com.intellij.javascript.trace.settings.TraceConfigurable;
import com.intellij.javascript.trace.settings.TraceProjectSettings;
import com.intellij.javascript.trace.settings.TraceSettings;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TraceSettingsManager {
    private Project myProject;
    private TraceConsoleProperties myProperties;
    private List<Consumer<TraceSettings>> myApplySettingsConsumers;
    private boolean isLoaded;

    public TraceSettingsManager(@NotNull Project project, @NotNull TraceConsoleProperties properties) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/trace/settings/TraceSettingsManager", "<init>"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/javascript/trace/settings/TraceSettingsManager", "<init>"));
        }
        this.myApplySettingsConsumers = new ArrayList<Consumer<TraceSettings>>();
        this.myProject = project;
        this.myProperties = properties;
    }

    public void applySettings() {
        TraceProjectSettings.EventFilterState activeFilter = this.getActiveFilter();
        for (Consumer<TraceSettings> consumer : this.myApplySettingsConsumers) {
            consumer.consume((Object)new TraceSettings(activeFilter, this.myProperties.isRealtimeEvaluationEnabled(), this.myProperties.isSourceMapLookupEnabled(), this.myProperties.isSourceMapGenerationEnabled()));
        }
    }

    public TraceProjectSettings.EventFilterState getActiveFilter() {
        String filterName = this.myProperties.getEventFilterName();
        TraceProjectSettings.EventFilterState filter = TraceProjectSettings.getInstance(this.myProject).getState().findEventFilterByName(filterName);
        return filter != null ? filter : (TraceProjectSettings.EventFilterState.ALL_FILTER.getName().equals(filterName) ? TraceProjectSettings.EventFilterState.ALL_FILTER : TraceProjectSettings.EventFilterState.NULL_FILTER);
    }

    public void addSettingsConsumer(Consumer<TraceSettings> consumer) {
        this.myApplySettingsConsumers.add(consumer);
    }

    public TraceProjectSettings.EventFilterState[] getFilters() {
        TraceProjectSettings.TraceSettingsState state = TraceProjectSettings.getInstance(this.myProject).getState();
        List<TraceProjectSettings.EventFilterState> filters = state.getEventFilters();
        return filters.toArray(new TraceProjectSettings.EventFilterState[filters.size()]);
    }

    public String getActiveFilterName() {
        return this.myProperties.getEventFilterName();
    }

    public void setAndApplyFilter(String filterName) {
        this.myProperties.setEventFilterName(filterName);
        this.applySettings();
    }

    public boolean setAndApplyFilterByCondition(String value) {
        TraceProjectSettings.EventFilterState filter = TraceProjectSettings.getInstance(this.myProject).getState().findEventFilterByOnlyCondition(value);
        if (filter == null) {
            return false;
        }
        this.setAndApplyFilter(filter.getName());
        return true;
    }

    public void addToActiveOrCreateNewFilterAndApply(final @NotNull TraceProjectSettings.EventFilterConditionState condition, final @NotNull String nameSuggestion) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/javascript/trace/settings/TraceSettingsManager", "addToActiveOrCreateNewFilterAndApply"));
        }
        if (nameSuggestion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameSuggestion", "com/intellij/javascript/trace/settings/TraceSettingsManager", "addToActiveOrCreateNewFilterAndApply"));
        }
        TraceProjectSettings.EventFilterState activeFilter = this.getActiveFilter();
        if (!TraceProjectSettings.EventFilterState.isAllOrNothingFilter(activeFilter)) {
            activeFilter.addEventFilterCondition(condition);
            this.applySettings();
        } else {
            ShowSettingsUtil util = ShowSettingsUtil.getInstance();
            final TraceConfigurable configurable = new TraceConfigurable(this.myProject, this);
            util.editConfigurable(this.myProject, (Configurable)configurable, new Runnable(){

                @Override
                public void run() {
                    configurable.addActiveFilterWithCondition(condition, nameSuggestion);
                }
            });
        }
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public void setLoaded(boolean isLoaded) {
        this.isLoaded = isLoaded;
    }

    public boolean isSourceMapSupportEnabled() {
        return this.myProperties.isSourceMapLookupEnabled();
    }
}

