/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.java;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.java.config.CucumberConfigUtil;
import org.jetbrains.plugins.cucumber.java.steps.reference.CucumberJavaAnnotationProvider;
import org.jetbrains.plugins.cucumber.psi.GherkinFeature;
import org.jetbrains.plugins.cucumber.psi.GherkinFile;
import org.jetbrains.plugins.cucumber.psi.GherkinScenario;
import org.jetbrains.plugins.cucumber.psi.GherkinScenarioOutline;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;

public class CucumberJavaUtil {
    public static final String CUCUMBER_STEP_ANNOTATION_PREFIX_1_0 = "cucumber.annotation.";
    public static final String CUCUMBER_STEP_ANNOTATION_PREFIX_1_1 = "cucumber.api.java.";

    private static String getCucumberAnnotationSuffix(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/cucumber/java/CucumberJavaUtil", "getCucumberAnnotationSuffix"));
        }
        if (name.startsWith(CUCUMBER_STEP_ANNOTATION_PREFIX_1_0)) {
            return name.substring(CUCUMBER_STEP_ANNOTATION_PREFIX_1_0.length());
        }
        if (name.startsWith(CUCUMBER_STEP_ANNOTATION_PREFIX_1_1)) {
            return name.substring(CUCUMBER_STEP_ANNOTATION_PREFIX_1_1.length());
        }
        name = "";
        return name;
    }

    public static String getCucumberPendingExceptionFqn(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/cucumber/java/CucumberJavaUtil", "getCucumberPendingExceptionFqn"));
        }
        String version = CucumberConfigUtil.getCucumberCoreVersion(context);
        if (version == null || version.compareTo("1.1") >= 0) {
            return "cucumber.api.PendingException";
        }
        return "cucumber.runtime.PendingException";
    }

    @Nullable
    private static String getAnnotationName(final @NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/plugins/cucumber/java/CucumberJavaUtil", "getAnnotationName"));
        }
        final Ref qualifiedAnnotationName = new Ref();
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                String qualifiedName = annotation.getQualifiedName();
                qualifiedAnnotationName.set((Object)qualifiedName);
            }
        });
        return (String)qualifiedAnnotationName.get();
    }

    public static boolean isCucumberStepAnnotation(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/plugins/cucumber/java/CucumberJavaUtil", "isCucumberStepAnnotation"));
        }
        String annotationName = CucumberJavaUtil.getAnnotationName(annotation);
        if (annotationName == null) {
            return false;
        }
        String annotationSuffix = CucumberJavaUtil.getCucumberAnnotationSuffix(annotationName);
        if (annotationSuffix.contains(".")) {
            return true;
        }
        for (String providedAnnotations : CucumberJavaAnnotationProvider.getCucumberStepAnnotations()) {
            if (!providedAnnotations.equals(annotationName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCucumberHookAnnotation(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/plugins/cucumber/java/CucumberJavaUtil", "isCucumberHookAnnotation"));
        }
        String annotationName = CucumberJavaUtil.getAnnotationName(annotation);
        if (annotationName == null) {
            return false;
        }
        String annotationSuffix = CucumberJavaUtil.getCucumberAnnotationSuffix(annotationName);
        for (String providedAnnotations : CucumberJavaAnnotationProvider.getCucumberHookAnnotations()) {
            if (!providedAnnotations.equals(annotationSuffix)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static PsiAnnotationMemberValue getAnnotationValue(@NotNull PsiAnnotation stepAnnotation) {
        if (stepAnnotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stepAnnotation", "org/jetbrains/plugins/cucumber/java/CucumberJavaUtil", "getAnnotationValue"));
        }
        PsiNameValuePair[] attributes = stepAnnotation.getParameterList().getAttributes();
        PsiNameValuePair valuePair = null;
        if (attributes.length > 0) {
            for (int i = 1; i < attributes.length; ++i) {
                PsiNameValuePair pair = attributes[i];
                String pairName = pair.getName();
                if (pairName == null || !pairName.equals("value")) continue;
                valuePair = pair;
                break;
            }
            if (valuePair == null) {
                valuePair = attributes[0];
            }
        }
        return valuePair != null ? valuePair.getValue() : null;
    }

    public static boolean isStepDefinition(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/cucumber/java/CucumberJavaUtil", "isStepDefinition"));
        }
        PsiAnnotation stepAnnotation = CucumberJavaUtil.getCucumberStepAnnotation(method);
        return stepAnnotation != null && CucumberJavaUtil.getAnnotationValue(stepAnnotation) != null;
    }

    public static boolean isHook(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/cucumber/java/CucumberJavaUtil", "isHook"));
        }
        return CucumberJavaUtil.getCucumberHookAnnotation(method) != null;
    }

    public static boolean isStepDefinitionClass(@NotNull PsiClass clazz) {
        PsiMethod[] methods;
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/jetbrains/plugins/cucumber/java/CucumberJavaUtil", "isStepDefinitionClass"));
        }
        for (PsiMethod method : methods = clazz.getAllMethods()) {
            if (CucumberJavaUtil.getCucumberStepAnnotation(method) == null && CucumberJavaUtil.getCucumberHookAnnotation(method) == null) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static PsiAnnotation getCucumberStepAnnotation(PsiMethod method) {
        PsiAnnotation[] annotations;
        for (PsiAnnotation annotation : annotations = method.getModifierList().getAnnotations()) {
            if (annotation == null || !CucumberJavaUtil.isCucumberStepAnnotation(annotation)) continue;
            return annotation;
        }
        return null;
    }

    @Nullable
    public static PsiAnnotation getCucumberHookAnnotation(PsiMethod method) {
        PsiAnnotation[] annotations;
        for (PsiAnnotation annotation : annotations = method.getModifierList().getAnnotations()) {
            if (annotation == null || !CucumberJavaUtil.isCucumberHookAnnotation(annotation)) continue;
            return annotation;
        }
        return null;
    }

    @Nullable
    public static String getPatternFromStepDefinition(@NotNull PsiAnnotation stepAnnotation) {
        PsiElement patternLiteral;
        PsiAnnotationMemberValue annotationValue;
        if (stepAnnotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stepAnnotation", "org/jetbrains/plugins/cucumber/java/CucumberJavaUtil", "getPatternFromStepDefinition"));
        }
        String result = null;
        if (stepAnnotation.getParameterList().getAttributes().length > 0 && (annotationValue = stepAnnotation.getParameterList().getAttributes()[0].getValue()) != null && (patternLiteral = annotationValue.getFirstChild()) != null) {
            String patternContainer = patternLiteral.getText();
            result = patternContainer.substring(1, patternContainer.length() - 1).replace("\\\\", "\\");
        }
        return result;
    }

    @Nullable
    private static String getPackageOfStepDef(GherkinStep[] steps) {
        for (GherkinStep step : steps) {
            String pack = CucumberJavaUtil.getPackageOfStep(step);
            if (pack == null) continue;
            return pack;
        }
        return null;
    }

    @NotNull
    public static String getPackageOfStepDef(PsiElement element) {
        GherkinFeature feature;
        PsiFile file = element.getContainingFile();
        if (file instanceof GherkinFile && (feature = (GherkinFeature)PsiTreeUtil.getChildOfType((PsiElement)file, GherkinFeature.class)) != null) {
            List scenarioList = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)feature, GherkinScenario.class);
            for (GherkinScenario scenario : scenarioList) {
                String result = CucumberJavaUtil.getPackageOfStepDef(scenario.getSteps());
                if (result == null) continue;
                String string = result;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/java/CucumberJavaUtil", "getPackageOfStepDef"));
                }
                return string;
            }
            List scenarioOutlineList = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)feature, GherkinScenarioOutline.class);
            for (GherkinScenarioOutline scenario : scenarioOutlineList) {
                String result = CucumberJavaUtil.getPackageOfStepDef(scenario.getSteps());
                if (result == null) continue;
                String string = result;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/java/CucumberJavaUtil", "getPackageOfStepDef"));
                }
                return string;
            }
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/java/CucumberJavaUtil", "getPackageOfStepDef"));
        }
        return "";
    }

    public static String getPackageOfStep(GherkinStep step) {
        for (PsiReference ref : step.getReferences()) {
            PsiClassOwner file;
            String packageName;
            PsiElement refElement = ref.resolve();
            if (refElement == null || !(refElement instanceof PsiMethod) || !StringUtil.isNotEmpty((String)(packageName = (file = (PsiClassOwner)refElement.getContainingFile()).getPackageName()))) continue;
            return packageName;
        }
        return null;
    }

    public static void addGlue(String glue, Set<String> glues) {
        boolean covered = false;
        HashSet toRemove = ContainerUtil.newHashSet();
        for (String existedGlue : glues) {
            if (glue.startsWith(existedGlue + ".")) {
                covered = true;
                break;
            }
            if (!existedGlue.startsWith(glue + ".")) continue;
            toRemove.add(existedGlue);
        }
        for (String removing : toRemove) {
            glues.remove(removing);
        }
        if (!covered) {
            glues.add(glue);
        }
    }
}

