/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.psi;

import com.intellij.aop.AopAdvisedElementsSearcher;
import com.intellij.aop.psi.AopCompletionData;
import com.intellij.aop.psi.AopPointcutExpressionHolder;
import com.intellij.aop.psi.AopPointcutUtil;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.spring.aop.SpringAdvisedElementsSearcher;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.Consumer;
import com.intellij.util.ProcessingContext;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SpringAopCompletionContributor
extends CompletionContributor {
    @NonNls
    public static final String[] SPRING20_AOP_POINTCUTS = new String[]{"execution", "target", "this", "within", "@target", "@within", "@annotation", "args", "@args"};

    public SpringAopCompletionContributor() {
        this.extend(CompletionType.BASIC, AopCompletionData.POINTCUT_PATTERN, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, final @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/aop/psi/SpringAopCompletionContributor$1", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/aop/psi/SpringAopCompletionContributor$1", "addCompletions"));
                }
                AopPointcutExpressionHolder holder = AopPointcutUtil.getHolder((PsiElement)parameters.getPosition());
                AopAdvisedElementsSearcher searcher = holder.getAopModel().getAdvisedElementsSearcher();
                final boolean isSpring = searcher instanceof SpringAdvisedElementsSearcher;
                if (isSpring) {
                    for (String pointcut : SPRING20_AOP_POINTCUTS) {
                        result.addElement(AopCompletionData.createPointcutDesignatorElement((String)pointcut));
                    }
                    Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)parameters.getPosition());
                    if (module != null && SpringCommonUtils.isAtLeastSpring25((Module)module)) {
                        result.addElement(AopCompletionData.createPointcutDesignatorElement((String)"bean"));
                    }
                }
                final Set designators = AopCompletionData.getAllPointcutDesignators();
                result.runRemainingContributors(parameters, (Consumer)new Consumer<CompletionResult>(){

                    public void consume(CompletionResult r) {
                        if (!isSpring || !designators.contains(r.getLookupElement().getLookupString())) {
                            result.passResult(r);
                        }
                    }
                });
            }
        });
    }
}

