/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.aop;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.UseScopeEnlarger;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class SpringAopParameterScopeEnlarger
extends UseScopeEnlarger {
    public SearchScope getAdditionalUseScope(@NotNull PsiElement element) {
        Module module;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/aop/SpringAopParameterScopeEnlarger", "getAdditionalUseScope"));
        }
        if (element instanceof PsiParameter && (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) != null) {
            HashSet files = new HashSet();
            for (SpringModel model : SpringManager.getInstance((Project)module.getProject()).getAllModels(module)) {
                for (PsiFile file : model.getConfigFiles()) {
                    ContainerUtil.addIfNotNull((Object)file.getVirtualFile(), files);
                }
            }
            if (files.isEmpty()) {
                return null;
            }
            return GlobalSearchScope.filesScope((Project)element.getProject(), files);
        }
        return null;
    }
}

