/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jboss.server;

import com.intellij.javaee.oss.jboss.server.JBossExtensions;
import com.intellij.javaee.oss.jboss.server.JBossLocalModel;
import com.intellij.javaee.oss.jboss.version.JBossContributionsProvider;
import com.intellij.javaee.oss.jboss.version.JBossVersion6Handler;
import com.intellij.javaee.oss.jboss.version.JBossVersionContribution;
import com.intellij.javaee.oss.server.ServerSupportContributorBase;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.supportProvider.JavaeeFrameworkSupportContributionModel;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.util.PathUtil;
import java.io.File;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class JBossServerSupportContributor
extends ServerSupportContributorBase<JBossLocalModel> {
    @NonNls
    public static final String DEFAULT_SERVER = "default";
    private JBossContributionsProvider<ServerSupportContribution> myContributionsProvider;

    public JBossServerSupportContributor() {
        super(JBossLocalModel.class);
        this.init();
    }

    private void init() {
        this.myContributionsProvider = new JBossContributionsProvider<ServerSupportContribution>(ServerSupportContribution.class);
        this.myContributionsProvider.add(JBossVersion6Handler.ID, new ServerSupportContribution(){

            @Override
            public void setupRunConfiguration(JBossLocalModel serverModel) {
                JBossServerSupportContributor.selectDefaultServer(serverModel);
            }
        });
    }

    protected void doSetupServerRunConfiguration(JBossLocalModel serverModel, CommonModel commonModel, JavaeeFrameworkSupportContributionModel frameworkModel) {
        serverModel.getContribution(this.myContributionsProvider).setupRunConfiguration(serverModel);
        JBossServerSupportContributor.setCorrectExtension(frameworkModel.getModifiableExplodedEarArtifact());
        JBossServerSupportContributor.setCorrectExtension(frameworkModel.getModifiableExplodedEjbArtifact());
        JBossServerSupportContributor.setCorrectExtension(frameworkModel.getModifiableExplodedWarArtifact());
    }

    private static void setCorrectExtension(@Nullable ModifiableArtifact artifact) {
        if (artifact == null) {
            return;
        }
        String outputPath = artifact.getOutputPath();
        if (outputPath == null) {
            return;
        }
        JBossExtensions extensions = JBossExtensions.getInstance();
        String extension = FileUtilRt.getExtension((String)PathUtil.getFileName((String)outputPath));
        if (!extensions.isValidExtension(artifact.getArtifactType(), extension)) {
            artifact.setOutputPath(outputPath + "." + extensions.getDefaultExtension(artifact.getArtifactType()));
        }
    }

    private static void selectDefaultServer(JBossLocalModel jBossModel) {
        if (new File(jBossModel.getServersDirectory(), DEFAULT_SERVER).isDirectory()) {
            jBossModel.SERVER = DEFAULT_SERVER;
        } else {
            File[] children;
            for (File child : children = jBossModel.getServersDirectory().listFiles()) {
                if (!child.isDirectory()) continue;
                jBossModel.SERVER = child.getName();
                break;
            }
        }
    }

    private static interface ServerSupportContribution
    extends JBossVersionContribution {
        public void setupRunConfiguration(JBossLocalModel var1);
    }
}

