/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui;

import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.VersionControlLabel;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class LabelsTableModel
extends AbstractTableModel {
    private List<VersionControlLabel> myLabels;

    public void setLabels(List<VersionControlLabel> labels) {
        this.myLabels = labels;
        this.fireTableDataChanged();
    }

    public List<VersionControlLabel> getLabels() {
        return this.myLabels;
    }

    @Override
    public String getColumnName(int column) {
        return Column.values()[column].getCaption();
    }

    @Override
    public int getRowCount() {
        return this.myLabels != null ? this.myLabels.size() : 0;
    }

    @Override
    public int getColumnCount() {
        return Column.values().length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return Column.values()[columnIndex].getValue(this.myLabels.get(rowIndex));
    }

    private static enum Column {
        Name("Name"){

            @Override
            public String getValue(VersionControlLabel label) {
                return label.getName();
            }
        }
        ,
        Scope("Scope"){

            @Override
            public String getValue(VersionControlLabel label) {
                return label.getScope();
            }
        }
        ,
        Owner("Owner"){

            @Override
            public String getValue(VersionControlLabel label) {
                return label.getOwner();
            }
        };

        private final String myCaption;

        private Column(String caption) {
            this.myCaption = caption;
        }

        public String getCaption() {
            return this.myCaption;
        }

        public abstract String getValue(VersionControlLabel var1);
    }
}

