/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;
import org.jetbrains.tfsIntegration.ui.SelectChangesetForm;

public class SelectChangesetDialog
extends DialogWrapper {
    private final WorkspaceInfo myWorkspace;
    private SelectChangesetForm myForm;
    private final String myServerPath;
    private final boolean myRecursive;

    public SelectChangesetDialog(Project project, WorkspaceInfo workspace, String serverPath, boolean recursive) {
        super(project, true);
        this.myWorkspace = workspace;
        this.myServerPath = serverPath;
        this.myRecursive = recursive;
        this.setOKButtonText("Choose");
        this.setTitle("Find Changeset");
        this.setResizable(true);
        this.init();
        this.setOKActionEnabled(false);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        this.myForm = new SelectChangesetForm(this.myWorkspace, this.myServerPath, this.myRecursive);
        this.myForm.addListener(new SelectChangesetForm.Listener(){

            @Override
            public void selectionChanged(Integer changeset) {
                SelectChangesetDialog.this.setOKActionEnabled(changeset != null);
            }

            @Override
            public void selected(Integer changeset) {
                SelectChangesetDialog.this.close(0);
            }
        });
        return this.myForm.getContentPane();
    }

    @Nullable
    public Integer getChangeset() {
        return this.myForm.getSelectedChangeset();
    }

    protected String getDimensionServiceKey() {
        return "TFS.SelectChangeset";
    }
}

