/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jam.reflect;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.jam.JamElement;
import com.intellij.jam.reflect.JamAnnotatedChildrenQuery;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamFieldMeta;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.jam.reflect.JamMethodMeta;
import com.intellij.jam.reflect.JamParameterMeta;
import com.intellij.jam.reflect.JamRegisteringChildrenQuery;
import com.intellij.openapi.util.Key;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiFieldPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMethodPattern;
import com.intellij.patterns.PsiParameterPattern;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.semantic.SemRegistrar;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JamChildrenQuery<Jam extends JamElement> {
    private final Key<CachedValue<List<Jam>>> myCacheKey;

    protected JamChildrenQuery() {
        this.myCacheKey = Key.create((String)this.getClass().getName());
    }

    protected JamChildrenQuery(@NonNls String debugName) {
        this.myCacheKey = Key.create((String)debugName);
    }

    @Nullable
    public abstract JamMemberMeta<?, ? extends Jam> getMeta(@NotNull PsiModifierListOwner var1);

    protected abstract List<Jam> findChildren(@NotNull PsiMember var1);

    public final List<Jam> findChildren(@NotNull PsiElementRef<? extends PsiMember> parentRef) {
        if (parentRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentRef", "com/intellij/jam/reflect/JamChildrenQuery", "findChildren"));
        }
        final PsiMember parent = parentRef.getPsiElement();
        if (parent == null) {
            return Collections.emptyList();
        }
        CachedValue data = (CachedValue)parent.getUserData(this.myCacheKey);
        if (data == null) {
            data = CachedValuesManager.getManager(parent.getProject()).createCachedValue(new CachedValueProvider<List<Jam>>(){

                @Override
                public CachedValueProvider.Result<List<Jam>> compute() {
                    return CachedValueProvider.Result.create(JamChildrenQuery.this.findChildren(parent), PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT);
                }
            }, false);
            parent.putUserData(this.myCacheKey, data);
        }
        return (List)data.getValue();
    }

    public static boolean isAnnotated(PsiModifierListOwner member, String fqn) {
        return AnnotationUtil.isAnnotated(member, fqn, false, true);
    }

    public static <Jam extends JamElement> JamChildrenQuery<Jam> composite(JamChildrenQuery<? extends Jam> ... components) {
        return new CompositeQuery<Jam>(components);
    }

    public static <Jam extends JamElement> JamChildrenQuery<Jam> annotatedMethods(JamAnnotationMeta annotationMeta, Class<Jam> jamClass) {
        return JamChildrenQuery.annotatedMethods(annotationMeta, new JamMethodMeta<Jam>(jamClass).addAnnotation(annotationMeta));
    }

    public static <Jam extends JamElement> JamChildrenQuery<Jam> annotatedMethods(JamAnnotationMeta annotationMeta, JamMemberMeta<PsiMethod, Jam> methodMeta) {
        return new AnnotatedMethodsQuery<Jam>(annotationMeta, methodMeta);
    }

    public static <Jam extends JamElement> JamChildrenQuery<Jam> annotatedFields(@NonNls String annotation, Class<Jam> jamClass) {
        return JamChildrenQuery.annotatedFields(new JamAnnotationMeta(annotation), jamClass);
    }

    public static <Jam extends JamElement> JamChildrenQuery<Jam> annotatedFields(JamAnnotationMeta annotationMeta, Class<Jam> jamClass) {
        return JamChildrenQuery.annotatedFields(annotationMeta, new JamFieldMeta<Jam>(jamClass).addAnnotation(annotationMeta));
    }

    public static <Jam extends JamElement> JamChildrenQuery<Jam> annotatedFields(JamAnnotationMeta annotationMeta, JamMemberMeta<PsiField, Jam> fieldMeta) {
        return new AnnotatedFieldsQuery<Jam>(annotationMeta, fieldMeta);
    }

    public static <Jam extends JamElement> JamChildrenQuery<Jam> annotatedParameters(JamAnnotationMeta annotationMeta, Class<Jam> jamClass) {
        return JamChildrenQuery.annotatedParameters(annotationMeta, new JamParameterMeta<Jam>(jamClass).addAnnotation(annotationMeta));
    }

    public static <Jam extends JamElement> JamChildrenQuery<Jam> annotatedParameters(JamAnnotationMeta annotationMeta, JamMemberMeta<PsiParameter, Jam> paramMeta) {
        return new AnnotatedParametersQuery<Jam>(annotationMeta, paramMeta);
    }

    private static class AnnotatedParametersQuery<Jam extends JamElement>
    extends JamAnnotatedChildrenQuery<Jam>
    implements JamRegisteringChildrenQuery {
        private final JamMemberMeta<PsiParameter, Jam> myParamMeta;

        public AnnotatedParametersQuery(JamAnnotationMeta annotationMeta, JamMemberMeta<PsiParameter, Jam> paramMeta) {
            super(annotationMeta);
            this.myParamMeta = paramMeta;
        }

        @Override
        @Nullable
        public JamMemberMeta<?, ? extends Jam> getMemberMeta(@NotNull PsiModifierListOwner member) {
            if (member == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/jam/reflect/JamChildrenQuery$AnnotatedParametersQuery", "getMemberMeta"));
            }
            return member instanceof PsiParameter ? this.myParamMeta : null;
        }

        @Override
        public PsiModifierListOwner[] getAllChildren(@NotNull PsiMember parent) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/jam/reflect/JamChildrenQuery$AnnotatedParametersQuery", "getAllChildren"));
            }
            return ((PsiMethod)parent).getParameterList().getParameters();
        }

        @Override
        public void registerSem(SemRegistrar registrar, ElementPattern<? extends PsiElement> parentPattern) {
            this.myParamMeta.register(registrar, (ElementPattern<PsiParameter>)((PsiParameterPattern)PsiJavaPatterns.psiParameter().withAnnotation(this.getAnnoName())).withSuperParent(2, parentPattern));
        }
    }

    private static class CompositeQuery<Jam extends JamElement>
    extends JamChildrenQuery<Jam>
    implements JamRegisteringChildrenQuery {
        private final JamChildrenQuery<? extends Jam>[] myComponents;

        public CompositeQuery(JamChildrenQuery<? extends Jam> ... components) {
            this.myComponents = components;
        }

        @Override
        public JamMemberMeta<?, ? extends Jam> getMeta(@NotNull PsiModifierListOwner member) {
            if (member == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/jam/reflect/JamChildrenQuery$CompositeQuery", "getMeta"));
            }
            for (JamChildrenQuery<Jam> jamChildrenQuery : this.myComponents) {
                JamMemberMeta<?, ? extends Jam> meta = jamChildrenQuery.getMeta(member);
                if (meta == null) continue;
                return meta;
            }
            return null;
        }

        @Override
        public List<Jam> findChildren(final @NotNull PsiMember parent) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/jam/reflect/JamChildrenQuery$CompositeQuery", "findChildren"));
            }
            return ContainerUtil.concat((Object[])this.myComponents, (Function)new Function<JamChildrenQuery<? extends Jam>, Collection<? extends Jam>>(){

                public Collection<? extends Jam> fun(JamChildrenQuery<? extends Jam> jamChildrenQuery) {
                    return jamChildrenQuery.findChildren(parent);
                }
            });
        }

        @Override
        public void registerSem(SemRegistrar registrar, ElementPattern<? extends PsiElement> parentPattern) {
            for (JamChildrenQuery<? extends Jam> component : this.myComponents) {
                if (!(component instanceof JamRegisteringChildrenQuery)) continue;
                ((JamRegisteringChildrenQuery)((Object)component)).registerSem(registrar, parentPattern);
            }
        }
    }

    private static class AnnotatedFieldsQuery<Jam extends JamElement>
    extends JamAnnotatedChildrenQuery<Jam>
    implements JamRegisteringChildrenQuery {
        private final JamMemberMeta<PsiField, Jam> myFieldMeta;

        public AnnotatedFieldsQuery(JamAnnotationMeta annotationMeta, JamMemberMeta<PsiField, Jam> fieldMeta) {
            super(annotationMeta);
            this.myFieldMeta = fieldMeta;
        }

        @Override
        public JamMemberMeta<?, ? extends Jam> getMemberMeta(@NotNull PsiModifierListOwner member) {
            if (member == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/jam/reflect/JamChildrenQuery$AnnotatedFieldsQuery", "getMemberMeta"));
            }
            return member instanceof PsiField ? this.myFieldMeta : null;
        }

        @Override
        public PsiModifierListOwner[] getAllChildren(@NotNull PsiMember parent) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/jam/reflect/JamChildrenQuery$AnnotatedFieldsQuery", "getAllChildren"));
            }
            return ((PsiClass)parent).getFields();
        }

        @Override
        public void registerSem(SemRegistrar registrar, ElementPattern<? extends PsiElement> parentPattern) {
            this.myFieldMeta.register(registrar, (ElementPattern<PsiField>)((PsiFieldPattern)PsiJavaPatterns.psiField().withAnnotation(this.getAnnoName())).inClass(parentPattern));
        }
    }

    private static class AnnotatedMethodsQuery<Jam extends JamElement>
    extends JamAnnotatedChildrenQuery<Jam>
    implements JamRegisteringChildrenQuery {
        private final JamMemberMeta<PsiMethod, Jam> myMethodMeta;

        public AnnotatedMethodsQuery(JamAnnotationMeta annotationMeta, JamMemberMeta<PsiMethod, Jam> methodMeta) {
            super(annotationMeta);
            this.myMethodMeta = methodMeta;
        }

        @Override
        public JamMemberMeta<?, ? extends Jam> getMemberMeta(@NotNull PsiModifierListOwner member) {
            if (member == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/jam/reflect/JamChildrenQuery$AnnotatedMethodsQuery", "getMemberMeta"));
            }
            return member instanceof PsiMethod ? this.myMethodMeta : null;
        }

        @Override
        public PsiModifierListOwner[] getAllChildren(@NotNull PsiMember parent) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/jam/reflect/JamChildrenQuery$AnnotatedMethodsQuery", "getAllChildren"));
            }
            return ((PsiClass)parent).getMethods();
        }

        @Override
        public void registerSem(SemRegistrar registrar, ElementPattern<? extends PsiElement> parentPattern) {
            this.myMethodMeta.register(registrar, (ElementPattern<PsiMethod>)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withAnnotation(this.getAnnoName())).inClass(parentPattern));
        }
    }
}

